/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;

public class NewTableReferenceDialog
extends AbstractValidatingDialog {
    private JTextField referenceNameTextField;
    private PropertyValueModel onDatabaseHolder;
    private ComboBoxModel sourceTablesModel;
    private ComboBoxModel targetTablesModel;
    private boolean allowSourceTableSelection;
    private boolean allowTargetTableSelection;

    public static NewTableReferenceDialog buildReferenceDialogAllowSourceAndTargetSelection(WorkbenchContext context, List sourceTables, List targetTables) {
        return new NewTableReferenceDialog(context, sourceTables, targetTables);
    }

    public static NewTableReferenceDialog buildReferenceDialogDisallowSourceTableSelection(WorkbenchContext context, List sourceTables, List targetTables) {
        return new NewTableReferenceDialog(context, sourceTables, targetTables, false);
    }

    public static NewTableReferenceDialog buildReferenceDialogDisallowTargetTableSelection(WorkbenchContext context, List sourceTables, List targetTables) {
        return new NewTableReferenceDialog(context, sourceTables, targetTables, true, false);
    }

    private NewTableReferenceDialog(WorkbenchContext context, List sourceTables, List targetTables) {
        this(context, sourceTables, targetTables, true);
    }

    private NewTableReferenceDialog(WorkbenchContext context, List sourceTables, List targetTables, boolean allowSourceTableSelection) {
        this(context, sourceTables, targetTables, allowSourceTableSelection, true);
    }

    private NewTableReferenceDialog(WorkbenchContext context, List sourceTables, List targetTables, boolean allowSourceTableSelection, boolean allowTargetTableSelection) {
        super(context);
        this.sourceTablesModel = new DefaultComboBoxModel<Object>(sourceTables.toArray());
        this.targetTablesModel = new DefaultComboBoxModel<Object>(targetTables.toArray());
        this.allowSourceTableSelection = allowSourceTableSelection;
        this.allowTargetTableSelection = allowTargetTableSelection;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("NEW_REFERENCE_DIALOG.title"));
        this.getOKAction().setEnabled(false);
    }

    protected Component initialFocusComponent() {
        return this.referenceNameTextField;
    }

    protected String helpTopicId() {
        return "dialog.newReference";
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel referenceNameLabel = SwingComponentFactory.buildLabel("enterNameOfNewReference", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)referenceNameLabel, constraints);
        this.referenceNameTextField = this.buildReferenceNameTextField();
        this.helpManager().addTopicID(this.referenceNameTextField, this.helpTopicId() + ".name");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)this.referenceNameTextField, constraints);
        referenceNameLabel.setLabelFor(this.referenceNameTextField);
        JLabel sourceTableLabel = SwingComponentFactory.buildLabel("selectTheSourceTable", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)sourceTableLabel, constraints);
        JComboBox sourceTableComboBox = this.buildSourceTableComboBox();
        this.helpManager().addTopicID(sourceTableComboBox, this.helpTopicId() + ".sourceTable");
        sourceTableLabel.setLabelFor(sourceTableComboBox);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)sourceTableComboBox, constraints);
        JLabel targetTableLabel = SwingComponentFactory.buildLabel("selectTheTargetTable", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)targetTableLabel, constraints);
        JComboBox targetTableComboBox = this.buildTargetTableComboBox();
        this.helpManager().addTopicID(targetTableComboBox, this.helpTopicId() + ".targetTable");
        targetTableLabel.setLabelFor(targetTableComboBox);
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        panel.add((Component)targetTableComboBox, constraints);
        JCheckBox onDatabaseCheckBox = this.buildOnDatabaseCheckBox();
        this.helpManager().addTopicID(onDatabaseCheckBox, this.helpTopicId() + ".onDatabase");
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)onDatabaseCheckBox, constraints);
        return panel;
    }

    private JTextField buildReferenceNameTextField() {
        JTextField textField = new JTextField();
        RegexpDocument document = new RegexpDocument(13);
        document.addDocumentListener(this.buildReferenceNameDocumentListener());
        textField.setDocument(document);
        return textField;
    }

    private DocumentListener buildReferenceNameDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                NewTableReferenceDialog.this.updateOKButton();
                NewTableReferenceDialog.this.updateErrorMessage();
            }

            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        };
    }

    private JComboBox buildSourceTableComboBox() {
        ListChooser listChooser = new ListChooser(this.sourceTablesModel);
        listChooser.setRenderer(this.buildTableListCellRenderer());
        listChooser.addActionListener(this.buildTableListener());
        listChooser.setEnabled(this.allowSourceTableSelection);
        return listChooser;
    }

    private ActionListener buildTableListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewTableReferenceDialog.this.updateReferenceName();
                NewTableReferenceDialog.this.updateOKButton();
            }
        };
    }

    private JComboBox buildTargetTableComboBox() {
        ListChooser listChooser = new ListChooser(this.targetTablesModel);
        listChooser.setRenderer(this.buildTableListCellRenderer());
        listChooser.addActionListener(this.buildTableListener());
        listChooser.setEnabled(this.allowTargetTableSelection);
        return listChooser;
    }

    private ListCellRenderer buildTableListCellRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private JCheckBox buildOnDatabaseCheckBox() {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setModel(this.buildOnDatabaseCheckBoxModel());
        checkBox.setText(this.resourceRepository().getString("onDatabase"));
        checkBox.setMnemonic(this.resourceRepository().getMnemonic("onDatabase"));
        return checkBox;
    }

    private ButtonModel buildOnDatabaseCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildOnDatabaseHolder());
    }

    private PropertyValueModel buildOnDatabaseHolder() {
        this.onDatabaseHolder = new SimplePropertyValueModel(Boolean.FALSE);
        return this.onDatabaseHolder;
    }

    public String getReferenceName() {
        return this.referenceNameTextField.getText();
    }

    public MWTable getSourceTable() {
        return (MWTable)this.sourceTablesModel.getSelectedItem();
    }

    public void setSourceTable(MWTable initialSourceTable) {
        this.sourceTablesModel.setSelectedItem(initialSourceTable);
    }

    public MWTable getTargetTable() {
        return (MWTable)this.targetTablesModel.getSelectedItem();
    }

    public void setTargetTable(MWTable initialTargetTable) {
        this.targetTablesModel.setSelectedItem(initialTargetTable);
    }

    public boolean isOnDatabase() {
        return (Boolean)this.onDatabaseHolder.getValue();
    }

    void updateOKButton() {
        boolean enableOKButton = this.referenceNameIsSpecified() && this.referenceNameIsValid() && this.getTargetTable() != null && this.getSourceTable() != null;
        this.getOKAction().setEnabled(enableOKButton);
    }

    void updateErrorMessage() {
        if (this.referenceNameIsValid()) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("REFERENCE_NAME_MUST_BE_UNIQUE_ERROR");
        }
    }

    void updateReferenceName() {
        String referenceName = this.getReferenceName();
        MWTable sourceTable = this.getSourceTable();
        MWTable targetTable = this.getTargetTable();
        if (sourceTable != null) {
            referenceName = sourceTable.getShortName() + "_";
            if (targetTable != null) {
                referenceName = referenceName + targetTable.getShortName();
            }
        } else if (targetTable != null) {
            referenceName = "_" + targetTable.getShortName();
        }
        this.referenceNameTextField.setText(referenceName);
        this.referenceNameTextField.selectAll();
        this.referenceNameTextField.requestFocus();
    }

    private boolean referenceNameIsSpecified() {
        return this.getReferenceName() != null && this.getReferenceName().length() != 0;
    }

    private boolean referenceNameIsValid() {
        if (this.getSourceTable() == null) {
            return true;
        }
        Iterator references = this.getSourceTable().references();
        while (references.hasNext()) {
            MWReference reference = (MWReference)references.next();
            String name = reference.getName();
            Collator ignoreCaseCollator = Collator.getInstance();
            ignoreCaseCollator.setStrength(0);
            if (ignoreCaseCollator.compare(name, this.getReferenceName()) != 0) continue;
            return false;
        }
        return true;
    }

    protected void prepareToShow() {
        this.updateReferenceName();
        super.prepareToShow();
    }
}

