/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class NewClassNameDialog
extends AbstractValidatingDialog {
    private PropertyValueModel shortClassNameHolder;
    private JTextField shortClassNameTextField;
    private JComboBox packageComboBox;
    protected final Collection packageNames;
    private final String initialPackageName;
    private final String initialShortClassName;
    private boolean allowExistingType;
    private final MWProject project;

    NewClassNameDialog(MWProject project, WorkbenchContext context) {
        this(Collections.EMPTY_SET, project, context);
    }

    NewClassNameDialog(Collection packageNames, MWProject project, WorkbenchContext context) {
        this(packageNames, "", project, context);
    }

    public NewClassNameDialog(Collection packageNames, String initialPackageName, MWProject project, WorkbenchContext context) {
        this(packageNames, initialPackageName, NewClassNameDialog.buildInitialShortClassName(initialPackageName, project, context), project, context);
    }

    public NewClassNameDialog(Collection packageNames, String initialPackageName, String initialShortClassName, MWProject project, WorkbenchContext context) {
        super(context);
        this.packageNames = packageNames;
        this.initialPackageName = initialPackageName;
        this.initialShortClassName = initialShortClassName;
        this.allowExistingType = true;
        this.project = project;
    }

    private static String buildInitialShortClassName(String packageName, MWProject project, WorkbenchContext context) {
        return NameTools.uniqueNameFor((String)context.getApplicationContext().getResourceRepository().getString("NEW_CLASS_NAME_DIALOG_INITIAL_CLASS_NAME"), (Iterator)NewClassNameDialog.descriptorNamesInPackage(packageName, project));
    }

    private static Iterator descriptorNamesInPackage(String packageName, MWProject project) {
        Iterator descriptors = project.descriptorsInPackage(packageName);
        return new TransformationIterator(descriptors){

            protected Object transform(Object next) {
                return ((MWDescriptor)next).shortName();
            }
        };
    }

    protected String helpTopicId() {
        return "dialog.createNewClass";
    }

    protected void initialize() {
        super.initialize();
        this.shortClassNameHolder = new SimplePropertyValueModel("");
        this.setTitle(this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_TITLE"));
    }

    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel packageLabel = SwingComponentFactory.buildLabel("NEW_CLASS_NAME_DIALOG_PACKAGE_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)packageLabel, constraints);
        this.packageComboBox = this.buildPackageComboBox();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.packageComboBox, constraints);
        packageLabel.setLabelFor(this.packageComboBox);
        JLabel shortClassNameLabel = SwingComponentFactory.buildLabel("NEW_CLASS_NAME_DIALOG_CLASS_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)shortClassNameLabel, constraints);
        this.shortClassNameTextField = new JTextField(this.buildShortClassNameDocumentAdapter(), null, 40);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add((Component)this.shortClassNameTextField, constraints);
        shortClassNameLabel.setLabelFor(this.shortClassNameTextField);
        return panel;
    }

    private JComboBox buildPackageComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setEditable(true);
        JTextField textField = this.packageComboBoxTextField(comboBox);
        textField.setDocument(new RegexpDocument(1));
        textField.getDocument().addDocumentListener(this.buildShortClassNameDocumentListener());
        comboBox.setModel(new ComboBoxModelAdapter(new ReadOnlyCollectionValueModel(this.packageNames), (PropertyValueModel)new SimplePropertyValueModel(this.initialPackageName)));
        return comboBox;
    }

    private JTextField packageComboBoxTextField() {
        return this.packageComboBoxTextField(this.packageComboBox);
    }

    private JTextField packageComboBoxTextField(JComboBox comboBox) {
        return (JTextField)comboBox.getEditor().getEditorComponent();
    }

    protected Component initialFocusComponent() {
        return this.shortClassNameTextField;
    }

    private Document buildShortClassNameDocumentAdapter() {
        DocumentAdapter adapter = new DocumentAdapter(this.shortClassNameHolder, this.buildShortClassNameDocument());
        adapter.addDocumentListener(this.buildShortClassNameDocumentListener());
        return adapter;
    }

    private RegexpDocument buildShortClassNameDocument() {
        return new RegexpDocument(2);
    }

    private DocumentListener buildShortClassNameDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.validateClassName();
            }

            public void insertUpdate(DocumentEvent e) {
                this.validateClassName();
            }

            public void removeUpdate(DocumentEvent e) {
                this.validateClassName();
            }

            private void validateClassName() {
                if (NewClassNameDialog.this.isVisible()) {
                    NewClassNameDialog.this.validateClassName();
                }
            }
        };
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.shortClassNameHolder.setValue(this.initialShortClassName);
        this.shortClassNameTextField.selectAll();
        this.validateClassName();
    }

    public void setAllowExistingType(boolean allowExistingType) {
        this.allowExistingType = allowExistingType;
    }

    public String packageName() {
        String packageName = this.packageComboBoxTextField().getText().trim();
        if (packageName.endsWith(".")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    public String shortClassName() {
        return this.shortClassNameTextField.getText().trim();
    }

    public String className() {
        String packageName = this.packageName();
        String className = this.shortClassName();
        return packageName.length() == 0 ? className : packageName + '.' + className;
    }

    void validateClassName() {
        String message;
        block2: {
            block8: {
                block9: {
                    String className;
                    block7: {
                        String classNameToLowerCase;
                        block6: {
                            String shortClassName;
                            block5: {
                                block4: {
                                    block3: {
                                        block1: {
                                            shortClassName = this.shortClassName();
                                            className = this.className();
                                            classNameToLowerCase = className.toLowerCase();
                                            message = null;
                                            if (shortClassName.length() != 0) break block1;
                                            message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_NO_CLASS_NAME_SPECIFIED");
                                            break block2;
                                        }
                                        if (!NameTools.javaReservedWordsContains((String)shortClassName)) break block3;
                                        message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_INVALID", shortClassName);
                                        break block2;
                                    }
                                    if (!MWClassRepository.coreClassNamesContains((String)className)) break block4;
                                    message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_RESERVED", className);
                                    break block2;
                                }
                                String collisionCoreTypeName = MWClassRepository.coreClassNameIgnoreCase((String)className);
                                if (collisionCoreTypeName == null) break block5;
                                message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_RESERVED_DIFFERENT_CASE", collisionCoreTypeName);
                                break block2;
                            }
                            if (className.toLowerCase().equals(this.initialClassName().toLowerCase())) break block2;
                            if (!CollectionTools.contains((Iterator)this.descriptorNames(), (Object)className) || className.equals(this.initialClassName())) break block6;
                            message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_DESCRIPTOR_ALREADY_EXISTS", shortClassName);
                            break block2;
                        }
                        if (!CollectionTools.contains((Iterator)this.descriptorNamesToLowerCase(), (Object)classNameToLowerCase)) break block7;
                        message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_DESCRIPTOR_ALREADY_EXISTS_DIFFERENT_CASE");
                        break block2;
                    }
                    MWClass collisionType = this.project.getRepository().typeNamedIgnoreCase(className);
                    if (collisionType == null) break block8;
                    if (!collisionType.getName().equals(className)) break block9;
                    if (this.allowExistingType) break block2;
                    message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_ALREADY_EXISTS", className);
                    break block2;
                }
                message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_ALREADY_EXISTS_DIFFERENT_CASE");
                break block2;
            }
            String[] pkgSegments = this.packageName().split("\\.");
            for (int i = 0; i < pkgSegments.length; ++i) {
                String pkgSegment = pkgSegments[i];
                if (!NameTools.javaReservedWordsContains((String)pkgSegment)) continue;
                message = this.resourceRepository().getString("NEW_CLASS_NAME_DIALOG_CLASS_NAME_INVALID", pkgSegment);
                break;
            }
        }
        this.setErrorMessage(message);
        this.getOKAction().setEnabled(message == null);
    }

    private Iterator descriptorNames() {
        return new TransformationIterator(this.project.descriptors()){

            protected Object transform(Object next) {
                return ((MWDescriptor)next).getName();
            }
        };
    }

    private Iterator descriptorNamesToLowerCase() {
        return new TransformationIterator(this.descriptorNames()){

            protected Object transform(Object next) {
                return ((String)next).toLowerCase();
            }
        };
    }

    private String initialClassName() {
        return this.initialPackageName + '.' + this.initialShortClassName;
    }
}

