/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class GeneralPreferencesPage
extends AbstractPanel {
    private List lafInfos;
    private static final long serialVersionUID = 1L;

    GeneralPreferencesPage(PreferencesContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.buildLookAndFeelList();
        this.intializeLayout();
    }

    private void buildLookAndFeelList() {
        this.lafInfos = new ArrayList();
        CollectionTools.addAll((Collection)this.lafInfos, (Object[])UIManager.getInstalledLookAndFeels());
        this.lafInfos.add(new UIManager.LookAndFeelInfo("Oracle", "oracle.bali.ewt.olaf2.OracleLookAndFeel"));
        Collections.sort(this.lafInfos, this.buildLookAndFeelComparator());
    }

    private void intializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel scrollPaneView = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(scrollPaneView);
        scrollPane.getVerticalScrollBar().setBlockIncrement(20);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        this.add((Component)scrollPane, "Center");
        JPanel container = new JPanel(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        scrollPaneView.add((Component)container, constraints);
        JCheckBox splashScreenCheckBox = this.buildCheckBox("PREFERENCES.GENERAL.DISPLAY_SPLASH_SCREEN", this.buildDisplaySplashScreenModel());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)splashScreenCheckBox, constraints);
        JComponent lookAndFeelComboBox = this.buildLabeledComboBox("PREFERENCES.GENERAL.LOOK_AND_FEEL", this.buildLookAndFeelComboBoxModel(), this.buildLookAndFeelListCellRenderer());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)lookAndFeelComboBox, constraints);
        JComponent recentFilesSizeSpinner = this.buildRecentFilesSizeSpinner();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)recentFilesSizeSpinner, constraints);
        JComponent proxyHostTextField = this.buildLabeledTextField("PREFERENCES.GENERAL.HTTP.PROXY.HOST", this.buildProxyHostDocumentAdapter());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)proxyHostTextField, constraints);
        JComponent proxyPortTextField = this.buildLabeledTextField("PREFERENCES.GENERAL.HTTP.PROXY.PORT", this.buildProxyPortDocumentAdapter());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)proxyPortTextField, constraints);
        JComponent networkConnectTimeoutTextField = this.buildLabeledTextField("PREFERENCES.GENERAL.NETWORK.CONNECT_TIMEOUT", this.buildNetworkConnectTimeoutDocumentAdapter());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)networkConnectTimeoutTextField, constraints);
        JComponent networkReadTimeoutTextField = this.buildLabeledTextField("PREFERENCES.GENERAL.NETWORK.READ_TIMEOUT", this.buildNetworkReadTimeoutDocumentAdapter());
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)networkReadTimeoutTextField, constraints);
        JCheckBox reopenCheckBox = this.buildCheckBox("PREFERENCES.GENERAL.REOPEN_PROJECTS", this.buildReopenProjectsModel());
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)reopenCheckBox, constraints);
        this.addHelpTopicId(this, "preferences.general");
    }

    private ButtonModel buildDisplaySplashScreenModel() {
        return new CheckBoxModelAdapter(this.buildBufferedDisplaySplashScreenAdapter());
    }

    private PropertyValueModel buildBufferedDisplaySplashScreenAdapter() {
        return new BufferedPropertyValueModel(this.buildDisplaySplashScreenAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDisplaySplashScreenAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "display splash screen", true);
        adapter.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return adapter;
    }

    private ComboBoxModel buildLookAndFeelComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildLookAndFeelCollectionHolder(), this.buildBufferedLookAndFeelAdapter());
    }

    private CollectionValueModel buildLookAndFeelCollectionHolder() {
        return new ReadOnlyCollectionValueModel(this.lafInfos);
    }

    private Comparator buildLookAndFeelComparator() {
        return new Comparator(){

            public int compare(Object object1, Object object2) {
                UIManager.LookAndFeelInfo lafInfo1 = (UIManager.LookAndFeelInfo)object1;
                UIManager.LookAndFeelInfo lafInfo2 = (UIManager.LookAndFeelInfo)object2;
                return Collator.getInstance().compare(lafInfo1.getName(), lafInfo2.getName());
            }
        };
    }

    private PropertyValueModel buildBufferedLookAndFeelAdapter() {
        BufferedPropertyValueModel adapter = new BufferedPropertyValueModel(this.buildLookAndFeelAdapter(), this.getPreferencesContext().getBufferTrigger());
        return new TransformationPropertyValueModel(adapter){

            protected Object reverseTransform(Object value) {
                UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)value;
                return info.getClassName();
            }

            protected Object transform(Object value) {
                String className = (String)value;
                return GeneralPreferencesPage.this.getLookAndFeelInfo(className);
            }
        };
    }

    private PropertyValueModel buildLookAndFeelAdapter() {
        String lafClassName = UIManager.getLookAndFeel().getClass().getName();
        return new PreferencePropertyValueModel(this.preferences(), "look and feel", (Object)lafClassName);
    }

    private ListCellRenderer buildLookAndFeelListCellRenderer() {
        return new SimpleListCellRenderer(){
            private static final long serialVersionUID = 1L;

            protected String buildText(Object value) {
                UIManager.LookAndFeelInfo info = (UIManager.LookAndFeelInfo)value;
                return info == null ? null : info.getName();
            }
        };
    }

    private JComponent buildRecentFilesSizeSpinner() {
        JComponent component = this.buildLabeledSpinnerNumber("PREFERENCES.GENERAL.RECENT_FILES_SIZE", this.buildRecentFilesSizeSpinnerModel());
        JSpinner spinner = (JSpinner)component.getComponent(1);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setEditable(false);
        return component;
    }

    private SpinnerNumberModel buildRecentFilesSizeSpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildBufferedRecentFilesSizeAdapter(), 0, 9, 1, 4);
    }

    private PropertyValueModel buildBufferedRecentFilesSizeAdapter() {
        return new BufferedPropertyValueModel(this.buildRecentFilesSizeAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildRecentFilesSizeAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "recent files max size", 4);
        adapter.setConverter(this.buildRecentFilesSizeConverter());
        return adapter;
    }

    private BidiStringConverter buildRecentFilesSizeConverter() {
        return new BidiStringConverter(){

            public String convertToString(Object o) {
                return o == null ? null : ((Integer)o).toString();
            }

            public Object convertToObject(String s) {
                if (s == null) {
                    return new Integer(4);
                }
                Integer i = new Integer(s);
                if (i < 0 || i > 9) {
                    return new Integer(4);
                }
                return i;
            }

            public String toString() {
                return "RecentFilesManager-IntegerStringConverter";
            }
        };
    }

    private Document buildProxyHostDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedProxyHostAdapter());
    }

    private PropertyValueModel buildBufferedProxyHostAdapter() {
        return new BufferedPropertyValueModel(this.buildProxyHostAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildProxyHostAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "http proxy host", (Object)"");
    }

    private Document buildProxyPortDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedProxyPortAdapter());
    }

    private PropertyValueModel buildBufferedProxyPortAdapter() {
        return new BufferedPropertyValueModel(this.buildProxyPortAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildProxyPortAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "http proxy port", (Object)"80");
    }

    private Document buildNetworkConnectTimeoutDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedNetworkConnectTimeoutAdapter());
    }

    private PropertyValueModel buildBufferedNetworkConnectTimeoutAdapter() {
        return new BufferedPropertyValueModel(this.buildNetworkConnectTimeoutAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildNetworkConnectTimeoutAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "network connect timeout", (Object)"10");
    }

    private Document buildNetworkReadTimeoutDocumentAdapter() {
        return new DocumentAdapter(this.buildBufferedNetworkReadTimeoutAdapter());
    }

    private PropertyValueModel buildBufferedNetworkReadTimeoutAdapter() {
        return new BufferedPropertyValueModel(this.buildNetworkReadTimeoutAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildNetworkReadTimeoutAdapter() {
        return new PreferencePropertyValueModel(this.preferences(), "network read timeout", (Object)"10");
    }

    private ButtonModel buildReopenProjectsModel() {
        return new CheckBoxModelAdapter(this.buildBufferedReopenProjectsAdapter());
    }

    private PropertyValueModel buildBufferedReopenProjectsAdapter() {
        return new BufferedPropertyValueModel(this.buildReopenProjectsAdapter(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildReopenProjectsAdapter() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "reopen projects", true);
        adapter.setConverter(BidiStringConverter.BOOLEAN_CONVERTER);
        return adapter;
    }

    UIManager.LookAndFeelInfo getLookAndFeelInfo(String className) {
        for (UIManager.LookAndFeelInfo info : this.lafInfos) {
            if (!info.getClassName().equals(className)) continue;
            return info;
        }
        return null;
    }
}

