/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SignatureAttribute
extends Attribute {
    private short signatureIndex;

    public SignatureAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        this.signatureIndex = stream.readU2();
    }

    void displayInfoStringOn(IndentingPrintWriter writer) {
        writer.println(this.signature());
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String signature() {
        return this.constantPool().getUTF8String(this.signatureIndex);
    }

    public short getSignatureIndex() {
        return this.signatureIndex;
    }

    void toString(StringBuffer sb) {
        sb.append(this.signature());
    }
}

