/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Iterator;
import java.util.List;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ReferencedSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ExplicitAttributeDeclaration
extends AbstractNamedSchemaComponent
implements MWAttributeDeclaration {
    private volatile MWSimpleTypeDefinition type;
    private volatile String use;
    private volatile String defaultValue;
    private volatile String fixedValue;

    private ExplicitAttributeDeclaration() {
    }

    ExplicitAttributeDeclaration(MWModel parent, String name) {
        super(parent, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.type = new ReferencedSimpleTypeDefinition(this, "anySimpleType", "http://www.w3.org/2001/XMLSchema");
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.type);
    }

    public MWSimpleTypeDefinition getType() {
        return this.type;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public String getUse() {
        return this.use;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public Iterator baseBuiltInTypes() {
        return this.type.baseBuiltInTypes();
    }

    public boolean hasType() {
        return true;
    }

    public String contextTypeQname() {
        return this.type.contextTypeQname();
    }

    public boolean containsText() {
        return false;
    }

    public boolean containsWildcard() {
        return false;
    }

    public int compareSchemaOrder(MWElementDeclaration element1, MWElementDeclaration element2) {
        return 0;
    }

    public String componentTypeName() {
        return "attribute";
    }

    public Iterator structuralComponents() {
        return NullIterator.instance();
    }

    protected void reloadInternal(XSObject xsAttrUse) {
        XSAttributeUseImpl attributeUseImpl = null;
        XSAttributeDecl attributeDecl = null;
        if (xsAttrUse instanceof XSAttributeUseImpl) {
            attributeUseImpl = (XSAttributeUseImpl)xsAttrUse;
            attributeDecl = (XSAttributeDecl)attributeUseImpl.getAttrDeclaration();
            super.reloadInternal((XSObject)attributeDecl);
            this.reloadUse(attributeUseImpl);
        } else {
            attributeDecl = (XSAttributeDecl)xsAttrUse;
            super.reloadInternal((XSObject)attributeDecl);
        }
        this.reloadType(attributeDecl);
        if (attributeDecl.getConstraintType() != 0) {
            if (attributeDecl.getConstraintType() == 1) {
                this.defaultValue = attributeDecl.getConstraintValue();
            } else if (attributeDecl.getConstraintType() == 2) {
                this.fixedValue = attributeDecl.getConstraintValue();
            }
        }
    }

    private void reloadType(XSAttributeDecl attributeDecl) {
        MWSimpleTypeDefinition oldType = this.type;
        XSSimpleTypeDecl simpleTypeDecl = (XSSimpleTypeDecl)attributeDecl.getTypeDefinition();
        this.type = MWSimpleTypeDefinition.Reloader.reloadedSimpleType(this, oldType, (XSSimpleTypeDefinition)simpleTypeDecl);
        if (oldType != this.type) {
            this.getProject().nodeRemoved(oldType);
        }
    }

    private void reloadUse(XSAttributeUseImpl attributeUseImpl) {
        this.use = attributeUseImpl.getRequired() ? "required" : "optional";
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.type.resolveReferences();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(ExplicitAttributeDeclaration.class);
        descriptor.getInheritancePolicy().setParentClass(AbstractNamedSchemaComponent.class);
        descriptor.addDirectMapping("defaultValue", "default-value/text()");
        descriptor.addDirectMapping("fixedValue", "fixed-value/text()");
        ObjectTypeConverter useMappingConverter = new ObjectTypeConverter();
        useMappingConverter.addConversionValue((Object)"optional", (Object)"optional");
        useMappingConverter.addConversionValue((Object)"required", (Object)"required");
        useMappingConverter.addConversionValue((Object)"prohibited", (Object)"prohibited");
        XMLDirectMapping useMapping = new XMLDirectMapping();
        useMapping.setAttributeName("use");
        useMapping.setXPath("use/text()");
        useMapping.setConverter((Converter)useMappingConverter);
        descriptor.addMapping((DatabaseMapping)useMapping);
        XMLCompositeObjectMapping typeMapping = new XMLCompositeObjectMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setXPath("type");
        typeMapping.setReferenceClass(AbstractSchemaComponent.class);
        descriptor.addMapping((DatabaseMapping)typeMapping);
        return descriptor;
    }
}

