/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWAbstractReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWIndirectableMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWProxyIndirectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWColumnQueryKeyPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;

public final class MWVariableOneToOneMapping
extends MWAbstractReferenceMapping
implements MWProxyIndirectionMapping,
MWClassIndicatorPolicy.Parent,
MWRelationalClassIndicatorFieldPolicy.Parent {
    private Collection columnQueryKeyPairs;
    public static final String COLUMN_QUERY_KEY_PAIRS_COLLECTION = "columnQueryKeyPairs";
    private volatile MWRelationalClassIndicatorFieldPolicy classIndicatorPolicy;
    private static final PartialStringMatcher COLUMN_NAME_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWVariableOneToOneMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWAbstractReferenceMapping.class);
        XMLCompositeCollectionMapping columnQueryKeyPairsMapping = new XMLCompositeCollectionMapping();
        columnQueryKeyPairsMapping.setAttributeName(COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        columnQueryKeyPairsMapping.setGetMethodName("getColumnQueryKeyPairsForTopLink");
        columnQueryKeyPairsMapping.setSetMethodName("setColumnQueryKeyPairsForTopLink");
        columnQueryKeyPairsMapping.setReferenceClass(MWColumnQueryKeyPair.class);
        columnQueryKeyPairsMapping.setXPath("column-query-key-pairs/column-query-key-pair");
        descriptor.addMapping((DatabaseMapping)columnQueryKeyPairsMapping);
        XMLCompositeObjectMapping classIndicatorPolicyMapping = new XMLCompositeObjectMapping();
        classIndicatorPolicyMapping.setAttributeName("classIndicatorPolicy");
        classIndicatorPolicyMapping.setReferenceClass(MWRelationalClassIndicatorFieldPolicy.class);
        classIndicatorPolicyMapping.setXPath("class-indicator-policy");
        descriptor.addMapping((DatabaseMapping)classIndicatorPolicyMapping);
        return descriptor;
    }

    private MWVariableOneToOneMapping() {
    }

    MWVariableOneToOneMapping(MWRelationalClassDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.columnQueryKeyPairs = new Vector();
        this.classIndicatorPolicy = new MWRelationalClassIndicatorFieldPolicy(this);
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        if (!this.getInstanceVariable().isValueHolder() && this.getInstanceVariable().getType().isInterface()) {
            this.indirectionType = "proxy-indirection";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.columnQueryKeyPairs;
        synchronized (collection) {
            children.addAll(this.columnQueryKeyPairs);
        }
        children.add(this.classIndicatorPolicy);
    }

    public MWRelationalClassIndicatorFieldPolicy getClassIndicatorPolicy() {
        return this.classIndicatorPolicy;
    }

    public void setReferenceDescriptor(MWDescriptor newValue) {
        super.setReferenceDescriptor(newValue);
        if (newValue != null) {
            this.getClassIndicatorPolicy().resetDescriptorAvailableForIndication(((MWRelationalProject)this.getProject()).descriptorsThatImplement((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())));
        } else {
            this.getClassIndicatorPolicy().resetDescriptorAvailableForIndication(NullIterator.instance());
        }
    }

    public boolean descriptorIsValidReferenceDescriptor(MWDescriptor descriptor) {
        return ((MWRelationalDescriptor)((Object)descriptor)).isInterfaceDescriptor();
    }

    public MWColumnQueryKeyPair addColumnQueryKeyPair(MWColumn column, String queryKeyName) {
        return this.addColumnQueryKeyPair(new MWColumnQueryKeyPair(this, column, queryKeyName));
    }

    private MWColumnQueryKeyPair addColumnQueryKeyPair(MWColumnQueryKeyPair columnQueryKeyPair) {
        this.addItemToCollection(columnQueryKeyPair, this.columnQueryKeyPairs, COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
        return columnQueryKeyPair;
    }

    public void removeColumnQueryKeyPair(MWColumnQueryKeyPair columnQueryKeyPair) {
        this.removeItemFromCollection(columnQueryKeyPair, this.columnQueryKeyPairs, COLUMN_QUERY_KEY_PAIRS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this.getParentDescriptor());
    }

    public Iterator columnQueryKeyPairs() {
        return new CloneIterator(this.columnQueryKeyPairs);
    }

    public int columnQueryKeyPairsSize() {
        return this.columnQueryKeyPairs.size();
    }

    public Iterator queryKeyNameChoices() {
        if (this.getReferenceDescriptor() == null) {
            return NullIterator.instance();
        }
        return ((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).allQueryKeyNames();
    }

    public Collection invalidQueryKeyNames() {
        ArrayList<String> namesOfInvalidQueryKeys = new ArrayList<String>();
        MWRelationalDescriptor referenceDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (this.columnQueryKeyPairsSize() > 0 && referenceDescriptor != null) {
            Iterator associations = this.columnQueryKeyPairs();
            while (associations.hasNext()) {
                MWColumnQueryKeyPair pair = (MWColumnQueryKeyPair)associations.next();
                if (referenceDescriptor.queryKeyNamed(pair.getQueryKeyName()) != null) continue;
                namesOfInvalidQueryKeys.add(pair.getQueryKeyName());
            }
        }
        return namesOfInvalidQueryKeys;
    }

    public boolean usesProxyIndirection() {
        return this.getIndirectionType() == "proxy-indirection";
    }

    public void setUseProxyIndirection() {
        this.setIndirectionType("proxy-indirection");
    }

    public String iconKey() {
        return "mapping.variableOneToOne";
    }

    public void implementorsChangedFor(MWInterfaceDescriptor descriptor) {
        if (this.getReferenceDescriptor() == descriptor) {
            Collection implementors = CollectionTools.collection(((MWRelationalProject)this.getProject()).descriptorsThatImplement(descriptor));
            this.removeOldIndicators(implementors);
            this.addNewIndicators(implementors);
        }
    }

    private void removeOldIndicators(Collection currentImplementors) {
        for (MWClassIndicatorValue value : CollectionTools.collection(this.classIndicatorPolicy.classIndicatorValues())) {
            if (currentImplementors.contains(value.getDescriptorValue())) continue;
            this.getClassIndicatorPolicy().removeIndicator(value);
        }
    }

    private void addNewIndicators(Collection currentImplementors) {
        for (MWMappingDescriptor classDescriptor : currentImplementors) {
            if (this.getClassIndicatorPolicy().getClassIndicatorValueForDescriptor(classDescriptor) != null) continue;
            this.getClassIndicatorPolicy().addIndicator(null, classDescriptor);
        }
    }

    public void parentDescriptorMorphedToAggregate() {
        super.parentDescriptorMorphedToAggregate();
        Iterator stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            ((MWColumnQueryKeyPair)stream.next()).setColumn(null);
        }
        this.getClassIndicatorPolicy().setField(null);
    }

    protected Collection buildAggregateFieldNameGenerators() {
        Collection generators = super.buildAggregateFieldNameGenerators();
        generators.add(this.classIndicatorPolicy);
        Iterator stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            generators.add(stream.next());
        }
        return generators;
    }

    public MWVariableOneToOneMapping asMWVariableOneToOneMapping() {
        return this;
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWVariableOneToOneMapping(this);
    }

    protected void initializeFromMWIndirectableContainerMapping(MWIndirectableContainerMapping oldMapping) {
        super.initializeFromMWIndirectableContainerMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        } else if (oldMapping.usesNoIndirection()) {
            this.setUseNoIndirection();
        }
    }

    protected void initializeFromMWIndirectableMapping(MWIndirectableMapping oldMapping) {
        super.initializeFromMWIndirectableMapping(oldMapping);
        if (oldMapping.usesValueHolderIndirection()) {
            this.setUseValueHolderIndirection();
        }
    }

    public void addWrittenFieldsTo(Collection writtenFields) {
        if (this.isReadOnly()) {
            return;
        }
        Iterator stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            MWColumnQueryKeyPair association = (MWColumnQueryKeyPair)stream.next();
            if (association.getColumn() == null) continue;
            writtenFields.add(association.getColumn());
        }
        if (this.getClassIndicatorPolicy().getField() != null) {
            writtenFields.add(this.getClassIndicatorPolicy().getField());
        }
    }

    public boolean parentDescriptorIsAggregate() {
        return ((MWRelationalDescriptor)((Object)this.getParentDescriptor())).isAggregateDescriptor();
    }

    public MWRelationalDescriptor getParentRelationalDescriptor() {
        return (MWRelationalDescriptor)((Object)this.getParentDescriptor());
    }

    public MWMappingDescriptor getContainingDescriptor() {
        return this.getParentDescriptor();
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.addNoQueryKeyAssociationsProblemTo(newProblems);
        this.addForeignKeyFieldsInvalidProblemTo(newProblems);
        this.addForeignKeysNotSpecifiedProblemTo(newProblems);
        this.addInvalidQueryKeysProblemsTo(newProblems);
        this.addClassIndicatorValueProblemsTo(newProblems);
    }

    protected String referenceDescriptorInvalidProblemString() {
        return "0516";
    }

    private void addNoQueryKeyAssociationsProblemTo(List newProblems) {
        if (this.columnQueryKeyPairsSize() == 0) {
            newProblems.add(this.buildProblem("0510"));
        }
    }

    private void addForeignKeyFieldsInvalidProblemTo(List newProblems) {
        ArrayList columns = new ArrayList();
        Iterator stream = this.getParentRelationalDescriptor().associatedTables();
        while (stream.hasNext()) {
            CollectionTools.addAll(columns, ((MWTable)stream.next()).columns());
        }
        stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            MWColumnQueryKeyPair pair = (MWColumnQueryKeyPair)stream.next();
            MWColumn column = pair.getColumn();
            if (column == null || columns.contains(column)) continue;
            newProblems.add(this.buildProblem("0517", column.getName(), pair.getQueryKeyName()));
        }
    }

    private void addForeignKeysNotSpecifiedProblemTo(List newProblems) {
        boolean pass = true;
        Iterator stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            MWColumnQueryKeyPair pair = (MWColumnQueryKeyPair)stream.next();
            pass &= pair.getColumn() != null;
        }
        if (!this.parentDescriptorIsAggregate() && !pass) {
            newProblems.add(this.buildProblem("0511"));
        }
    }

    private void addInvalidQueryKeysProblemsTo(List newProblems) {
        ArrayList args = new ArrayList();
        Iterator stream = this.invalidQueryKeyNames().iterator();
        while (stream.hasNext()) {
            args.add(stream.next());
        }
        if (!args.isEmpty()) {
            newProblems.add(this.buildProblem("0512", args));
        }
    }

    public void addClassIndicatorFieldNotSpecifiedProblemTo(List newProblems) {
        boolean uniqueForeignKeyFields = true;
        if (this.columnQueryKeyPairsSize() == 0) {
            uniqueForeignKeyFields = false;
        }
        Iterator stream = this.columnQueryKeyPairs();
        while (stream.hasNext()) {
            MWColumn column = ((MWColumnQueryKeyPair)stream.next()).getColumn();
            if (column == null) continue;
            uniqueForeignKeyFields &= column.isPrimaryKey() || column.isUnique();
        }
        if (uniqueForeignKeyFields) {
            return;
        }
        if (!this.parentDescriptorIsAggregate() && this.getClassIndicatorPolicy().getField() == null) {
            newProblems.add(this.buildProblem("0513"));
        }
    }

    private void addClassIndicatorValueProblemsTo(List newProblems) {
        MWRelationalDescriptor refDescriptor = (MWRelationalDescriptor)((Object)this.getReferenceDescriptor());
        if (refDescriptor == null || !refDescriptor.isInterfaceDescriptor()) {
            return;
        }
        Iterator stream = this.getClassIndicatorPolicy().classIndicatorValues();
        while (stream.hasNext()) {
            MWClassIndicatorValue value = (MWClassIndicatorValue)stream.next();
            if (CollectionTools.collection(refDescriptor.implementors()).contains(value.getDescriptorValue()) || !value.isInclude()) continue;
            newProblems.add(this.buildClassIndicatorValueInvalidProblem(value.getDescriptorValue()));
        }
    }

    private Problem buildClassIndicatorValueInvalidProblem(MWDescriptor descriptorValue) {
        return this.buildProblem("0515", descriptorValue.getName(), this.getReferenceDescriptor().getName());
    }

    public void automap() {
        super.automap();
        this.automapClassIndicatorField();
    }

    private void automapClassIndicatorField() {
        if (this.getClassIndicatorPolicy().getField() != null || this.parentDescriptorIsAggregate()) {
            return;
        }
        MWTable primaryTable = ((MWTableDescriptor)this.getParentDescriptor()).getPrimaryTable();
        if (primaryTable == null) {
            return;
        }
        StringHolder[] columnStringHolders = ColumnStringHolder.buildHolders(primaryTable.nonPrimaryKeyColumns());
        PartialStringMatcher.StringHolderScore shs = COLUMN_NAME_MATCHER.match(this.getName().toLowerCase(), columnStringHolders);
        if (shs.getScore() > 0.5) {
            this.getClassIndicatorPolicy().setField(((ColumnStringHolder)shs.getStringHolder()).getColumn());
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new VariableOneToOneMapping();
    }

    public DatabaseMapping runtimeMapping() {
        VariableOneToOneMapping runtimeMapping = (VariableOneToOneMapping)super.runtimeMapping();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getMWClass() != null) {
            runtimeMapping.setReferenceClassName(this.getReferenceDescriptor().getMWClass().getName());
        }
        Iterator associations = this.columnQueryKeyPairs();
        while (associations.hasNext()) {
            ((MWColumnQueryKeyPair)associations.next()).adjustRuntimeMapping(runtimeMapping);
        }
        this.classIndicatorPolicy.adjustRuntimeMapping(runtimeMapping);
        if (this.usesProxyIndirection()) {
            runtimeMapping.setIndirectionPolicy((IndirectionPolicy)new ProxyIndirectionPolicy());
        }
        return runtimeMapping;
    }

    private Collection getColumnQueryKeyPairsForTopLink() {
        return new TreeSet(this.columnQueryKeyPairs);
    }

    private void setColumnQueryKeyPairsForTopLink(Collection columnQueryKeyPairs) {
        this.columnQueryKeyPairs = columnQueryKeyPairs;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.getReferenceDescriptor() != null) {
            this.classIndicatorPolicy.setDescriptorsAvailableForIndicatorDictionaryForTopLink(((MWRelationalDescriptor)((Object)this.getReferenceDescriptor())).implementors());
        } else {
            this.classIndicatorPolicy.setDescriptorsAvailableForIndicatorDictionary(NullIterator.instance());
        }
    }

    private MWTable findBestMatchingTable(String tableName) {
        Iterator i = this.getDatabase().tables();
        while (i.hasNext()) {
            MWTable table = (MWTable)i.next();
            if (!table.getShortName().equals(tableName)) continue;
            return table;
        }
        return null;
    }
}

