/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWTypeConverter
extends MWConverter {
    private volatile MWTypeDeclaration dataType;
    public static final String DATA_TYPE_PROPERTY = "dataType";
    private volatile MWTypeDeclaration attributeType;
    public static final String ATTRIBUTE_TYPE_PROPERTY = "attributeType";

    protected MWTypeConverter() {
    }

    protected MWTypeConverter(MWConverterMapping parent) {
        super(parent);
    }

    protected MWTypeConverter(MWConverterMapping parent, Map legacyValueMap) {
        super(parent);
        this.legacyInitialize(legacyValueMap);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.attributeType = new MWTypeDeclaration((MWModel)this, this.typeFor(String.class));
        this.dataType = new MWTypeDeclaration((MWModel)this, this.typeFor(String.class));
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.attributeType);
        children.add(this.dataType);
    }

    protected void legacyInitialize(Map legacyValuesMap) {
        String attributeTypeString;
        String databaseTypeString = (String)legacyValuesMap.remove("database-type");
        if (databaseTypeString != null) {
            MWClass databaseType = this.typeNamed(databaseTypeString);
            this.dataType = new MWTypeDeclaration((MWModel)this, databaseType);
        }
        if ((attributeTypeString = (String)legacyValuesMap.remove("object-type")) != null) {
            MWClass attributeType = this.typeNamed(attributeTypeString);
            this.attributeType = new MWTypeDeclaration((MWModel)this, attributeType);
        }
    }

    public MWTypeDeclaration getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(MWTypeDeclaration newAttributeType) {
        if (newAttributeType == null) {
            throw new NullPointerException("attributeType cannot be null");
        }
        MWTypeDeclaration oldAttributeType = this.getAttributeType();
        this.attributeType = newAttributeType;
        this.firePropertyChanged(ATTRIBUTE_TYPE_PROPERTY, oldAttributeType, newAttributeType);
        if (oldAttributeType != newAttributeType) {
            this.rebuildValuePairs();
        }
    }

    protected void rebuildValuePairs() {
    }

    public MWTypeDeclaration getDataType() {
        return this.dataType;
    }

    public void setDataType(MWTypeDeclaration newValue) {
        if (newValue == null) {
            throw new NullPointerException("dataType cannot be null");
        }
        MWTypeDeclaration oldValue = this.getDataType();
        this.dataType = newValue;
        if (oldValue.getType() != newValue.getType()) {
            this.firePropertyChanged(DATA_TYPE_PROPERTY, oldValue, newValue);
            this.rebuildValuePairs();
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTypeConverter.class);
        descriptor.getInheritancePolicy().setParentClass(MWConverter.class);
        XMLCompositeObjectMapping dataTypeMapping = new XMLCompositeObjectMapping();
        dataTypeMapping.setAttributeName(DATA_TYPE_PROPERTY);
        dataTypeMapping.setReferenceClass(MWTypeDeclaration.class);
        dataTypeMapping.setXPath("data-type");
        descriptor.addMapping((DatabaseMapping)dataTypeMapping);
        XMLCompositeObjectMapping attributeTypeMapping = new XMLCompositeObjectMapping();
        attributeTypeMapping.setAttributeName(ATTRIBUTE_TYPE_PROPERTY);
        attributeTypeMapping.setReferenceClass(MWTypeDeclaration.class);
        attributeTypeMapping.setXPath("attribute-type");
        descriptor.addMapping((DatabaseMapping)attributeTypeMapping);
        return descriptor;
    }
}

