/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyAdditionException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyRemovalException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorAfterLoadingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCopyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorEventsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInstantiationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWAttributeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class MWMappingDescriptor
extends MWDescriptor {
    private Collection mappings;
    public static final String MAPPINGS_COLLECTION = "mappings";
    private Collection inheritedAttributeHandles;
    public static final String INHERITED_ATTRIBUTES_COLLECTION = "inheritedAttributes";
    private MWHandle.NodeReferenceScrubber inheritedAttributeScrubber;
    private volatile MWInheritancePolicy inheritancePolicy;
    public static final String INHERITANCE_POLICY_PROPERTY = "inheritancePolicy";
    private volatile MWDescriptorPolicy copyPolicy;
    public static final String COPY_POLICY_PROPERTY = "copyPolicy";
    private volatile MWDescriptorPolicy eventsPolicy;
    public static final String EVENTS_POLICY_PROPERTY = "eventsPolicy";
    private volatile MWDescriptorPolicy afterLoadingPolicy;
    public static final String AFTER_LOADING_POLICY_PROPERTY = "afterLoadingPolicy";
    private volatile MWDescriptorPolicy instantiationPolicy;
    public static final String INSTANTIATION_POLICY_PROPERTY = "instantiationPolicy";

    protected MWMappingDescriptor() {
    }

    protected MWMappingDescriptor(MWProject parent, MWClass type, String name) {
        super(parent, type, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.mappings = new Vector();
        this.inheritedAttributeHandles = new Vector();
        this.inheritancePolicy = new MWNullInheritancePolicy(this);
        this.copyPolicy = new MWNullDescriptorPolicy(this);
        this.eventsPolicy = new MWNullDescriptorPolicy(this);
        this.afterLoadingPolicy = new MWNullDescriptorPolicy(this);
        this.instantiationPolicy = new MWNullDescriptorPolicy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.mappings;
        synchronized (collection) {
            children.addAll(this.mappings);
        }
        collection = this.inheritedAttributeHandles;
        synchronized (collection) {
            children.addAll(this.inheritedAttributeHandles);
        }
        children.add(this.inheritancePolicy);
        children.add(this.copyPolicy);
        children.add(this.eventsPolicy);
        children.add(this.afterLoadingPolicy);
        children.add(this.instantiationPolicy);
    }

    private MWHandle.NodeReferenceScrubber inheritedAttributeScrubber() {
        if (this.inheritedAttributeScrubber == null) {
            this.inheritedAttributeScrubber = this.buildInheritedAttributeScrubber();
        }
        return this.inheritedAttributeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildInheritedAttributeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWMappingDescriptor.this.removeInheritedAttributeHandle((MWAttributeHandle)handle);
            }

            public String toString() {
                return "MWMappingDescriptor.buildInheritedAttributeScrubber()";
            }
        };
    }

    public MWClassRefreshPolicy buildMWClassRefreshPolicy() {
        return DefaultMWClassRefreshPolicy.instance();
    }

    protected MWDescriptorPolicy buildLockingPolicy() {
        return new MWNullDescriptorPolicy(this);
    }

    public boolean isReferencedBy(Collection mappingDescriptors) {
        Iterator it = mappingDescriptors.iterator();
        while (it.hasNext()) {
            Iterator it2 = ((MWMappingDescriptor)it.next()).mappings();
            while (it2.hasNext()) {
                MWMapping mapping = (MWMapping)it2.next();
                if (!mapping.isReferenceMapping() || ((MWReferenceMapping)((Object)mapping)).getReferenceDescriptor() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void addUnknownPrimaryKeyMapping(MWClassAttribute unknownPkAttribute) {
        this.addDirectMapping(unknownPkAttribute).setUsesMethodAccessing(false);
    }

    public MWQueryManager getQueryManager() {
        return this.getTransactionalPolicy().getQueryManager();
    }

    public MWCachingPolicy getCachingPolicy() {
        return this.getTransactionalPolicy().getCachingPolicy();
    }

    private void setCopyPolicy(MWDescriptorPolicy copyPolicy) {
        MWDescriptorPolicy old = this.copyPolicy;
        this.copyPolicy = copyPolicy;
        this.firePropertyChanged(COPY_POLICY_PROPERTY, old, this.copyPolicy);
    }

    public MWDescriptorPolicy getCopyPolicy() {
        return this.copyPolicy;
    }

    public void addCopyPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.copyPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(COPY_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setCopyPolicy(new MWDescriptorCopyPolicy(this));
    }

    public void removeCopyPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.copyPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(COPY_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.copyPolicy.dispose();
        this.setCopyPolicy(new MWNullDescriptorPolicy(this));
    }

    public MWLockingPolicy getLockingPolicy() {
        return this.getTransactionalPolicy().getLockingPolicy();
    }

    public MWDescriptorPolicy getEventsPolicy() {
        return this.eventsPolicy;
    }

    protected void setEventsPolicy(MWDescriptorPolicy eventsPolicy) {
        MWDescriptorPolicy old = this.eventsPolicy;
        this.eventsPolicy = eventsPolicy;
        this.firePropertyChanged(EVENTS_POLICY_PROPERTY, old, this.eventsPolicy);
    }

    public void addEventsPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.eventsPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(EVENTS_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setEventsPolicy(new MWDescriptorEventsPolicy(this));
    }

    public void removeEventsPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.eventsPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(EVENTS_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.eventsPolicy.dispose();
        this.setEventsPolicy(new MWNullDescriptorPolicy(this));
    }

    private void setAfterLoadingPolicy(MWDescriptorPolicy afterLoadingPolicy) {
        MWDescriptorPolicy old = this.afterLoadingPolicy;
        this.afterLoadingPolicy = afterLoadingPolicy;
        this.firePropertyChanged(AFTER_LOADING_POLICY_PROPERTY, old, this.afterLoadingPolicy);
    }

    public MWDescriptorPolicy getAfterLoadingPolicy() {
        return this.afterLoadingPolicy;
    }

    public void addAfterLoadingPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.afterLoadingPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(AFTER_LOADING_POLICY_PROPERTY, "Policy already exists on descriptor");
        }
        this.setAfterLoadingPolicy(new MWDescriptorAfterLoadingPolicy(this));
    }

    public void removeAfterLoadingPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.afterLoadingPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(AFTER_LOADING_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.afterLoadingPolicy.dispose();
        this.setAfterLoadingPolicy(new MWNullDescriptorPolicy(this));
    }

    protected void setInstantiationPolicy(MWDescriptorPolicy instantiationPolicy) {
        MWDescriptorPolicy old = this.instantiationPolicy;
        this.instantiationPolicy = instantiationPolicy;
        this.firePropertyChanged(INSTANTIATION_POLICY_PROPERTY, old, this.instantiationPolicy);
    }

    public MWDescriptorPolicy getInstantiationPolicy() {
        return this.instantiationPolicy;
    }

    public void addInstantiationPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.instantiationPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(INSTANTIATION_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setInstantiationPolicy(new MWDescriptorInstantiationPolicy(this));
    }

    public void removeInstantiationPolicy() {
        if (!this.instantiationPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INSTANTIATION_POLICY_PROPERTY, "property does not exist on descriptor");
        }
        this.instantiationPolicy.dispose();
        this.setInstantiationPolicy(new MWNullDescriptorPolicy(this));
    }

    public boolean supportsReturningPolicy() {
        return false;
    }

    public MWDirectMapping addDirectMapping(MWClassAttribute attribute) {
        MWDirectMapping mapping = this.mappingFactory().createDirectMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWDirectCollectionMapping addDirectCollectionMapping(MWClassAttribute attribute) {
        MWDirectCollectionMapping mapping = this.mappingFactory().createDirectCollectionMapping(this, attribute, attribute.getName());
        this.addMapping((MWMapping)((Object)mapping));
        return mapping;
    }

    public MWDirectMapMapping addDirectMapMapping(MWClassAttribute attribute) {
        MWDirectMapMapping mapping = this.mappingFactory().createDirectMapMapping(this, attribute, attribute.getName());
        this.addMapping((MWMapping)((Object)mapping));
        return mapping;
    }

    public MWTransformationMapping addTransformationMapping(MWClassAttribute attribute) {
        MWTransformationMapping mapping = this.mappingFactory().createTransformationMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public abstract MWMappingFactory mappingFactory();

    public Iterator mappings() {
        return new CloneIterator(this.mappings);
    }

    public int mappingsSize() {
        return this.mappings.size();
    }

    public Iterator tableReferenceMappings() {
        return new FilteringIterator(this.mappings()){

            protected boolean accept(Object next) {
                return ((MWMapping)next).isTableReferenceMapping();
            }
        };
    }

    public void removeMappingForAttribute(MWClassAttribute attribute) {
        MWMapping mapping = this.mappingForAttribute(attribute);
        if (mapping != null) {
            this.removeMapping(mapping);
        } else {
            this.removeInheritedAttribute(attribute);
        }
    }

    protected void addMapping(MWMapping mapping) {
        if (CollectionTools.contains(this.inheritedAttributes(), (Object)mapping.getInstanceVariable())) {
            mapping.setInherited(true);
        }
        this.addItemToCollection(mapping, this.mappings, MAPPINGS_COLLECTION);
    }

    public void removeMapping(MWMapping mapping) {
        this.removeNodeFromCollection(mapping, this.mappings, MAPPINGS_COLLECTION);
    }

    private void removeMappings(Collection c) {
        CloneIterator stream = new CloneIterator(c);
        while (stream.hasNext()) {
            this.removeMapping((MWMapping)stream.next());
        }
    }

    public MWMapping mappingForAttribute(MWClassAttribute attribute) {
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (mapping.getInstanceVariable() != attribute) continue;
            return mapping;
        }
        return null;
    }

    public MWMapping mappingNamed(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (!name.equals(mapping.getName())) continue;
            return mapping;
        }
        return null;
    }

    public Collection allWritableMappingsForField(MWDataField field) {
        ArrayList<MWMapping> mappingsForField = new ArrayList<MWMapping>();
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (mapping.isReadOnly()) continue;
            ArrayList writtenFields = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFields);
            if (!writtenFields.contains(field)) continue;
            mappingsForField.add(mapping);
        }
        if (!this.writableMappingsForField(field).isEmpty() && !this.getInheritancePolicy().isRoot() && this.getInheritancePolicy().getParentDescriptor() != null) {
            for (MWMapping nextInheritedMapping : this.getInheritancePolicy().getParentDescriptor().writableMappingsForField(field)) {
                MWMapping inheritedMappingInThisDescriptor = this.mappingNamed(nextInheritedMapping.getName());
                if (inheritedMappingInThisDescriptor != null) continue;
                mappingsForField.add(nextInheritedMapping);
            }
        }
        return mappingsForField;
    }

    public Collection writableMappingsForField(MWDataField field) {
        ArrayList<MWMapping> mappingsForField = new ArrayList<MWMapping>();
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            ArrayList writtenFields = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFields);
            if (!writtenFields.contains(field)) continue;
            mappingsForField.add(mapping);
        }
        return mappingsForField;
    }

    public Iterator attributes() {
        return new TransformationIterator(this.mappings()){

            protected Object transform(Object next) {
                return ((MWMapping)next).getInstanceVariable();
            }
        };
    }

    public void unmap() {
        super.unmap();
        ArrayList mappingsCopy = new ArrayList(this.mappings);
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            this.removeItemFromCollection(mapping, this.mappings, MAPPINGS_COLLECTION);
        }
        this.getProject().descriptorUnmapped(mappingsCopy);
    }

    protected void initializeFromMWMappingDescriptor(MWMappingDescriptor oldDescriptor) {
        super.initializeFromMWMappingDescriptor(oldDescriptor);
        Iterator i = oldDescriptor.inheritedAttributes();
        while (i.hasNext()) {
            this.addInheritedAttribute((MWClassAttribute)i.next());
        }
        i = oldDescriptor.mappings();
        while (i.hasNext()) {
            this.addMapping((MWMapping)i.next());
        }
        this.setAfterLoadingPolicy(oldDescriptor.getAfterLoadingPolicy());
        this.setCopyPolicy(oldDescriptor.getCopyPolicy());
        this.setEventsPolicy(oldDescriptor.getEventsPolicy());
        this.setInheritancePolicy(oldDescriptor.getInheritancePolicy());
        this.setInstantiationPolicy(oldDescriptor.getInstantiationPolicy());
    }

    public void mapInheritedAttributesToClass(MWClass mwClass) throws ClassNotFoundException {
        ArrayList inheritedAttributes = new ArrayList();
        for (MWClass hierarchyClass = this.getMWClass(); hierarchyClass != mwClass && hierarchyClass.getSuperclass() != this.typeFor(Object.class); hierarchyClass = hierarchyClass.getSuperclass()) {
            CollectionTools.addAll(inheritedAttributes, hierarchyClass.attributes());
        }
        for (MWClassAttribute attribute : inheritedAttributes) {
            MWMapping existingMapping = this.mappingForAttribute(attribute);
            if (existingMapping != null || CollectionTools.contains(this.inheritedAttributes(), (Object)attribute)) continue;
            this.addInheritedAttribute(attribute);
        }
    }

    public void mapInheritedAttributesToRootMinusOne() throws ClassNotFoundException {
        MWClass bldrClass = this.getMWClass();
        while (bldrClass.getSuperclass() != this.typeFor(Object.class)) {
            bldrClass = bldrClass.getSuperclass();
        }
        this.mapInheritedAttributesToClass(bldrClass);
    }

    public void mapInheritedAttributesToSuperclass() throws ClassNotFoundException {
        this.mapInheritedAttributesToClass(this.getMWClass().getSuperclass());
    }

    public void removeInheritedAttributes() {
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (!mapping.isInherited()) continue;
            this.removeMapping(mapping);
        }
        stream = this.inheritedAttributes();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    private Iterator inheritedAttributeHandles() {
        return new CloneIterator(this.inheritedAttributeHandles){

            protected void remove(Object current) {
                MWMappingDescriptor.this.removeInheritedAttributeHandle((MWAttributeHandle)current);
            }
        };
    }

    void removeInheritedAttributeHandle(MWAttributeHandle handle) {
        this.inheritedAttributeHandles.remove(handle);
        this.fireItemRemoved(INHERITED_ATTRIBUTES_COLLECTION, handle.getAttribute());
    }

    public Iterator inheritedAttributes() {
        return new TransformationIterator(this.inheritedAttributeHandles()){

            protected Object transform(Object next) {
                return ((MWAttributeHandle)next).getAttribute();
            }
        };
    }

    public int inheritedAttributesSize() {
        return this.inheritedAttributeHandles.size();
    }

    public void addInheritedAttribute(MWClassAttribute inheritedAttribute) {
        this.inheritedAttributeHandles.add(new MWAttributeHandle(this, inheritedAttribute, this.inheritedAttributeScrubber()));
        this.fireItemAdded(INHERITED_ATTRIBUTES_COLLECTION, inheritedAttribute);
    }

    public void removeInheritedAttribute(MWClassAttribute inheritedAttribute) {
        Iterator stream = this.inheritedAttributes();
        while (stream.hasNext()) {
            if (stream.next() != inheritedAttribute) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(inheritedAttribute.toString());
    }

    public void removeInheritedAttributes(Collection attributes) {
        this.removeInheritedAttributes(attributes.iterator());
    }

    public void removeInheritedAttributes(Iterator attributes) {
        while (attributes.hasNext()) {
            this.removeInheritedAttribute((MWClassAttribute)attributes.next());
        }
    }

    public MWClassAttribute inheritedAttributeNamed(String name) {
        Iterator stream = this.inheritedAttributes();
        while (stream.hasNext()) {
            MWClassAttribute attribute = (MWClassAttribute)stream.next();
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public boolean containsInheritedAttributeNamed(String name) {
        return this.inheritedAttributeNamed(name) != null;
    }

    public void hierarchyChanged(MWClass type) {
        ArrayList<MWMapping> mappingsToRemove = new ArrayList<MWMapping>();
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            MWMapping mapping = (MWMapping)stream.next();
            if (!mapping.isInherited() || this.getMWClass().isSubclassOf(mapping.getInstanceVariable().getDeclaringType())) continue;
            mappingsToRemove.add(mapping);
        }
        this.removeMappings(mappingsToRemove);
        ArrayList<MWClassAttribute> attributesToRemove = new ArrayList<MWClassAttribute>();
        Iterator stream2 = this.inheritedAttributes();
        while (stream2.hasNext()) {
            MWClassAttribute attribute = (MWClassAttribute)stream2.next();
            if (this.getMWClass().isSubclassOf(attribute.getDeclaringType())) continue;
            attributesToRemove.add(attribute);
        }
        this.removeInheritedAttributes(attributesToRemove);
    }

    public MWMapping replaceMapping(MWMapping oldMapping, MWMapping newMapping) {
        if (oldMapping == newMapping) {
            return oldMapping;
        }
        if (oldMapping == null) {
            this.addMapping(newMapping);
            return newMapping;
        }
        if (newMapping == null) {
            this.removeMapping(oldMapping);
            return null;
        }
        this.removeItemFromCollection(oldMapping, this.mappings, MAPPINGS_COLLECTION);
        this.addMapping(newMapping);
        this.getProject().mappingReplaced(oldMapping, newMapping);
        return newMapping;
    }

    public MWInheritancePolicy getInheritancePolicy() {
        return this.inheritancePolicy;
    }

    public void addInheritancePolicy() {
        if (this.getInheritancePolicy().isActive()) {
            throw new MWAdvancedPropertyAdditionException(INHERITANCE_POLICY_PROPERTY, "Policy already exists on descriptor: ");
        }
        MWDescriptorInheritancePolicy ip = this.buildInheritancePolicy();
        this.setInheritancePolicy(ip);
        ip.initializeParentDescriptor();
        if (ip.getParentDescriptor() == null) {
            ip.setIsRoot(true);
        }
        this.getInheritancePolicy().getRootDescriptor().getInheritancePolicy().buildClassIndicatorValues();
    }

    protected abstract MWDescriptorInheritancePolicy buildInheritancePolicy();

    public void removeInheritancePolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.inheritancePolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INHERITANCE_POLICY_PROPERTY, "property does not exist on descriptor");
        }
        MWDescriptor oldRootDescriptor = this.getInheritancePolicy().getRootDescriptor();
        this.inheritancePolicy.dispose();
        this.setInheritancePolicy(new MWNullInheritancePolicy(this));
        oldRootDescriptor.getInheritancePolicy().buildClassIndicatorValues();
        this.inheritanceChanged();
    }

    protected void setInheritancePolicy(MWInheritancePolicy newInheritancePolicy) {
        MWInheritancePolicy oldInheritancePolicy = this.inheritancePolicy;
        this.inheritancePolicy = newInheritancePolicy;
        this.firePropertyChanged(INHERITANCE_POLICY_PROPERTY, oldInheritancePolicy, newInheritancePolicy);
    }

    public boolean canHaveInheritance() {
        return true;
    }

    public boolean hasDefinedInheritance() {
        MWInheritancePolicy ip = this.getInheritancePolicy();
        return ip.isRoot() || ip.getParentDescriptor() != null;
    }

    public boolean hasActiveInstantiationPolicy() {
        return this.getInstantiationPolicy().isActive();
    }

    void inheritanceChanged() {
        super.inheritanceChanged();
        this.inheritancePolicy.descriptorInheritanceChanged();
    }

    public Iterator mappingsIncludingInherited() {
        return new CloneListIterator(this.getMappingsIncludingInherited());
    }

    protected List getMappingsIncludingInherited() {
        Vector allMappings = new Vector();
        if (this.getInheritancePolicy().getParentDescriptor() != null) {
            allMappings.addAll(this.getInheritancePolicy().getParentDescriptor().getMappingsIncludingInherited());
        }
        allMappings.addAll(this.mappings);
        return allMappings;
    }

    public void implementorsChangedFor(MWInterfaceDescriptor descriptor) {
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            ((MWMapping)stream.next()).implementorsChangedFor(descriptor);
        }
    }

    public Collection buildAggregateFieldNameGenerators() {
        return new ArrayList();
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkMultipleMappingsWriteField(newProblems);
        this.checkForDuplicateMethods(newProblems);
    }

    protected void checkMultipleMappingsWriteField(List newProblems) {
        HashBag writtenFields = new HashBag();
        HashMap<MWDataField, ArrayList<MWMapping>> fieldToMappings = new HashMap<MWDataField, ArrayList<MWMapping>>();
        Iterator mappingStream = this.mappingsIncludingInherited();
        while (mappingStream.hasNext()) {
            MWMapping mapping = (MWMapping)mappingStream.next();
            if (mapping.getParentDescriptor().getTransactionalPolicy().isReadOnly()) continue;
            ArrayList writtenFieldsForMapping = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFieldsForMapping);
            for (MWDataField field : writtenFieldsForMapping) {
                ArrayList<MWMapping> fieldMappings = (ArrayList<MWMapping>)fieldToMappings.get(field);
                if (fieldMappings == null) {
                    fieldMappings = new ArrayList<MWMapping>();
                    fieldToMappings.put(field, fieldMappings);
                }
                fieldMappings.add(mapping);
            }
            writtenFields.addAll(writtenFieldsForMapping);
        }
        Iterator stream = writtenFields.uniqueIterator();
        while (stream.hasNext()) {
            Object field = stream.next();
            if (writtenFields.count(field) <= 1) continue;
            newProblems.add(this.buildMultipleMappingsWriteFieldProblem((Collection)fieldToMappings.get(field), (MWDataField)field));
        }
    }

    private Problem buildMultipleMappingsWriteFieldProblem(Collection problemMappings, MWDataField field) {
        StringBuffer sb = new StringBuffer();
        Iterator stream = problemMappings.iterator();
        while (stream.hasNext()) {
            sb.append('\"');
            sb.append(((MWMapping)stream.next()).getName());
            sb.append('\"');
            if (!stream.hasNext()) continue;
            sb.append(", ");
        }
        return this.buildProblem(this.multipleMappingsWriteFieldProblemResourceStringKey(), sb.toString(), field.fieldName());
    }

    protected abstract String multipleMappingsWriteFieldProblemResourceStringKey();

    private void checkForDuplicateMethods(List newProblems) {
        Iterator stream1 = this.getMWClass().methods();
        while (stream1.hasNext()) {
            MWMethod method1 = (MWMethod)stream1.next();
            boolean firstMatch = true;
            Iterator stream2 = this.getMWClass().methods();
            while (stream2.hasNext()) {
                MWMethod method2 = (MWMethod)stream2.next();
                if (!method2.hasSameSignatureAs(method1)) continue;
                if (firstMatch) {
                    firstMatch = false;
                    continue;
                }
                newProblems.add(this.buildProblem("0210", method1.signature()));
            }
        }
    }

    protected void automapInternal() {
        super.automapInternal();
        this.getInheritancePolicy().automap();
        this.automapMappings();
    }

    private void automapMappings() {
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            ((MWMapping)stream.next()).automap();
        }
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor runtimeDescriptor = super.buildRuntimeDescriptor();
        this.inheritancePolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.copyPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.instantiationPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.afterLoadingPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        this.eventsPolicy.adjustRuntimeDescriptor(runtimeDescriptor);
        Iterator i = this.getProject().interfaceDescriptorsThatImplement(this);
        while (i.hasNext()) {
            MWInterfaceDescriptor implementor = (MWInterfaceDescriptor)i.next();
            runtimeDescriptor.getInterfacePolicy().addParentInterfaceName(implementor.getMWClass().getName());
        }
        Iterator mappings = this.orderedMappings();
        while (mappings.hasNext()) {
            runtimeDescriptor.addMapping(((MWMapping)mappings.next()).runtimeMapping());
        }
        return runtimeDescriptor;
    }

    private Iterator orderedMappings() {
        return CollectionTools.sort(new Vector(this.mappings), this.orderedMappingComparator()).iterator();
    }

    protected Comparator orderedMappingComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return 0;
            }
        };
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMappingDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWDescriptor.class);
        XMLCompositeCollectionMapping mappingsMapping = new XMLCompositeCollectionMapping();
        mappingsMapping.setAttributeName(MAPPINGS_COLLECTION);
        mappingsMapping.setGetMethodName("getMappingsForTopLink");
        mappingsMapping.setSetMethodName("setMappingsForTopLink");
        mappingsMapping.setReferenceClass(MWMapping.class);
        mappingsMapping.setXPath("mappings/mapping");
        descriptor.addMapping((DatabaseMapping)mappingsMapping);
        XMLCompositeCollectionMapping inheritedAttributeHandlesMapping = new XMLCompositeCollectionMapping();
        inheritedAttributeHandlesMapping.setAttributeName("inheritedAttributeHandles");
        inheritedAttributeHandlesMapping.setGetMethodName("getInheritedAttributeHandlesForTopLink");
        inheritedAttributeHandlesMapping.setSetMethodName("setInheritedAttributeHandlesForTopLink");
        inheritedAttributeHandlesMapping.setReferenceClass(MWAttributeHandle.class);
        inheritedAttributeHandlesMapping.setXPath("inherited-attribute-handles/attribute-handle");
        descriptor.addMapping((DatabaseMapping)inheritedAttributeHandlesMapping);
        XMLCompositeObjectMapping inheritancePolicyMapping = new XMLCompositeObjectMapping();
        inheritancePolicyMapping.setAttributeName(INHERITANCE_POLICY_PROPERTY);
        inheritancePolicyMapping.setGetMethodName("getInheritancePolicyForTopLink");
        inheritancePolicyMapping.setSetMethodName("setInheritancePolicyForTopLink");
        inheritancePolicyMapping.setReferenceClass(MWDescriptorInheritancePolicy.class);
        inheritancePolicyMapping.setXPath("inheritance-policy");
        descriptor.addMapping((DatabaseMapping)inheritancePolicyMapping);
        XMLCompositeObjectMapping copyPolicyMapping = new XMLCompositeObjectMapping();
        copyPolicyMapping.setAttributeName(COPY_POLICY_PROPERTY);
        copyPolicyMapping.setSetMethodName("setCopyPolicyForTopLink");
        copyPolicyMapping.setGetMethodName("getCopyPolicyForTopLink");
        copyPolicyMapping.setReferenceClass(MWDescriptorCopyPolicy.class);
        copyPolicyMapping.setXPath("copy-policy");
        descriptor.addMapping((DatabaseMapping)copyPolicyMapping);
        XMLCompositeObjectMapping eventsPolicyMapping = new XMLCompositeObjectMapping();
        eventsPolicyMapping.setAttributeName(EVENTS_POLICY_PROPERTY);
        eventsPolicyMapping.setReferenceClass(MWDescriptorEventsPolicy.class);
        eventsPolicyMapping.setXPath("events-policy");
        eventsPolicyMapping.setSetMethodName("setEventsPolicyForTopLink");
        eventsPolicyMapping.setGetMethodName("getEventsPolicyForTopLink");
        descriptor.addMapping((DatabaseMapping)eventsPolicyMapping);
        XMLCompositeObjectMapping afterLoadPolicyMapping = new XMLCompositeObjectMapping();
        afterLoadPolicyMapping.setAttributeName(AFTER_LOADING_POLICY_PROPERTY);
        afterLoadPolicyMapping.setSetMethodName("setAfterLoadingPolicyForTopLink");
        afterLoadPolicyMapping.setGetMethodName("getAfterLoadingPolicyForTopLink");
        afterLoadPolicyMapping.setReferenceClass(MWDescriptorAfterLoadingPolicy.class);
        afterLoadPolicyMapping.setXPath("after-loading-policy");
        descriptor.addMapping((DatabaseMapping)afterLoadPolicyMapping);
        XMLCompositeObjectMapping instantiationPolicyMapping = new XMLCompositeObjectMapping();
        instantiationPolicyMapping.setAttributeName(INSTANTIATION_POLICY_PROPERTY);
        instantiationPolicyMapping.setReferenceClass(MWDescriptorInstantiationPolicy.class);
        instantiationPolicyMapping.setGetMethodName("getInstantiationPolicyForTopLink");
        instantiationPolicyMapping.setSetMethodName("setInstantiationPolicyForTopLink");
        instantiationPolicyMapping.setXPath("instantiation-policy");
        descriptor.addMapping((DatabaseMapping)instantiationPolicyMapping);
        return descriptor;
    }

    private Collection getMappingsForTopLink() {
        return CollectionTools.sort((List)this.mappings);
    }

    private void setMappingsForTopLink(Collection mappings) {
        this.mappings = mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInheritedAttributeHandlesForTopLink() {
        Collection collection = this.inheritedAttributeHandles;
        synchronized (collection) {
            return new TreeSet(this.inheritedAttributeHandles);
        }
    }

    private void setInheritedAttributeHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWAttributeHandle)stream.next()).setScrubber(this.inheritedAttributeScrubber());
        }
        this.inheritedAttributeHandles = handles;
    }

    private MWDescriptorInheritancePolicy getInheritancePolicyForTopLink() {
        return (MWDescriptorInheritancePolicy)this.inheritancePolicy.getPersistedPolicy();
    }

    protected void setInheritancePolicyForTopLink(MWDescriptorInheritancePolicy policy) {
        this.inheritancePolicy = policy == null ? new MWNullInheritancePolicy(this) : policy;
    }

    private MWDescriptorCopyPolicy getCopyPolicyForTopLink() {
        return (MWDescriptorCopyPolicy)this.getCopyPolicy().getPersistedPolicy();
    }

    private void setCopyPolicyForTopLink(MWDescriptorCopyPolicy policy) {
        this.copyPolicy = policy == null ? new MWNullDescriptorPolicy(this) : policy;
    }

    private MWDescriptorEventsPolicy getEventsPolicyForTopLink() {
        return (MWDescriptorEventsPolicy)this.getEventsPolicy().getPersistedPolicy();
    }

    private void setEventsPolicyForTopLink(MWDescriptorEventsPolicy policy) {
        this.eventsPolicy = policy == null ? new MWNullDescriptorPolicy(this) : policy;
    }

    private MWDescriptorAfterLoadingPolicy getAfterLoadingPolicyForTopLink() {
        return (MWDescriptorAfterLoadingPolicy)this.afterLoadingPolicy.getPersistedPolicy();
    }

    private void setAfterLoadingPolicyForTopLink(MWDescriptorAfterLoadingPolicy policy) {
        this.afterLoadingPolicy = policy == null ? new MWNullDescriptorPolicy(this) : policy;
    }

    private MWDescriptorInstantiationPolicy getInstantiationPolicyForTopLink() {
        return (MWDescriptorInstantiationPolicy)this.instantiationPolicy.getPersistedPolicy();
    }

    private void setInstantiationPolicyForTopLink(MWDescriptorInstantiationPolicy policy) {
        this.instantiationPolicy = policy == null ? new MWNullDescriptorPolicy(this) : policy;
    }
}

