/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.DatabaseTypeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JavaTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumn
extends MWModel
implements MWDataField {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private DatabaseTypeHandle databaseTypeHandle;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";
    private volatile int size;
    public static final String SIZE_PROPERTY = "size";
    private volatile int subSize;
    public static final String SUB_SIZE_PROPERTY = "subSize";
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";
    private volatile boolean unique;
    public static final String UNIQUE_PROPERTY = "unique";
    private volatile boolean primaryKey;
    public static final String PRIMARY_KEY_PROPERTY = "primaryKey";
    private volatile boolean identity;
    public static final String IDENTITY_PROPERTY = "identity";

    public static String parseTableNameFromQualifiedName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(0, index);
    }

    public static String parseColumnNameFromQualifiedName(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public static boolean nameIsQualified(String columnName) {
        return columnName.indexOf(".") != -1;
    }

    private MWColumn() {
    }

    MWColumn(MWTable table, String name) {
        super(table);
        this.name = name;
    }

    protected void initialize() {
        super.initialize();
        this.databaseTypeHandle = new DatabaseTypeHandle(this);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        DatabaseType dbType = this.defaultDatabaseType();
        this.databaseTypeHandle.setDatabaseType(dbType);
        this.size = dbType.requiresSize() ? dbType.getInitialSize() : 0;
        this.subSize = 0;
        this.allowsNull = dbType.allowsNull();
        this.unique = false;
        this.primaryKey = false;
        this.identity = false;
    }

    public MWTable getTable() {
        return (MWTable)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getTable().checkColumnName(name);
        String old = this.name;
        this.name = name;
        if (this.attributeValueHasChanged(old, name)) {
            this.firePropertyChanged(NAME_PROPERTY, old, name);
            this.qualifiedNameChanged();
            this.getProject().nodeRenamed(this);
        }
    }

    void qualifiedNameChanged() {
        String qName = this.qualifiedName();
        this.firePropertyChanged(QUALIFIED_NAME_PROPERTY, qName);
        this.firePropertyChanged("fieldName", qName);
    }

    public DatabaseType getDatabaseType() {
        return this.databaseTypeHandle.getDatabaseType();
    }

    public void setDatabaseType(DatabaseType databaseType) {
        if (databaseType == null) {
            throw new NullPointerException();
        }
        DatabaseType old = this.databaseTypeHandle.getDatabaseType();
        this.databaseTypeHandle.setDatabaseType(databaseType);
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, old, databaseType);
        if (this.attributeValueHasChanged(old, databaseType)) {
            this.synchronizeWithNewDatabaseType();
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (!this.getDatabaseType().allowsSize() && size != 0) {
            throw new IllegalArgumentException("size must be 0 when size is not allowed");
        }
        int old = this.size;
        this.size = size;
        this.firePropertyChanged(SIZE_PROPERTY, old, size);
    }

    public int getSubSize() {
        return this.subSize;
    }

    public void setSubSize(int subSize) {
        if (!this.getDatabaseType().allowsSubSize() && subSize != 0) {
            throw new IllegalArgumentException("sub-size must be 0 when sub-size is not allowed");
        }
        int old = this.subSize;
        this.subSize = subSize;
        this.firePropertyChanged(SUB_SIZE_PROPERTY, old, subSize);
    }

    public boolean allowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        if (!this.getDatabaseType().allowsNull() && allowsNull) {
            throw new IllegalArgumentException("allows null must be false when allows null is not allowed");
        }
        boolean old = this.allowsNull;
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, old, allowsNull);
        if (allowsNull) {
            this.setPrimaryKey(false);
            this.setIdentity(false);
        }
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        boolean old = this.unique;
        this.unique = unique;
        this.firePropertyChanged(UNIQUE_PROPERTY, old, unique);
        if (!unique) {
            this.setPrimaryKey(false);
        }
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        boolean old = this.primaryKey;
        this.primaryKey = primaryKey;
        this.firePropertyChanged(PRIMARY_KEY_PROPERTY, old, primaryKey);
        if (primaryKey) {
            this.setAllowsNull(false);
            this.setUnique(true);
        }
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        if (!this.supportsIdentityClause() && identity) {
            throw new IllegalArgumentException("the current platform does not support the IDENTITY clause");
        }
        boolean old = this.identity;
        this.identity = identity;
        this.firePropertyChanged(IDENTITY_PROPERTY, old, identity);
        if (identity) {
            this.setAllowsNull(false);
        }
    }

    public DatabasePlatform databasePlatform() {
        return this.getTable().databasePlatform();
    }

    public String qualifiedName() {
        return this.getTable().qualifiedName() + '.' + this.getName();
    }

    private DatabaseType defaultDatabaseType() {
        return this.databasePlatform().defaultDatabaseType();
    }

    public JavaTypeDeclaration javaTypeDeclaration() {
        return this.getDatabaseType().javaTypeDeclaration();
    }

    public boolean supportsIdentityClause() {
        return this.getDatabase().supportsIdentityClause();
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.databaseTypeHandle);
    }

    void databasePlatformChanged() {
        this.setDatabaseType(this.databasePlatform().databaseTypeFor(this.getDatabaseType()));
    }

    private void synchronizeWithNewDatabaseType() {
        DatabaseType dbType = this.getDatabaseType();
        if (dbType.allowsSize()) {
            if (!dbType.allowsSubSize()) {
                this.setSubSize(0);
            }
            if (dbType.requiresSize()) {
                if (this.size == 0) {
                    this.setSize(dbType.getInitialSize());
                }
            } else if (this.subSize == 0) {
                this.setSize(0);
            }
        } else {
            this.setSize(0);
            this.setSubSize(0);
        }
        if (!dbType.allowsNull()) {
            this.setAllowsNull(false);
        }
        if (!dbType.getPlatform().supportsIdentityClause()) {
            this.setIdentity(false);
        }
    }

    void copySettingsFrom(MWColumn original) {
        this.setDatabaseType(original.getDatabaseType());
        this.setSize(original.getSize());
        this.setSubSize(original.getSubSize());
        this.setAllowsNull(original.allowsNull());
        this.setUnique(original.isUnique());
        this.setPrimaryKey(original.isPrimaryKey());
        this.setIdentity(original.isIdentity());
    }

    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        if (this.getDatabaseType().requiresSize() && this.size == 0) {
            currentProblems.add(this.buildProblem("0702", this.qualifiedName()));
        }
    }

    public String fieldName() {
        return this.qualifiedName();
    }

    public DatabaseField runtimeField() {
        return new DatabaseField(this.qualifiedName());
    }

    void refresh(ExternalColumn externalColumn) {
        this.setDatabaseType(this.databaseTypeFrom(externalColumn));
        this.setSize(this.sizeFrom(externalColumn));
        this.setSubSize(this.subSizeFrom(externalColumn));
        this.setAllowsNull(this.allowsNullFrom(externalColumn));
        this.setPrimaryKey(externalColumn.isPrimaryKey());
    }

    private DatabaseType databaseTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeNamed(externalColumn.getTypeName());
        }
        catch (IllegalArgumentException ex) {
            return this.databaseTypeFromJDBCTypeFrom(externalColumn);
        }
    }

    private DatabaseType databaseTypeFromJDBCTypeFrom(ExternalColumn externalColumn) {
        try {
            return this.databasePlatform().databaseTypeForJDBCTypeCode(externalColumn.getJDBCTypeCode());
        }
        catch (Exception ex) {
            return this.databasePlatform().defaultDatabaseType();
        }
    }

    private int sizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSize()) {
            return 0;
        }
        return externalColumn.getSize();
    }

    private int subSizeFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsSubSize()) {
            return 0;
        }
        return externalColumn.getScale();
    }

    private boolean allowsNullFrom(ExternalColumn externalColumn) {
        if (!this.getDatabaseType().allowsNull()) {
            return false;
        }
        return externalColumn.isNullable();
    }

    FieldDefinition buildRuntimeFieldDefinition() {
        FieldDefinition fd = new FieldDefinition(this.name, this.getDatabaseType().getName());
        fd.setSize(this.size);
        fd.setSubSize(this.subSize);
        if (this.primaryKey) {
            fd.setIsPrimaryKey(true);
        } else {
            fd.setIsPrimaryKey(false);
            fd.setShouldAllowNull(this.allowsNull);
            fd.setUnique(this.unique);
        }
        fd.setIsIdentity(this.identity);
        return fd;
    }

    public String displayString() {
        return this.qualifiedName();
    }

    public void toString(StringBuffer sb) {
        sb.append(this.qualifiedName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWColumn.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        descriptor.addDirectMapping("databaseTypeName", "getDatabaseTypeNameForTopLink", "setDatabaseTypeNameForTopLink", "type/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping(SIZE_PROPERTY, "size/text()")).setNullValue((Object)new Integer(0));
        ((XMLDirectMapping)descriptor.addDirectMapping(SUB_SIZE_PROPERTY, "sub-size/text()")).setNullValue((Object)new Integer(0));
        ((XMLDirectMapping)descriptor.addDirectMapping(ALLOWS_NULL_PROPERTY, "allows-null/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)descriptor.addDirectMapping(UNIQUE_PROPERTY, "unique/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)descriptor.addDirectMapping(PRIMARY_KEY_PROPERTY, "primary-key/text()")).setNullValue((Object)Boolean.FALSE);
        ((XMLDirectMapping)descriptor.addDirectMapping(IDENTITY_PROPERTY, "identity/text()")).setNullValue((Object)Boolean.FALSE);
        return descriptor;
    }

    private String getDatabaseTypeNameForTopLink() {
        return this.databaseTypeHandle.getDatabaseTypeNameForTopLink();
    }

    private void setDatabaseTypeNameForTopLink(String databaseTypeName) {
        this.databaseTypeHandle.setDatabaseTypeNameForTopLink(databaseTypeName);
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.primaryKey) {
            this.allowsNull = false;
            this.unique = true;
        }
        if (this.identity) {
            this.allowsNull = false;
        }
    }
}

