/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.sequencing.NativeSequence;

public class SequenceGeneratorMetadata
extends ORMetadata {
    private boolean m_useIdentityIfPlatformSupports = false;
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_name;
    private String m_schema;
    private String m_catalog;
    private String m_sequenceName;

    public SequenceGeneratorMetadata() {
        super("<sequence-generator>");
    }

    public SequenceGeneratorMetadata(MetadataAnnotation sequenceGenerator, MetadataAccessor accessor) {
        super(sequenceGenerator, accessor);
        this.m_allocationSize = (Integer)sequenceGenerator.getAttribute("allocationSize");
        this.m_initialValue = (Integer)sequenceGenerator.getAttribute("initialValue");
        this.m_name = (String)sequenceGenerator.getAttributeString("name");
        this.m_schema = (String)sequenceGenerator.getAttributeString("schema");
        this.m_catalog = (String)sequenceGenerator.getAttributeString("catalog");
        this.m_sequenceName = (String)sequenceGenerator.getAttributeString("sequenceName");
    }

    public SequenceGeneratorMetadata(String sequenceName, Integer allocationSize, String catalog, String schema, boolean useIdentityIfPlatformSupports) {
        this.m_sequenceName = sequenceName;
        this.m_allocationSize = allocationSize;
        this.m_useIdentityIfPlatformSupports = useIdentityIfPlatformSupports;
        this.setSchema(schema);
        this.setCatalog(catalog);
    }

    public SequenceGeneratorMetadata(String sequenceName, String catalog, String schema) {
        this.m_sequenceName = sequenceName;
        this.setSchema(schema);
        this.setCatalog(catalog);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof SequenceGeneratorMetadata) {
            SequenceGeneratorMetadata generator = (SequenceGeneratorMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_name, generator.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_initialValue, generator.getInitialValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_allocationSize, generator.getAllocationSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_schema, generator.getSchema())) {
                return false;
            }
            if (!this.valuesMatch(this.m_catalog, generator.getCatalog())) {
                return false;
            }
            return this.valuesMatch(this.m_sequenceName, generator.getSequenceName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_sequence_generator_catalog";
    }

    public String getIdentifier() {
        return this.getName();
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    public String getName() {
        return this.m_name;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_sequence_generator_schema";
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_sequenceName == null) {
            this.m_sequenceName = "";
        }
    }

    public NativeSequence process(MetadataLogger logger) {
        NativeSequence sequence = new NativeSequence();
        if (this.m_sequenceName.equals("")) {
            logger.logConfigMessage("metadata_default_sequence_generator_sequence_name", this.m_name, (Object)this.getAccessibleObject(), this.getLocation());
            sequence.setName(this.m_name);
        } else {
            sequence.setName(this.m_sequenceName);
        }
        sequence.setShouldUseIdentityIfPlatformSupports(this.m_useIdentityIfPlatformSupports);
        sequence.setPreallocationSize(this.m_allocationSize == null ? Integer.valueOf(50) : this.m_allocationSize);
        sequence.setInitialValue(this.m_initialValue == null ? Integer.valueOf(1) : this.m_initialValue);
        sequence.setQualifier(this.processQualifier());
        return sequence;
    }

    public String processQualifier() {
        String qualifier = "";
        if (this.m_schema != null && !this.m_schema.equals("")) {
            qualifier = this.m_schema;
        }
        if (this.m_catalog != null && !this.m_catalog.equals("")) {
            qualifier = qualifier.equals("") ? this.m_catalog : this.m_catalog + "." + qualifier;
        }
        return qualifier;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.m_allocationSize = allocationSize;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setInitialValue(Integer initialValue) {
        this.m_initialValue = initialValue;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setSequenceName(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public String toString() {
        return "SequenceGenerator[" + this.m_name + "]";
    }
}

