/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaCache;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.Session;

public class CacheImpl
implements JpaCache {
    private EntityManagerFactoryDelegate emf;

    public CacheImpl(EntityManagerFactoryDelegate emf) {
        this.emf = emf;
    }

    public boolean contains(Class cls, Object id) {
        this.getEntityManagerFactory().verifyOpen();
        Object pk = this.createPrimaryKeyFromId(cls, id);
        if (null == pk) {
            return false;
        }
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(cls);
        if (null == descriptor) {
            return false;
        }
        CacheKey key = ((org.eclipse.persistence.internal.sessions.IdentityMapAccessor)this.getAccessor()).getCacheKeyForObject(pk, cls, descriptor, false);
        return key != null && key.getObject() != null && !descriptor.getCacheInvalidationPolicy().isInvalidated(key);
    }

    private void evictAssignableEntitySuperclass(Class possibleSuperclass, Object id) {
        for (ClassDescriptor candidateAssignableDescriptor : this.getSession().getDescriptors().values()) {
            if (candidateAssignableDescriptor.isDescriptorTypeAggregate() || !possibleSuperclass.isAssignableFrom(candidateAssignableDescriptor.getJavaClass())) continue;
            if (null == id) {
                this.getAccessor().invalidateClass(candidateAssignableDescriptor.getJavaClass());
                continue;
            }
            this.getAccessor().invalidateObject(this.createPrimaryKeyFromId(possibleSuperclass, id), candidateAssignableDescriptor.getJavaClass());
        }
    }

    public void evict(Class classToEvict, Object id) {
        this.getEntityManagerFactory().verifyOpen();
        ClassDescriptor aPossibleSuperclassDescriptor = this.getSession().getClassDescriptor(classToEvict);
        if (null != aPossibleSuperclassDescriptor) {
            if (null != id) {
                Object cacheKey = this.createPrimaryKeyFromId(classToEvict, id);
                if (null != cacheKey) {
                    this.getAccessor().invalidateObject(cacheKey, classToEvict);
                }
            } else {
                boolean invalidateRecursively = aPossibleSuperclassDescriptor.getJavaClass().equals(classToEvict);
                this.getAccessor().invalidateClass(classToEvict, invalidateRecursively);
            }
        } else {
            this.evictAssignableEntitySuperclass(classToEvict, id);
        }
    }

    public void evict(Class entityOrMappedSuperclassToEvict) {
        this.evict(entityOrMappedSuperclassToEvict, null);
    }

    public void evictAll() {
        this.getEntityManagerFactory().verifyOpen();
        this.getEntityManagerFactory().getDatabaseSession().getIdentityMapAccessor().invalidateAll();
    }

    private Object createPrimaryKeyFromId(Class cls, Object id) {
        Object cacheKey = null;
        ClassDescriptor aDescriptor = this.getSession().getDescriptor(cls);
        if (null == aDescriptor) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cache_impl_class_has_no_descriptor_is_not_a_persistent_type", new Object[]{cls}));
        }
        if (aDescriptor.hasCMPPolicy()) {
            cacheKey = aDescriptor.getCMPPolicy().createPrimaryKeyFromId(id, this.getEntityManagerFactory().getDatabaseSession());
        }
        return cacheKey;
    }

    public void clear() {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().initializeAllIdentityMaps();
    }

    public void clear(Class cls) {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().initializeIdentityMap(cls);
    }

    public void clearQueryCache() {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().clearQueryCache();
    }

    public void clearQueryCache(String queryName) {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().clearQueryCache(queryName);
    }

    public long timeToLive(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        return this.getAccessor().getRemainingValidTime(object);
    }

    public boolean isValid(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        return this.getAccessor().isValid(object);
    }

    public boolean isValid(Class cls, Object id) {
        this.getEntityManagerFactory().verifyOpen();
        Object cacheKey = this.createPrimaryKeyFromId(cls, id);
        if (null != cacheKey) {
            return this.getAccessor().isValid(cacheKey, cls);
        }
        return false;
    }

    public void print() {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().printIdentityMaps();
    }

    public void print(Class cls) {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().printIdentityMap(cls);
    }

    public void printLocks() {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().printIdentityMapLocks();
    }

    public void validate() {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().validateCache();
    }

    public Object getObject(Class cls, Object id) {
        this.getEntityManagerFactory().verifyOpen();
        Object cacheKey = this.createPrimaryKeyFromId(cls, id);
        return this.getAccessor().getFromIdentityMap(cacheKey, cls);
    }

    public Object putObject(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        return this.getAccessor().putInIdentityMap(object);
    }

    public Object removeObject(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        return this.getAccessor().removeFromIdentityMap(object);
    }

    public Object removeObject(Class cls, Object id) {
        this.getEntityManagerFactory().verifyOpen();
        Object cacheKey = this.createPrimaryKeyFromId(cls, id);
        return this.getAccessor().removeFromIdentityMap(cacheKey, cls);
    }

    public boolean contains(Object object) {
        return this.contains(object.getClass(), this.getId(object));
    }

    public void evict(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        this.getAccessor().invalidateObject(object);
    }

    protected EntityManagerFactoryDelegate getEntityManagerFactory() {
        return this.emf;
    }

    protected Session getSession() {
        return this.getEntityManagerFactory().getDatabaseSession();
    }

    protected IdentityMapAccessor getAccessor() {
        return this.getSession().getIdentityMapAccessor();
    }

    public Object getId(Object object) {
        this.getEntityManagerFactory().verifyOpen();
        ClassDescriptor aDescriptor = this.getSession().getDescriptor(object.getClass());
        if (null == aDescriptor) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cache_impl_object_has_no_descriptor_is_not_a_persistent_type", new Object[]{object}));
        }
        if (!aDescriptor.hasCMPPolicy()) {
            return aDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, (AbstractSession)this.getSession());
        }
        return this.getEntityManagerFactory().getIdentifier(object);
    }
}

