/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DatabaseType {
    public static final String TARGET_SHORT_PREFIX = "T_";
    public static final String TARGET_SUFFIX = "TARGET";
    public static final String COMPAT_SHORT_PREFIX = "C_";
    public static final String COMPAT_SUFFIX = "COMPAT";
    public static final int ARGNAME_SIZE_LIMIT = 30 - "TARGET".length();

    public boolean isComplexDatabaseType();

    public boolean isJDBCType();

    public int getSqlCode();

    public int getConversionCode();

    public String getTypeName();

    public int computeInIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public int computeOutIndex(PLSQLargument var1, int var2, ListIterator<PLSQLargument> var3);

    public void buildInDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildOutDeclare(StringBuilder var1, PLSQLargument var2);

    public void buildBeginBlock(StringBuilder var1, PLSQLargument var2, PLSQLStoredProcedureCall var3);

    public void buildOutAssignment(StringBuilder var1, PLSQLargument var2, PLSQLStoredProcedureCall var3);

    public void translate(PLSQLargument var1, AbstractRecord var2, AbstractRecord var3, List<DatabaseField> var4, List<DatabaseField> var5, List var6, StoredProcedureCall var7);

    public void buildOutputRow(PLSQLargument var1, AbstractRecord var2, DatabaseRecord var3, List<DatabaseField> var4, List var5);

    public void logParameter(StringBuilder var1, Integer var2, PLSQLargument var3, AbstractRecord var4, DatabasePlatform var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseTypeHelper {
        databaseTypeHelper;


        static String getTruncatedSHA1Hash(String s) {
            StringBuilder sb = new StringBuilder(28);
            try {
                byte[] longIdentifierBytes = s.getBytes();
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(longIdentifierBytes, 0, longIdentifierBytes.length);
                byte[] digest = md.digest();
                byte[] truncDigest = new byte[14];
                System.arraycopy(digest, 0, truncDigest, 0, 14);
                sb.append(Helper.buildHexStringFromBytes(truncDigest));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            return sb.toString();
        }

        protected String getTruncatedSHA1Name(String argName, String prefix) {
            if (argName.length() >= ARGNAME_SIZE_LIMIT) {
                StringBuilder sb = new StringBuilder();
                sb.append(prefix);
                sb.append(DatabaseTypeHelper.getTruncatedSHA1Hash(argName));
                return sb.toString();
            }
            return argName;
        }

        public String buildTarget(PLSQLargument arg) {
            StringBuilder sb = new StringBuilder();
            if (arg.name.length() >= ARGNAME_SIZE_LIMIT) {
                sb.append(this.getTruncatedSHA1Name(arg.name, DatabaseType.TARGET_SHORT_PREFIX));
            } else {
                sb.append(arg.name);
                sb.append(DatabaseType.TARGET_SUFFIX);
            }
            return sb.toString();
        }

        public String buildCompatible(PLSQLargument arg) {
            StringBuilder sb = new StringBuilder();
            if (arg.name.length() >= ARGNAME_SIZE_LIMIT) {
                sb.append(this.getTruncatedSHA1Name(arg.name, DatabaseType.COMPAT_SHORT_PREFIX));
            } else {
                sb.append(arg.name);
                sb.append(DatabaseType.COMPAT_SUFFIX);
            }
            return sb.toString();
        }

        public void declareTarget(StringBuilder sb, PLSQLargument arg, DatabaseType databaseType) {
            sb.append("  ");
            sb.append(this.buildTarget(arg));
            sb.append(" ");
            sb.append(databaseType.getTypeName());
        }

        public int computeInIndex(PLSQLargument inArg, int newIndex) {
            inArg.inIndex = newIndex++;
            return newIndex;
        }

        public int computeOutIndex(PLSQLargument outArg, int newIndex) {
            outArg.outIndex = newIndex++;
            return newIndex;
        }

        public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg, PLSQLStoredProcedureCall call) {
            sb.append("  :");
            sb.append(outArg.outIndex);
            sb.append(" := ");
            sb.append(this.buildTarget(outArg));
            sb.append(";");
            sb.append(Helper.NL);
        }

        public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, List copyOfTranslationFields, List translationRowFields, List translationRowValues, StoredProcedureCall call) {
            DatabaseField field = null;
            for (DatabaseField f : copyOfTranslationFields) {
                if (!f.getName().equals(arg.name)) continue;
                field = f;
                break;
            }
            if (arg.length != Integer.MIN_VALUE) {
                field.setLength(arg.length);
            }
            if (arg.precision != Integer.MIN_VALUE) {
                field.setPrecision(arg.precision);
            }
            if (arg.scale != Integer.MIN_VALUE) {
                field.setScale(arg.scale);
            }
            translationRowFields.set(arg.inIndex - 1, field);
            Object value = copyOfTranslationRow.get(field);
            translationRowValues.set(arg.inIndex - 1, value);
        }

        public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, List<DatabaseField> outputRowFields, List outputRowValues) {
            DatabaseField field = null;
            for (DatabaseField f : outputRowFields) {
                if (!f.getName().equals(outArg.name)) continue;
                field = f;
                break;
            }
            Object value = outputRow.get(field);
            newOutputRow.add(field, value);
        }

        public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
            if (direction == DatasourceCall.IN && arg.inIndex != Integer.MIN_VALUE) {
                sb.append(":");
                sb.append(arg.inIndex);
                sb.append(" => ");
                sb.append(platform.convertToDatabaseType(translationRow.get(arg.name)));
            }
            if (direction == DatasourceCall.OUT && arg.outIndex != Integer.MIN_VALUE) {
                sb.append(arg.name);
                sb.append(" => :");
                sb.append(arg.outIndex);
            }
        }
    }
}

