/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Typemap;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;

public abstract class SqlTypeWithFields
extends SqlType {
    protected static Map<String, Boolean> m_builtin = new HashMap<String, Boolean>();
    protected List<AttributeField> m_fieldsPublishedOnly;
    protected List<AttributeField> m_fields;

    public SqlTypeWithFields(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        super(sqlName, typecode, generateMe, parentType, reflector);
    }

    public boolean isTopLevel() {
        return false;
    }

    @Override
    public List<AttributeField> getDeclaredFields(boolean publishedOnly) throws SQLException, PublisherException {
        if (publishedOnly) {
            if (this.m_fieldsPublishedOnly == null) {
                this.m_fieldsPublishedOnly = this.reflectFields(publishedOnly);
            }
            return this.m_fieldsPublishedOnly;
        }
        if (this.m_fields == null) {
            this.m_fields = this.reflectFields(publishedOnly);
        }
        return this.m_fields;
    }

    private List<AttributeField> reflectFields(boolean publishedOnly) throws SQLException, PublisherException {
        return SqlTypeWithFields.reflectFields(publishedOnly, this.getFieldInfo(), this.m_reflector, this, false);
    }

    public static List<AttributeField> reflectFields(boolean publishedOnly, List<FieldInfo> sfi, SqlReflector reflector, SqlType parent, boolean isGrandparent) throws SQLException, PublisherException {
        ArrayList<AttributeField> fieldsCS = new ArrayList<AttributeField>();
        ViewCache viewCache = reflector.getViewCache();
        Typemap map = new Typemap(parent, reflector);
        for (int ii = 0; sfi != null && ii < sfi.size(); ++ii) {
            try {
                Iterator<ViewRow> iter;
                FieldInfo fi = sfi.get(ii);
                int idx = fi.fieldNo;
                if (publishedOnly && map.getMemberName(fi.fieldName) == null) continue;
                String fieldTypeOwner = fi.fieldTypeOwner;
                if (m_builtin.get(fi.fieldTypeName) == null && !(iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME", "PREDEFINED"}, new Object[]{fieldTypeOwner, fi.fieldTypeName, "NO"}, new String[0])).hasNext() && (iter = viewCache.getRows("ALL_TYPES", new String[0], new String[]{"TYPE_NAME", "PREDEFINED"}, new Object[]{fi.fieldTypeName, "NO"}, new String[0])).hasNext()) {
                    fieldTypeOwner = ((AllTypes)iter.next()).owner;
                }
                fieldsCS.add(new AttributeField(fi.fieldName, (TypeClass)reflector.addPlsqlDBType(fieldTypeOwner, fi.fieldTypeName, fi.fieldTypeSubname, fi.fieldTypeMod, false, fi.fieldPackageName, fi.fieldMethodName, fi.fieldMethodNo, fi.fieldSequence, parent, isGrandparent), fi.fieldDataLength, fi.fieldDataPrecision, fi.fieldDataScale, fi.fieldCharacterSetName, reflector));
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return fieldsCS;
    }

    protected abstract List<FieldInfo> getFieldInfo() throws SQLException;

    static {
        m_builtin.put("VARCHAR2", Boolean.TRUE);
        m_builtin.put("NUMBER", Boolean.TRUE);
        m_builtin.put("DATE", Boolean.TRUE);
        m_builtin.put("BOOLEAN", Boolean.TRUE);
    }
}

