/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.r_osgi.identity;

import ch.ethz.iks.r_osgi.URI;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiID;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSNamespace;
import org.eclipse.ecf.provider.r_osgi.identity.R_OSGiWSSNamespace;

public class R_OSGiWSID
extends R_OSGiID {
    public static final int HTTPS_PORT = 443;
    public static final int HTTP_PORT = 80;
    private static final long serialVersionUID = -2801506059914687609L;
    private boolean secure;
    private String hostname;
    private int port;
    private String name;

    public R_OSGiWSID(boolean secure, String hostname, int port) {
        super(secure ? R_OSGiWSSNamespace.getDefault() : R_OSGiWSNamespace.getDefault());
        this.secure = secure;
        this.hostname = hostname;
        this.port = port;
        this.name = String.valueOf(this.getNamespace().getScheme()) + "://" + this.hostname + this.getPortAsString();
    }

    private String getPortAsString() {
        return this.isDefaultPort() ? "" : ":" + String.valueOf(this.port);
    }

    private boolean isDefaultPort() {
        if (this.port < 0) {
            return true;
        }
        return this.secure ? this.port == 443 : this.port == 80;
    }

    @Override
    protected int namespaceCompareTo(BaseID id) {
        return this.getName().compareTo(id.getName());
    }

    @Override
    protected boolean namespaceEquals(BaseID id) {
        if (id instanceof R_OSGiWSID) {
            R_OSGiWSID other = (R_OSGiWSID)id;
            return this.name.equals(other.name);
        }
        return false;
    }

    @Override
    public URI getURI() {
        return URI.create((String)(String.valueOf(this.secure ? "https" : "http") + "://" + this.hostname + this.getPortAsString()));
    }

    @Override
    protected String namespaceGetName() {
        return this.name;
    }

    @Override
    protected int namespaceHashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String toExternalForm() {
        return this.getName();
    }
}

