/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageEvent;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.ui.MessageNotificationPopup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class MessagesView
extends ViewPart {
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("(hh:mm:ss a)");
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.MessagesView";
    private static final int[] WEIGHTS = new int[]{75, 25};
    private CTabFolder tabFolder;
    private Color redColor;
    private Color blueColor;
    private Map tabs = new HashMap();
    private boolean showTimestamps = true;

    public void createPartControl(Composite parent) {
        boolean useTraditionalTabFolder = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
        this.tabFolder = new CTabFolder(parent, 64);
        this.tabFolder.setTabPosition(1024);
        this.tabFolder.setSimple(useTraditionalTabFolder);
        PlatformUI.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("SHOW_TRADITIONAL_STYLE_TABS") && !MessagesView.this.tabFolder.isDisposed()) {
                    MessagesView.this.tabFolder.setSimple(((Boolean)event.getNewValue()).booleanValue());
                    MessagesView.this.tabFolder.redraw();
                }
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ChatTab tab : MessagesView.this.tabs.values()) {
                    if (tab.item != e.item) continue;
                    tab.inputText.setFocus();
                    break;
                }
            }
        });
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent e) {
                for (Object key : MessagesView.this.tabs.keySet()) {
                    ChatTab tab = (ChatTab)MessagesView.this.tabs.get(key);
                    if (tab.item != e.item) continue;
                    MessagesView.this.tabs.remove(key);
                    break;
                }
            }
        });
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        Action timestampAction = new Action(Messages.MessagesView_ShowTimestamps, 2){

            public void run() {
                MessagesView.this.showTimestamps = !MessagesView.this.showTimestamps;
            }
        };
        timestampAction.setChecked(true);
        Action clearChatLogAction = new Action(Messages.MessagesView_ClearChatLog){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CTabItem item = MessagesView.this.tabFolder.getSelection();
                if (item != null) {
                    for (ChatTab tab : MessagesView.this.tabs.values()) {
                        if (tab.item != item) continue;
                        if (MessageDialog.openConfirm((Shell)MessagesView.this.tabFolder.getShell(), (String)Messages.MessagesView_ClearChatLogDialogTitle, (String)Messages.MessagesView_ClearChatLogDialogMessage)) {
                            ChatTab chatTab = tab;
                            synchronized (chatTab) {
                                tab.chatText.setText("");
                            }
                        }
                        return;
                    }
                }
            }
        };
        manager.add((IAction)clearChatLogAction);
        manager.add((IAction)timestampAction);
        this.redColor = new Color((Device)parent.getDisplay(), 255, 0, 0);
        this.blueColor = new Color((Device)parent.getDisplay(), 0, 0, 255);
    }

    public void dispose() {
        this.redColor.dispose();
        this.blueColor.dispose();
        super.dispose();
    }

    private ChatTab getTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID userID, String localName) {
        ChatTab tab = (ChatTab)this.tabs.get(userID);
        if (tab == null) {
            tab = new ChatTab(messageSender, typingSender, localID, userID, localName);
            this.tabs.put(userID, tab);
        }
        return tab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayTypingNotification(ITypingMessageEvent event) {
        ChatTab tab = null;
        Map map = this.tabs;
        synchronized (map) {
            tab = (ChatTab)this.tabs.get(event.getFromID());
        }
        if (tab != null) {
            tab.showIsTyping(event.getTypingMessage().isTyping());
        }
    }

    public synchronized void openTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID remoteID, String localName) {
        Assert.isNotNull((Object)messageSender);
        Assert.isNotNull((Object)localID);
        Assert.isNotNull((Object)remoteID);
        ChatTab tab = this.getTab(messageSender, typingSender, localID, remoteID, localName);
        if (this.tabs.size() == 1) {
            this.tabFolder.setSelection(tab.item);
        }
    }

    private static String getLocalName(ID id) {
        IChatID cID = (IChatID)id.getAdapter(IChatID.class);
        return cID == null ? id.getName() : cID.getUsername();
    }

    public synchronized void openTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID remoteID) {
        this.openTab(messageSender, typingSender, localID, remoteID, MessagesView.getLocalName(remoteID));
    }

    public synchronized void selectTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID userID, String localName) {
        ChatTab tab = this.getTab(messageSender, typingSender, localID, userID, localName);
        this.tabFolder.setSelection(tab.item);
        tab.inputText.setFocus();
    }

    public synchronized void selectTab(IChatMessageSender messageSender, ITypingMessageSender typingSender, ID localID, ID userID) {
        this.selectTab(messageSender, typingSender, localID, userID, MessagesView.getLocalName(userID));
    }

    public synchronized void showMessage(IChatMessage message) {
        Assert.isNotNull((Object)message);
        ID remoteID = message.getFromID();
        ChatTab tab = (ChatTab)this.tabs.get(remoteID);
        if (tab != null) {
            tab.append(remoteID, message.getBody());
        }
    }

    public void setFocus() {
        CTabItem item = this.tabFolder.getSelection();
        if (item != null) {
            for (ChatTab tab : this.tabs.values()) {
                if (tab.item != item) continue;
                tab.inputText.setFocus();
                break;
            }
        }
    }

    private class ChatTab {
        private CTabItem item;
        private StyledText chatText;
        private Text inputText;
        private IChatMessageSender icms;
        private ITypingMessageSender itms;
        private ID localID;
        private ID remoteID;
        private boolean sendTyping = false;
        private boolean isFirstMessage = true;
        private String localName;
        private SelectionListener scrollSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChatTab.this.shouldScrollToEnd(ChatTab.this.chatText)) {
                    ChatTab.this.boldTabTitle(false);
                }
            }
        };

        private ChatTab(IChatMessageSender icms, ITypingMessageSender itms, ID localID, ID remoteID, String localName) {
            this.icms = icms;
            this.itms = itms;
            this.localID = localID;
            this.remoteID = remoteID;
            this.localName = localName;
            this.constructWidgets();
            this.addListeners();
        }

        private void addListeners() {
            this.inputText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 13: 
                        case 0x1000050: {
                            if (e.stateMask != 0) break;
                            String text = ChatTab.this.inputText.getText();
                            ChatTab.this.inputText.setText("");
                            try {
                                if (!text.equals("")) {
                                    ChatTab.this.icms.sendChatMessage(ChatTab.this.remoteID, text);
                                }
                                ChatTab.this.append(ChatTab.this.localID, text);
                            }
                            catch (ECFException ex) {
                                String message = ex.getMessage();
                                if ((message == null || message.equals("")) && ((message = ex.getStatus().getMessage()) == null || message.equals(""))) {
                                    message = ex.getCause().getMessage();
                                }
                                if (message == null || message.equals("")) {
                                    MessagesView.this.setContentDescription(Messages.MessagesView_CouldNotSendMessage);
                                }
                                MessagesView.this.setContentDescription(NLS.bind((String)Messages.MessagesView_CouldNotSendMessageCauseKnown, (Object)message));
                            }
                            e.doit = false;
                            ChatTab.this.sendTyping = false;
                        }
                    }
                }
            });
            this.inputText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!ChatTab.this.sendTyping && ChatTab.this.itms != null) {
                        ChatTab.this.sendTyping = true;
                        try {
                            ChatTab.this.itms.sendTypingMessage(ChatTab.this.remoteID, true, null);
                        }
                        catch (ECFException ex) {
                            return;
                        }
                    }
                }
            });
            ScrollBar vscrollBar = this.chatText.getVerticalBar();
            if (vscrollBar != null) {
                vscrollBar.addSelectionListener(this.scrollSelectionListener);
                this.chatText.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ScrollBar bar = ChatTab.this.chatText.getVerticalBar();
                        if (bar != null) {
                            bar.removeSelectionListener(ChatTab.this.scrollSelectionListener);
                        }
                    }
                });
            }
        }

        private boolean shouldScrollToEnd(StyledText chatText1) {
            Point locAtEnd = chatText1.getLocationAtOffset(chatText1.getText().length());
            Rectangle bounds = chatText1.getBounds();
            return locAtEnd.y <= bounds.height + 5;
        }

        private void append(ID fromID, String body) {
            boolean scrollToEnd = this.shouldScrollToEnd(this.chatText);
            if (!this.isFirstMessage) {
                this.chatText.append(Text.DELIMITER);
            }
            int length = this.chatText.getCharCount();
            String name = this.localName;
            if (fromID.equals((Object)this.remoteID)) {
                if (MessagesView.this.showTimestamps) {
                    this.chatText.append(String.valueOf(FORMATTER.format(new Date(System.currentTimeMillis()))) + ' ');
                    this.chatText.setStyleRange(new StyleRange(length, 13, MessagesView.this.redColor, null));
                    length = this.chatText.getCharCount();
                }
                this.chatText.append(String.valueOf(name) + ": " + body);
                this.chatText.setStyleRange(new StyleRange(length, name.length() + 1, MessagesView.this.redColor, null, 1));
                MessagesView.this.setContentDescription("");
                if (this.isFirstMessage) {
                    final MessageNotificationPopup popup = new MessageNotificationPopup(MessagesView.this.getSite().getWorkbenchWindow(), MessagesView.this.tabFolder.getShell(), this.remoteID);
                    popup.setContent(name, body);
                    popup.open();
                    new UIJob(MessagesView.this.tabFolder.getDisplay(), "Close Popup Job"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            Shell shell = popup.getShell();
                            if (shell != null && !shell.isDisposed()) {
                                popup.close();
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(5000L);
                }
            } else {
                if (MessagesView.this.showTimestamps) {
                    this.chatText.append(String.valueOf(FORMATTER.format(new Date(System.currentTimeMillis()))) + ' ');
                    this.chatText.setStyleRange(new StyleRange(length, 13, MessagesView.this.blueColor, null));
                    length = this.chatText.getCharCount();
                }
                this.chatText.append(String.valueOf(name) + ": " + body);
                this.chatText.setStyleRange(new StyleRange(length, name.length() + 1, MessagesView.this.blueColor, null, 1));
            }
            this.isFirstMessage = false;
            if (scrollToEnd) {
                this.chatText.invokeAction(17039368);
            }
            this.boldTabTitle(!scrollToEnd);
        }

        private StyledText createStyledTextWidget(Composite parent) {
            try {
                SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
                result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
                result.setDocument((IDocument)new Document());
                return result.getTextWidget();
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.MessagesView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, 2634);
            }
            catch (NoClassDefFoundError e) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.presence.ui", 2, Messages.MessagesView_WARNING_HYPERLINKING_NOT_AVAILABLE, (Throwable)e));
                return new StyledText(parent, 2634);
            }
        }

        private void boldTabTitle(boolean bold) {
            Font oldFont = this.item.getFont();
            FontData[] fd = oldFont.getFontData();
            this.item.setFont(new Font(oldFont.getDevice(), fd[0].getName(), fd[0].getHeight(), bold ? 1 : 0));
        }

        private void constructWidgets() {
            this.item = new CTabItem(MessagesView.this.tabFolder, 0);
            Composite parent = new Composite((Composite)MessagesView.this.tabFolder, 0);
            parent.setLayout((Layout)new FillLayout());
            SashForm sash = new SashForm(parent, 512);
            this.chatText = this.createStyledTextWidget((Composite)sash);
            this.inputText = new Text((Composite)sash, 2562);
            sash.setWeights(WEIGHTS);
            Menu menu = new Menu((Control)this.chatText);
            MenuItem mi = new MenuItem(menu, 8);
            mi.setText(Messages.MessagesView_Copy);
            mi.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String text = ChatTab.this.chatText.getSelectionText();
                    if (!text.equals("")) {
                        ChatTab.this.chatText.copy();
                    }
                }
            });
            mi = new MenuItem(menu, 8);
            mi.setText(Messages.MessagesView_SelectAll);
            mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ChatTab.this.chatText.selectAll();
                }
            });
            this.chatText.setMenu(menu);
            this.item.setControl((Control)parent);
            this.item.setText(this.localName);
        }

        private void showIsTyping(boolean isTyping) {
            MessagesView.this.setContentDescription(isTyping ? NLS.bind((String)Messages.MessagesView_TypingNotification, (Object)this.localName) : "");
        }
    }
}

