/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class RosterWorkbenchAdapterFactory
implements IAdapterFactory {
    private IWorkbenchAdapter rosterAdapter = new IWorkbenchAdapter(){

        public Object[] getChildren(Object o) {
            IRoster roster = (IRoster)o;
            return roster.getItems().toArray();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return RosterWorkbenchAdapterFactory.this.getRosterImageDescriptor((IRoster)object);
        }

        public String getLabel(Object o) {
            return RosterWorkbenchAdapterFactory.this.getRosterLabel((IRoster)o);
        }

        public Object getParent(Object o) {
            return null;
        }
    };
    private IWorkbenchAdapter rosterGroupAdapter = new IWorkbenchAdapter(){

        public Object[] getChildren(Object o) {
            return ((IRosterGroup)o).getEntries().toArray();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return RosterWorkbenchAdapterFactory.this.getRosterGroupImageDescriptor((IRosterGroup)object);
        }

        public String getLabel(Object o) {
            return RosterWorkbenchAdapterFactory.this.getRosterGroupLabel((IRosterGroup)o);
        }

        public Object getParent(Object o) {
            return ((IRosterGroup)o).getParent();
        }
    };
    private IWorkbenchAdapter rosterItemAdapter = new IWorkbenchAdapter(){

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return RosterWorkbenchAdapterFactory.this.getRosterItemImageDescriptor((IRosterItem)object);
        }

        public String getLabel(Object o) {
            return RosterWorkbenchAdapterFactory.this.getRosterItemLabel((IRosterItem)o);
        }

        public Object getParent(Object o) {
            return ((IRosterItem)o).getParent();
        }
    };
    private IWorkbenchAdapter rosterEntryAdapter = new IWorkbenchAdapter(){

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return RosterWorkbenchAdapterFactory.this.getRosterEntryImageDescriptor((IRosterEntry)object);
        }

        public String getLabel(Object o) {
            return RosterWorkbenchAdapterFactory.this.getRosterEntryLabel((IRosterEntry)o);
        }

        public Object getParent(Object o) {
            return ((IRosterEntry)o).getParent();
        }
    };
    static /* synthetic */ Class class$0;

    protected ImageDescriptor getImageDescriptor(String iconFile) {
        return SharedImages.getImageDescriptor((String)iconFile);
    }

    protected String getRosterLabel(IRoster roster) {
        IUser user = roster.getUser();
        return user == null ? Messages.RosterWorkbenchAdapterFactory_Disconnected : user.getName();
    }

    protected ImageDescriptor getRosterImageDescriptor(IRoster roster) {
        IUser user = roster.getUser();
        if (user == null) {
            return this.getImageDescriptor("IMG_USER_UNAVAILABLE");
        }
        return this.getImageDescriptor("IMG_IDENTITY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getEntriesAvailableCount(Collection entries) {
        int count = 0;
        Collection collection = entries;
        synchronized (collection) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                IRosterEntry entry;
                Object o = i.next();
                if (!(o instanceof IRosterEntry) || !(entry = (IRosterEntry)o).getPresence().getType().equals((Object)IPresence.Type.AVAILABLE)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getEntriesTotalCount(Collection entries) {
        int count = 0;
        Collection collection = entries;
        synchronized (collection) {
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof IRosterEntry)) continue;
                ++count;
            }
        }
        return count;
    }

    protected String getRosterGroupLabel(IRosterGroup group) {
        Collection entries = group.getEntries();
        return NLS.bind((String)Messages.RosterWorkbenchAdapterFactory_GroupLabel, (Object[])new Object[]{group.getName(), Integer.toString(this.getEntriesAvailableCount(entries)), Integer.toString(this.getEntriesTotalCount(entries))});
    }

    protected ImageDescriptor getRosterGroupImageDescriptor(IRosterGroup group) {
        return this.getImageDescriptor("IMG_GROUP");
    }

    protected String getRosterItemLabel(IRosterItem item) {
        return item.getName();
    }

    protected ImageDescriptor getRosterItemImageDescriptor(IRosterItem item) {
        return null;
    }

    protected String getRosterEntryLabel(IRosterEntry entry) {
        return entry.getName();
    }

    protected ImageDescriptor getRosterEntryImageDescriptor(IRosterEntry entry) {
        IPresence p = entry.getPresence();
        if (p != null) {
            IPresence.Type pType = p.getType();
            IPresence.Mode pMode = p.getMode();
            if (pType.equals((Object)IPresence.Type.AVAILABLE)) {
                if (pMode.equals((Object)IPresence.Mode.AVAILABLE)) {
                    return this.getImageDescriptor("IMG_USER_AVAILABLE");
                }
                if (pMode.equals((Object)IPresence.Mode.AWAY) || pMode.equals((Object)IPresence.Mode.EXTENDED_AWAY)) {
                    return this.getImageDescriptor("IMG_USER_AWAY");
                }
                if (pMode.equals((Object)IPresence.Mode.DND)) {
                    return this.getImageDescriptor("IMG_USER_DND");
                }
            }
        }
        return this.getImageDescriptor("IMG_USER_UNAVAILABLE");
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapterType.equals(clazz)) {
            if (adaptableObject instanceof IRoster) {
                return this.rosterAdapter;
            }
            if (adaptableObject instanceof IRosterGroup) {
                return this.rosterGroupAdapter;
            }
            if (adaptableObject instanceof IRosterEntry) {
                return this.rosterEntryAdapter;
            }
            if (adaptableObject instanceof IRosterItem) {
                return this.rosterItemAdapter;
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return classArray;
    }
}

