/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.RosterGroup;
import org.eclipse.ecf.presence.roster.RosterItem;

public class RosterEntry
extends RosterItem
implements IRosterEntry {
    protected IUser user;
    protected IPresence presence;
    protected List groups;

    public RosterEntry(IRosterItem parent, IUser user, IPresence presenceState) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)user);
        this.parent = parent;
        this.user = user;
        this.presence = presenceState;
        this.groups = Collections.synchronizedList(new ArrayList());
        if (parent instanceof RosterGroup) {
            this.groups.add(parent);
            ((RosterGroup)parent).add(this);
        }
    }

    public void setPresence(IPresence newPresence) {
        this.presence = newPresence;
    }

    public String getName() {
        return this.user.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof RosterEntry) {
            RosterEntry re = (RosterEntry)obj;
            return re.getUser().getID().equals((Object)this.getUser().getID());
        }
        return false;
    }

    public int hashCode() {
        return this.getUser().getID().hashCode();
    }

    public boolean add(IRosterGroup group) {
        if (group == null) {
            return false;
        }
        return this.groups.add(group);
    }

    public boolean remove(IRosterGroup group) {
        if (group == null) {
            return false;
        }
        return this.groups.remove(group);
    }

    public IUser getUser() {
        return this.user;
    }

    public Collection getGroups() {
        return this.groups;
    }

    public IPresence getPresence() {
        return this.presence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = new StringBuffer("RosterEntry[");
        synchronized (stringBuffer) {
            sb.append("name=").append(this.getName()).append(';');
            sb.append("presence=").append(this.presence).append(';');
            sb.append("groups=");
            if (!this.groups.isEmpty()) {
                int i = 0;
                while (i < this.groups.size()) {
                    sb.append(((IRosterGroup)this.groups.get(i)).getName());
                    if (i < this.groups.size() - 1) {
                        sb.append(',');
                    }
                    ++i;
                }
            }
            sb.append(']');
        }
        return sb.toString();
    }
}

