/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescriptionLocator;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IEndpointDescriptionAdvertiser;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.IServiceInfoFactory;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ImmediateExecutor;
import org.eclipse.equinox.concurrent.future.ThreadsExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDescriptionAdvertiser
implements IEndpointDescriptionAdvertiser {
    private static final String advertiserFilter = System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.endpointDescriptionDiscoveryAdvertiserFilter");
    private static final String executorType = System.getProperty("org.eclipse.ecf.osgi.services.remoteserviceadmin.endpointDescriptionDiscoveryAdvertiserExecutorType", "immediate");
    private EndpointDescriptionLocator endpointDescriptionLocator;
    private List<String> filteredAdvertisers = new ArrayList<String>();
    private IExecutor executor;

    public EndpointDescriptionAdvertiser(EndpointDescriptionLocator endpointDescriptionLocator) {
        this.endpointDescriptionLocator = endpointDescriptionLocator;
        if (advertiserFilter != null) {
            try {
                String[] fas = advertiserFilter.split(",");
                if (fas != null) {
                    int i = 0;
                    while (i < fas.length) {
                        this.filteredAdvertisers.add(fas[i]);
                        ++i;
                    }
                }
            }
            catch (PatternSyntaxException fas) {
                // empty catch block
            }
        }
        for (String filteredAdvertiser : this.filteredAdvertisers) {
            this.trace("EndpointDescriptionAdvertiser<init>", "filtering advertiser=" + filteredAdvertiser);
        }
    }

    private IExecutor createExecutor() {
        if (executorType.equals("jobs")) {
            return new JobsExecutor(this.getClass().getName());
        }
        if (executorType.equals("threads")) {
            return new ThreadsExecutor();
        }
        return new ImmediateExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IExecutor getExecutor() {
        EndpointDescriptionAdvertiser endpointDescriptionAdvertiser = this;
        synchronized (endpointDescriptionAdvertiser) {
            if (this.executor == null) {
                this.executor = this.createExecutor();
            }
            return this.executor;
        }
    }

    @Override
    public IStatus advertise(EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, true);
    }

    protected void trace(String methodName, String message) {
        LogUtility.trace(methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionadvertiser", this.getClass(), message);
    }

    protected IStatus doDiscovery(final IDiscoveryAdvertiser discoveryAdvertiser, final IServiceInfo serviceInfo, final boolean advertise) {
        IProgressRunnable<IStatus> runnable = new IProgressRunnable<IStatus>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor monitor) throws Exception {
                block9: {
                    try {
                        if (advertise) {
                            EndpointDescriptionAdvertiser.this.trace("doDiscovery", "discoveryAdvertiser=" + discoveryAdvertiser + " serviceInfo=" + serviceInfo);
                            IDiscoveryAdvertiser iDiscoveryAdvertiser = discoveryAdvertiser;
                            synchronized (iDiscoveryAdvertiser) {
                                discoveryAdvertiser.registerService(serviceInfo);
                                break block9;
                            }
                        }
                        EndpointDescriptionAdvertiser.this.trace("doUndiscovery", "discoveryAdvertiser=" + discoveryAdvertiser + " serviceInfo=" + serviceInfo);
                        IDiscoveryAdvertiser iDiscoveryAdvertiser = discoveryAdvertiser;
                        synchronized (iDiscoveryAdvertiser) {
                            discoveryAdvertiser.unregisterService(serviceInfo);
                        }
                    }
                    catch (Exception e) {
                        LogUtility.logError("doDiscovery", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionadvertiser", this.getClass(), EndpointDescriptionAdvertiser.this.createErrorStatus("Unexplained exception in discoveryAdvertiserID=" + discoveryAdvertiser + " for serviceInfo=" + serviceInfo + " advertise=" + true));
                    }
                }
                return null;
            }
        };
        this.getExecutor().execute((IProgressRunnable)runnable, null);
        return Status.OK_STATUS;
    }

    protected IServiceInfoFactory getServiceInfoFactory() {
        return this.endpointDescriptionLocator.getServiceInfoFactory();
    }

    protected IDiscoveryAdvertiser[] getDiscoveryAdvertisers() {
        IDiscoveryAdvertiser[] unfilteredAdvertisers = this.endpointDescriptionLocator.getDiscoveryAdvertisers();
        ArrayList<IDiscoveryAdvertiser> results = new ArrayList<IDiscoveryAdvertiser>();
        if (unfilteredAdvertisers != null) {
            int i = 0;
            while (i < unfilteredAdvertisers.length) {
                String className = unfilteredAdvertisers[i].getClass().getName();
                if (!this.filteredAdvertisers.contains(className)) {
                    results.add(unfilteredAdvertisers[i]);
                } else {
                    LogUtility.logWarning("getDiscoveryAdvertisers", "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/endpointdescriptionadvertiser", this.getClass(), "Filtering out discoveryAdvertiser=" + className);
                }
                ++i;
            }
        }
        return results.toArray(new IDiscoveryAdvertiser[results.size()]);
    }

    protected IStatus createErrorStatus(String message) {
        return this.createErrorStatus(message, null);
    }

    protected IStatus createErrorStatus(String message, Throwable e) {
        return new Status(4, "org.eclipse.ecf.osgi.services.remoteserviceadmin", message, e);
    }

    protected IStatus doDiscovery(EndpointDescription endpointDescription, boolean advertise) {
        Assert.isNotNull((Object)((Object)endpointDescription));
        String messagePrefix = advertise ? "Advertise" : "Unadvertise";
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IServiceInfoFactory serviceInfoFactory = this.getServiceInfoFactory();
        if (serviceInfoFactory == null) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  No IServiceInfoFactory is available.  Cannot unpublish endpointDescription=" + (Object)((Object)endpointDescription));
        }
        IDiscoveryAdvertiser[] discoveryAdvertisers = this.getDiscoveryAdvertisers();
        if (discoveryAdvertisers == null || discoveryAdvertisers.length == 0) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  No endpointDescriptionLocator advertisers available.  Cannot " + (advertise ? "publish" : "unpublish") + " endpointDescription=" + (Object)((Object)endpointDescription));
        }
        int i = 0;
        while (i < discoveryAdvertisers.length) {
            IServiceInfo serviceInfo;
            IServiceInfo iServiceInfo = serviceInfo = advertise ? serviceInfoFactory.createServiceInfo(discoveryAdvertisers[i], endpointDescription) : serviceInfoFactory.removeServiceInfo(discoveryAdvertisers[i], endpointDescription);
            if (serviceInfo == null) {
                statuses.add(this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + (Object)((Object)endpointDescription) + ".  Service Info is null.  Cannot publish endpointDescription=" + (Object)((Object)endpointDescription)));
            } else {
                statuses.add(this.doDiscovery(discoveryAdvertisers[i], serviceInfo, advertise));
            }
            ++i;
        }
        return this.createResultStatus(statuses, String.valueOf(messagePrefix) + " endpointDesription=" + (Object)((Object)endpointDescription) + ".  Problem in unadvertise");
    }

    @Override
    public IStatus unadvertise(EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, false);
    }

    private IStatus createResultStatus(List<IStatus> statuses, String errorMessage) {
        ArrayList<IStatus> errorStatuses = new ArrayList<IStatus>();
        for (IStatus status : statuses) {
            if (status.isOK()) continue;
            errorStatuses.add(status);
        }
        if (errorStatuses.size() > 0) {
            return new MultiStatus("org.eclipse.ecf.osgi.services.remoteserviceadmin", 4, statuses.toArray(new IStatus[statuses.size()]), errorMessage, null);
        }
        return Status.OK_STATUS;
    }

    public void close() {
        this.filteredAdvertisers.clear();
        this.endpointDescriptionLocator = null;
        this.executor = null;
    }

    @Override
    public IStatus advertise(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, true);
    }

    protected IStatus doDiscovery(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription, boolean advertise) {
        Assert.isNotNull((Object)endpointDescription);
        String messagePrefix = advertise ? "Advertise" : "Unadvertise";
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IServiceInfoFactory serviceInfoFactory = this.getServiceInfoFactory();
        if (serviceInfoFactory == null) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + endpointDescription + ".  No IServiceInfoFactory is available.  Cannot unpublish endpointDescription=" + endpointDescription);
        }
        IDiscoveryAdvertiser[] discoveryAdvertisers = this.getDiscoveryAdvertisers();
        if (discoveryAdvertisers == null || discoveryAdvertisers.length == 0) {
            return this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + endpointDescription + ".  No endpointDescriptionLocator advertisers available.  Cannot " + (advertise ? "publish" : "unpublish") + " endpointDescription=" + endpointDescription);
        }
        int i = 0;
        while (i < discoveryAdvertisers.length) {
            IServiceInfo serviceInfo;
            IServiceInfo iServiceInfo = serviceInfo = advertise ? serviceInfoFactory.createServiceInfo(discoveryAdvertisers[i], endpointDescription) : serviceInfoFactory.removeServiceInfo(discoveryAdvertisers[i], endpointDescription);
            if (serviceInfo == null) {
                statuses.add(this.createErrorStatus(String.valueOf(messagePrefix) + " endpointDescription=" + endpointDescription + ".  Service Info is null.  Cannot publish endpointDescription=" + endpointDescription));
            } else {
                statuses.add(this.doDiscovery(discoveryAdvertisers[i], serviceInfo, advertise));
            }
            ++i;
        }
        return this.createResultStatus(statuses, String.valueOf(messagePrefix) + " endpointDesription=" + endpointDescription + ".  Problem in unadvertise");
    }

    @Override
    public IStatus unadvertise(org.osgi.service.remoteserviceadmin.EndpointDescription endpointDescription) {
        return this.doDiscovery(endpointDescription, false);
    }
}

