/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.TextParseException;

public class BnRDnsSdServiceTypeID
extends DnsSdServiceTypeID {
    private static final long serialVersionUID = -466458565598238072L;
    static final String BROWSE_DOMAINS = "b._dns-sd";
    static final String DEFAULT_BROWSE_DOMAIN = "db._dns-sd";
    static final String REG_DOMAINS = "r._dns-sd";
    static final String DEFAULT_REG_DOMAIN = "dr._dns-sd";

    BnRDnsSdServiceTypeID(IServiceTypeID aServiceType, String aService) {
        super(aServiceType.getNamespace(), aServiceType);
        this.services = new String[]{aService};
    }

    @Override
    Lookup[] getInternalQueries() {
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        int i = 0;
        while (i < this.scopes.length) {
            block4: {
                Lookup query;
                String scope = this.scopes[i];
                if (scope.endsWith(".")) {
                    scope = scope.substring(0, scope.length() - 1);
                }
                try {
                    query = new Lookup(this.services[0] + "._udp." + scope + ".", 12);
                }
                catch (TextParseException e) {
                    break block4;
                }
                result.add(query);
            }
            ++i;
        }
        return result.toArray(new Lookup[result.size()]);
    }

    void setScope(String target) {
        if (target.endsWith(".")) {
            target = target.substring(0, target.length() - 1);
        }
        this.scopes = new String[]{target};
        this.createType();
    }

    Collection getScopesAsZones() {
        ArrayList<CallSite> res = new ArrayList<CallSite>(this.scopes.length);
        int i = 0;
        while (i < this.scopes.length) {
            String scope = this.scopes[i];
            res.add((CallSite)((Object)(scope + ".")));
            ++i;
        }
        return res;
    }
}

