/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.eclipse.ecf.remoteservice.RemoteServiceID;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientReference;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistry;

public class RemoteServiceClientRegistration
implements IRemoteServiceRegistration {
    protected static final String CLASS_METHOD_SEPARATOR = ".";
    protected String[] clazzes;
    protected IRemoteCallable[][] callables;
    protected IRemoteServiceReference reference;
    protected Dictionary properties;
    protected ID containerId;
    protected RemoteServiceClientRegistry registry;
    protected IRemoteServiceID serviceID;
    private ClassLoader classLoader = null;

    public RemoteServiceClientRegistration(Namespace namespace, String[] classNames, IRemoteCallable[][] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
        Assert.isNotNull((Object)classNames);
        this.clazzes = classNames;
        Assert.isNotNull((Object)restCalls);
        this.callables = restCalls;
        this.properties = properties;
        this.containerId = registry.getContainerId();
        this.reference = new RemoteServiceClientReference(this);
        this.registry = registry;
        this.serviceID = new RemoteServiceID(namespace, this.containerId, registry.getNextServiceId());
    }

    public RemoteServiceClientRegistration(Namespace namespace, IRemoteCallable[] restCalls, Dictionary properties, RemoteServiceClientRegistry registry) {
        Assert.isNotNull((Object)restCalls);
        this.clazzes = new String[restCalls.length];
        int i = 0;
        while (i < restCalls.length) {
            this.clazzes[i] = restCalls[i].getMethod();
            ++i;
        }
        this.callables = new IRemoteCallable[][]{restCalls};
        this.properties = properties;
        this.containerId = registry.getContainerId();
        this.reference = new RemoteServiceClientReference(this);
        this.registry = registry;
        this.serviceID = new RemoteServiceID(namespace, this.containerId, registry.getNextServiceId());
    }

    public String[] getClazzes() {
        return this.clazzes;
    }

    @Override
    public ID getContainerID() {
        return this.containerId;
    }

    @Override
    public IRemoteServiceID getID() {
        return this.serviceID;
    }

    @Override
    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @Override
    public String[] getPropertyKeys() {
        if (this.properties == null) {
            return new String[0];
        }
        int length = this.properties.size();
        Enumeration keys = this.properties.keys();
        String[] result = new String[length];
        int i = 0;
        while (keys.hasMoreElements()) {
            Object element = keys.nextElement();
            if (!(element instanceof String)) continue;
            result[i] = (String)element;
            ++i;
        }
        return result;
    }

    @Override
    public IRemoteServiceReference getReference() {
        return this.reference;
    }

    @Override
    public void setProperties(Dictionary properties) {
        this.properties = properties;
    }

    @Override
    public void unregister() {
        this.registry.unregisterRegistration(this);
        this.classLoader = null;
    }

    protected IRemoteCallable findDefaultRemoteCallable(String methodToFind) {
        int i = 0;
        while (i < this.callables.length) {
            String className = this.clazzes[i];
            IRemoteCallable[] subArray = this.callables[i];
            int j = 0;
            while (j < subArray.length) {
                IRemoteCallable def = subArray[j];
                String defMethod = def.getMethod();
                if (defMethod != null && defMethod.equals(methodToFind)) {
                    return def;
                }
                String fqDefMethod = RemoteServiceClientRegistration.getFQMethod(className, defMethod);
                if (fqDefMethod.equals(methodToFind)) {
                    return def;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static String getFQMethod(String className, String defMethod) {
        return String.valueOf(className) + CLASS_METHOD_SEPARATOR + defMethod;
    }

    protected IRemoteCallable findRemoteCallable(IRemoteCall remoteCall) {
        String callMethod = remoteCall.getMethod();
        if (callMethod == null) {
            return null;
        }
        IRemoteCallable defaultRestCall = null;
        int i = 0;
        while (i < this.clazzes.length) {
            if (this.clazzes[i].equals(callMethod)) {
                defaultRestCall = this.callables[i][0];
            }
            ++i;
        }
        return defaultRestCall != null ? defaultRestCall : this.findDefaultRemoteCallable(callMethod);
    }

    public IRemoteCallable lookupCallable(IRemoteCall remoteCall) {
        if (remoteCall == null) {
            return null;
        }
        return this.findRemoteCallable(remoteCall);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }
}

