/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient45;

import java.io.IOException;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.filetransfer.BrowseFileTransferException;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemRequest;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.DefaultNTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.ECFHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.HttpClientProxyCredentialProvider;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.IHttpClientFactory;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.INTLMProxyHandler;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.Messages;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.NTLMProxyDetector;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.httpclient45.HttpClientOptions;
import org.eclipse.ecf.provider.filetransfer.httpclient45.HttpClientRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.osgi.util.NLS;

public class HttpClientFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    protected static final int DEFAULT_CONNECTION_TIMEOUT = HttpClientOptions.BROWSE_DEFAULT_CONNECTION_TIMEOUT;
    private static final String USERNAME_PREFIX = "Username:";
    private JREProxyHelper proxyHelper = null;
    protected String username = null;
    protected String password = null;
    protected CloseableHttpClient httpClient = null;
    private RequestConfig.Builder requestConfigBuilder;
    private HttpClientProxyCredentialProvider credentialsProvider;
    protected volatile HttpHead headMethod;
    protected volatile CloseableHttpResponse httpResponse;
    protected volatile HttpClientContext httpContext;

    public HttpClientFileSystemBrowser(CloseableHttpClient httpClient, IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, directoryOrFileURL, connectContext, proxy);
        Assert.isNotNull((Object)httpClient);
        this.httpClient = httpClient;
        this.credentialsProvider = new HttpClientProxyCredentialProvider(){

            @Override
            protected Proxy getECFProxy() {
                return HttpClientFileSystemBrowser.this.getProxy();
            }

            @Override
            protected boolean allowNTLMAuthentication() {
                DefaultNTLMProxyHandler.setSeenNTLM();
                return ECFHttpClientFactory.getNTLMProxyHandler((HttpContext)HttpClientFileSystemBrowser.this.httpContext).allowNTLMAuthentication(null);
            }
        };
        IHttpClientFactory httpClientFactory = Activator.getDefault().getHttpClientFactory();
        CredentialsProvider contextCredentialsProvider = ECFHttpClientFactory.modifyCredentialsProvider((CredentialsProvider)this.credentialsProvider);
        this.httpContext = httpClientFactory.newClientContext();
        this.httpContext.setCredentialsProvider(contextCredentialsProvider);
        this.proxyHelper = new JREProxyHelper();
    }

    protected IRemoteFileSystemRequest createRemoteFileSystemRequest() {
        return new HttpClientRemoteFileSystemRequest();
    }

    protected void cancel() {
        if (this.isCanceled()) {
            return;
        }
        this.setCanceled(this.getException());
        super.cancel();
        if (this.headMethod != null && !this.headMethod.isAborted()) {
            this.headMethod.abort();
        }
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getSocksProxy((URL)this.directoryOrFile);
                if (this.proxy == null) {
                    this.proxy = ProxySetupHelper.getProxy((String)this.directoryOrFile.toExternalForm());
                }
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    protected void cleanUp() {
        this.clearProxy();
        this.headMethod = null;
        this.requestConfigBuilder = null;
        super.cleanUp();
    }

    protected void runRequest() throws Exception {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"runRequest");
        String urlString = this.directoryOrFile.toString();
        this.requestConfigBuilder = Activator.getDefault().getHttpClientFactory().newRequestConfig(this.httpContext, null);
        this.requestConfigBuilder.setSocketTimeout(DEFAULT_CONNECTION_TIMEOUT).setConnectTimeout(DEFAULT_CONNECTION_TIMEOUT);
        this.setupProxies();
        this.setupAuthentication(urlString);
        this.headMethod = new HttpHead(urlString);
        this.headMethod.setConfig(this.requestConfigBuilder.build());
        int maxAge = Integer.getInteger("org.eclipse.ecf.http.cache.max-age", 0);
        if (maxAge == 0) {
            this.headMethod.addHeader("Cache-Control", "max-age=0");
        } else if (maxAge > 0) {
            this.headMethod.addHeader("Cache-Control", "max-age=" + maxAge);
        }
        long lastModified = 0L;
        long fileLength = -1L;
        int code = -1;
        try {
            try {
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)("browse=" + urlString));
                this.httpResponse = this.httpClient.execute((HttpUriRequest)this.headMethod, (HttpContext)this.httpContext);
                code = this.httpResponse.getStatusLine().getStatusCode();
                Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)("browse resp=" + code));
                boolean ntlmProxyFound = NTLMProxyDetector.detectNTLMProxy((HttpContext)this.httpContext);
                if (ntlmProxyFound) {
                    this.getNTLMProxyHandler((HttpContext)this.httpContext).handleNTLMProxy(this.getProxy(), code);
                }
                if (NTLMProxyDetector.detectSPNEGOProxy((HttpContext)this.httpContext)) {
                    this.getNTLMProxyHandler((HttpContext)this.httpContext).handleSPNEGOProxy(this.getProxy(), code);
                }
                if (code == 200) {
                    Header contentLength = this.httpResponse.getLastHeader(CONTENT_LENGTH_HEADER);
                    if (contentLength != null) {
                        fileLength = Integer.parseInt(contentLength.getValue());
                    }
                } else {
                    if (code == 404) {
                        throw new BrowseFileTransferException(NLS.bind((String)"File not found: {0}", (Object)urlString), code);
                    }
                    if (code == 401) {
                        throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Unauthorized, code);
                    }
                    if (code == 403) {
                        throw new BrowseFileTransferException("Forbidden", code);
                    }
                    if (code == 407) {
                        throw new BrowseFileTransferException(Messages.HttpClientRetrieveFileTransfer_Proxy_Auth_Required, code);
                    }
                    throw new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_ERROR_GENERAL_RESPONSE_CODE, (Object)new Integer(code)), code);
                }
                lastModified = this.getLastModifiedTimeFromHeader();
                this.remoteFiles = new IRemoteFile[1];
                this.remoteFiles[0] = new URLRemoteFile(lastModified, fileLength, this.fileID);
            }
            catch (Exception e) {
                Trace.throwing((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/throwing", ((Object)((Object)this)).getClass(), (String)"runRequest", (Throwable)e);
                BrowseFileTransferException ex = (BrowseFileTransferException)(e instanceof BrowseFileTransferException ? e : new BrowseFileTransferException(NLS.bind((String)Messages.HttpClientRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)urlString), (Throwable)e, code));
                throw ex;
            }
        }
        finally {
            if (this.httpResponse != null) {
                this.httpResponse.close();
            }
        }
    }

    private INTLMProxyHandler getNTLMProxyHandler(HttpContext httpContext) {
        Object value = httpContext.getAttribute(ECFHttpClientFactory.NTLM_PROXY_HANDLER_ATTR);
        if (value instanceof INTLMProxyHandler) {
            return (INTLMProxyHandler)value;
        }
        return Activator.getDefault().getNTLMProxyHandler();
    }

    private long getLastModifiedTimeFromHeader() throws IOException {
        Header lastModifiedHeader = this.httpResponse.getLastHeader("Last-Modified");
        if (lastModifiedHeader == null) {
            return 0L;
        }
        String lastModifiedString = lastModifiedHeader.getValue();
        long lastModified = 0L;
        if (lastModifiedString != null) {
            try {
                lastModified = DateUtils.parseDate((String)lastModifiedString).getTime();
            }
            catch (Exception e) {
                throw new IOException(Messages.HttpClientRetrieveFileTransfer_EXCEPITION_INVALID_LAST_MODIFIED_FROM_SERVER);
            }
        }
        return lastModified;
    }

    Proxy getProxy() {
        return this.proxy;
    }

    protected Credentials getFileRequestCredentials() throws UnsupportedCallbackException, IOException {
        if (this.connectContext == null) {
            return null;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return null;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        this.password = (String)passwordCallback.getObject();
        return new UsernamePasswordCredentials(this.username, this.password);
    }

    protected void setupAuthentication(String urlString) throws UnsupportedCallbackException, IOException {
        Credentials credentials = null;
        if (this.username == null) {
            credentials = this.getFileRequestCredentials();
        }
        if (credentials != null && this.username != null) {
            AuthScope authScope = new AuthScope(HttpClientRetrieveFileTransfer.getHostFromURL(urlString), HttpClientRetrieveFileTransfer.getPortFromURL(urlString), AuthScope.ANY_REALM);
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)("browse credentials=" + credentials));
            this.credentialsProvider.setCredentials(authScope, credentials);
        }
    }

    protected void setupProxy(Proxy proxy) {
        if (proxy.getType().equals(Proxy.Type.HTTP)) {
            ProxyAddress address = proxy.getAddress();
            this.requestConfigBuilder.setProxy(new HttpHost(address.getHostName(), address.getPort()));
        } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)("browse socksproxy=" + proxy.getAddress()));
            this.requestConfigBuilder.setProxy(null);
            this.proxyHelper.setupProxy(proxy);
        }
    }

    protected void clearProxy() {
        if (this.requestConfigBuilder != null) {
            this.requestConfigBuilder.setProxy(null);
        }
    }

    class HttpClientRemoteFileSystemRequest
    extends AbstractFileSystemBrowser.RemoteFileSystemRequest {
        HttpClientRemoteFileSystemRequest() {
            super((AbstractFileSystemBrowser)HttpClientFileSystemBrowser.this);
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == null) {
                return null;
            }
            if (adapter.isInstance((Object)this)) {
                return adapter.cast((Object)this);
            }
            return null;
        }

        public void cancel() {
            HttpClientFileSystemBrowser.this.cancel();
        }
    }
}

