/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.examples.internal.eventadmin.app;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.examples.internal.eventadmin.app.Activator;
import org.eclipse.ecf.examples.internal.eventadmin.app.ExampleSerializationHandler;
import org.eclipse.ecf.remoteservice.eventadmin.DistributedEventAdmin;
import org.eclipse.ecf.remoteservice.eventadmin.serialization.SerializationHandler;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public abstract class AbstractEventAdminApplication
implements IApplication {
    public static final String DEFAULT_TOPIC = "defaultTopic";
    protected BundleContext bundleContext;
    protected String containerType;
    protected String containerId;
    protected String targetId;
    protected String[] topics = new String[]{"defaultTopic", "anotherTopic", "anotherTopic/subTopic"};
    protected ServiceTracker containerManagerTracker;
    private final Object appLock = new Object();
    private boolean done = false;
    protected DistributedEventAdmin eventAdminImpl;
    protected ServiceRegistration eventAdminRegistration;
    protected IContainer container;

    protected Object startup(IApplicationContext context) throws Exception {
        this.bundleContext = Activator.getContext();
        this.bundleContext.registerService(SerializationHandler.class, (Object)new ExampleSerializationHandler(DEFAULT_TOPIC), null);
        this.bundleContext.registerService(SerializationHandler.class, (Object)new ExampleSerializationHandler(DEFAULT_TOPIC), null);
        String[] args = this.mungeArguments((String[])context.getArguments().get("application.args"));
        this.processArgs(args);
        this.eventAdminImpl = new DistributedEventAdmin(this.bundleContext);
        this.createConfigureAndConnectContainer();
        this.eventAdminImpl.start();
        Properties props = new Properties();
        props.put("event.topics", this.topics);
        this.eventAdminRegistration = this.bundleContext.registerService("org.osgi.service.event.EventAdmin", (Object)this.eventAdminImpl, (Dictionary)props);
        return IApplication.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.eventAdminRegistration != null) {
            this.eventAdminRegistration.unregister();
            this.eventAdminRegistration = null;
        }
        if (this.container != null) {
            this.container.dispose();
            this.getContainerManager().removeAllContainers();
            this.container = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
        this.bundleContext = null;
    }

    protected Object run() {
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    public Object start(IApplicationContext context) throws Exception {
        Object startupResult = this.startup(context);
        if (!startupResult.equals(IApplication.EXIT_OK)) {
            return startupResult;
        }
        return this.run();
    }

    private String[] mungeArguments(String[] originalArgs) {
        if (originalArgs == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < originalArgs.length) {
            if (!originalArgs[i].equals("-pdelaunch")) {
                l.add(originalArgs[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    protected void usage() {
        System.out.println("Usage: eclipse.exe -application " + this.usageApplicationId() + " " + this.usageParameters());
    }

    protected abstract String usageApplicationId();

    protected abstract String usageParameters();

    protected abstract void processArgs(String[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() {
        this.shutdown();
    }

    protected void createConfigureAndConnectContainer() throws ContainerCreateException, SharedObjectAddException, ContainerConnectException {
        IContainerFactory containerFactory = this.getContainerManager().getContainerFactory();
        this.container = this.containerId == null ? containerFactory.createContainer(this.containerType) : containerFactory.createContainer(this.containerType, new Object[]{this.containerId});
        ISharedObjectContainer soContainer = (ISharedObjectContainer)this.container.getAdapter(ISharedObjectContainer.class);
        soContainer.getSharedObjectManager().addSharedObject(IDFactory.getDefault().createStringID(DEFAULT_TOPIC), (ISharedObject)this.eventAdminImpl, null);
        if (this.targetId != null) {
            this.container.connect(IDFactory.getDefault().createID(this.container.getConnectNamespace(), this.targetId), null);
        }
    }

    protected IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(this.bundleContext, IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }
}

