/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.tooling.bndtools.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.remoteservices.tooling.bndtools.Activator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class EditorColors {
    private static final Map<Integer, Color> intToColor = new HashMap<Integer, Color>();

    public static Color getColor(RGB rgb) {
        Integer colorInt = EditorColors.rgbToInteger(rgb);
        Color color = intToColor.get(colorInt);
        if (color == null) {
            color = new Color((Device)Display.getDefault(), rgb);
            intToColor.put(colorInt, color);
        }
        return color;
    }

    public static Color getColor(String preference) {
        return EditorColors.getColor(PreferenceConverter.getColor((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)preference));
    }

    private static Integer rgbToInteger(RGB rgb) {
        return ((rgb.red & 0xFF) << 16) + ((rgb.green & 0xFF) << 8) + (rgb.blue & 0xFF);
    }
}

