/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservice;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.AdapterManagerTracker;
import org.eclipse.ecf.core.util.BundleClassResolver;
import org.eclipse.ecf.core.util.ClassResolverObjectInputStream;
import org.eclipse.ecf.core.util.IClassResolver;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxyCreator;
import org.eclipse.ecf.remoteservice.RemoteServiceNamespace;
import org.eclipse.ecf.remoteservice.provider.AdapterConfig;
import org.eclipse.ecf.remoteservice.provider.IRemoteServiceDistributionProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.remoteservice";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceRegistration remoteServiceProxyCreator;
    private RemoteServiceNamespace remoteServiceNamespace;
    private ServiceTracker<IRemoteServiceDistributionProvider, IRemoteServiceDistributionProvider> distributionProviderTracker;
    static final List<String> excludeDistributionProviders;
    Map<ServiceReference<IRemoteServiceDistributionProvider>, RSDPRegistrations> svcRefToDSDPRegMap;
    private ServiceTrackerCustomizer<IRemoteServiceDistributionProvider, IRemoteServiceDistributionProvider> distributionProviderCustomizer = new ServiceTrackerCustomizer<IRemoteServiceDistributionProvider, IRemoteServiceDistributionProvider>(){

        public IRemoteServiceDistributionProvider addingService(ServiceReference<IRemoteServiceDistributionProvider> reference) {
            BundleContext bundleContext = Activator.this.getContext();
            IRemoteServiceDistributionProvider dProvider = (IRemoteServiceDistributionProvider)bundleContext.getService(reference);
            if (dProvider != null) {
                ContainerTypeDescription ctd = dProvider.getContainerTypeDescription();
                if (ctd == null) {
                    Activator.this.log((IStatus)new Status(4, Activator.PLUGIN_ID, "Remote Service Provider Container Type Description cannot be null"));
                } else if (excludeDistributionProviders.contains(ctd.getName())) {
                    Activator.this.log((IStatus)new Status(2, Activator.PLUGIN_ID, "Remote Service Provider name=" + ctd.getName() + " excluded"));
                } else {
                    IAdapterManager am;
                    Dictionary<String, ?> ctdProps = dProvider.getContainerTypeDescriptionProperties();
                    ServiceRegistration ctdSR = bundleContext.registerService(ContainerTypeDescription.class, (Object)ctd, ctdProps);
                    Namespace ns = dProvider.getNamespace();
                    ServiceRegistration nsSR = null;
                    if (ns != null) {
                        nsSR = bundleContext.registerService(Namespace.class, (Object)ns, dProvider.getNamespaceProperties());
                    }
                    if ((am = Activator.this.getAdapterManager()) == null) {
                        Activator.this.log((IStatus)new Status(4, Activator.PLUGIN_ID, "No adapter manager available for remote service containers"));
                    }
                    AdapterConfig[] adapterConfigs = dProvider.getAdapterConfigs();
                    IAdapterFactory adapterFactory = null;
                    if (adapterConfigs != null) {
                        AdapterConfig[] adapterConfigArray = adapterConfigs;
                        int n = adapterConfigs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AdapterConfig adapterConfig = adapterConfigArray[n2];
                            adapterFactory = adapterConfig.getAdapterFactory();
                            Class<?> adapterClass = adapterConfig.getAdaptable();
                            if (adapterFactory == null || adapterClass == null) {
                                Activator.this.log((IStatus)new Status(4, Activator.PLUGIN_ID, "Invalid adapter config for distribution provider=" + ctd.getName()));
                            } else {
                                am.registerAdapters(adapterFactory, adapterClass);
                            }
                            ++n2;
                        }
                    }
                    if (ctdSR != null) {
                        Activator.this.svcRefToDSDPRegMap.put(reference, new RSDPRegistrations((ServiceRegistration<ContainerTypeDescription>)ctdSR, (ServiceRegistration<Namespace>)nsSR, adapterFactory));
                    }
                }
            }
            return dProvider;
        }

        public void modifiedService(ServiceReference<IRemoteServiceDistributionProvider> reference, IRemoteServiceDistributionProvider service) {
        }

        public void removedService(ServiceReference<IRemoteServiceDistributionProvider> reference, IRemoteServiceDistributionProvider service) {
            RSDPRegistrations regs = Activator.this.svcRefToDSDPRegMap.remove(reference);
            if (regs != null) {
                regs.unregisterServices();
            }
        }
    };

    static {
        excludeDistributionProviders = Arrays.asList(System.getProperty("org.eclipse.ecf.remoteservice.excludeDistributionProviders", "").split(","));
    }

    public Activator() {
        plugin = this;
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext c) throws Exception {
        this.context = c;
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", Integer.MIN_VALUE);
        this.remoteServiceProxyCreator = this.context.registerService(new String[]{IRemoteServiceProxyCreator.class.getName()}, (Object)new IRemoteServiceProxyCreator(){

            @Override
            public Object createProxy(ClassLoader classloader, Class[] interfaces, InvocationHandler handler) {
                return Proxy.newProxyInstance(classloader, interfaces, handler);
            }
        }, props);
        this.remoteServiceNamespace = new RemoteServiceNamespace("ecf.namespace.remoteservice", "remote service namespace");
        IDFactory.getDefault().addNamespace((Namespace)this.remoteServiceNamespace);
        this.svcRefToDSDPRegMap = Collections.synchronizedMap(new HashMap());
        this.distributionProviderTracker = new ServiceTracker(this.getContext(), IRemoteServiceDistributionProvider.class, this.distributionProviderCustomizer);
        this.distributionProviderTracker.open();
        Hashtable<String, String> crProps = new Hashtable<String, String>();
        crProps.put("org.eclipse.ecf.core.util.classresolver.bundleSymbolicName", PLUGIN_ID);
        this.context.registerService(IClassResolver.class, (Object)new BundleClassResolver(this.context.getBundle()), crProps);
    }

    public ObjectInputStream createObjectInputStream(InputStream ins) throws IOException {
        return ClassResolverObjectInputStream.create((BundleContext)this.context, (InputStream)ins);
    }

    public void stop(BundleContext c) throws Exception {
        if (this.distributionProviderTracker != null) {
            this.distributionProviderTracker.close();
            this.distributionProviderTracker = null;
        }
        if (this.remoteServiceProxyCreator != null) {
            this.remoteServiceProxyCreator.unregister();
            this.remoteServiceProxyCreator = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.remoteServiceNamespace != null) {
            IDFactory.getDefault().removeNamespace((Namespace)this.remoteServiceNamespace);
            this.remoteServiceNamespace = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public IAdapterManager getAdapterManager() {
        if (this.context == null) {
            return null;
        }
        AdapterManagerTracker t = new AdapterManagerTracker(this.context);
        t.open();
        IAdapterManager am = t.getAdapterManager();
        t.close();
        return am;
    }

    class RSDPRegistrations {
        private ServiceRegistration<ContainerTypeDescription> ctdSR;
        private ServiceRegistration<Namespace> nsSR;
        private IAdapterFactory af;

        RSDPRegistrations(ServiceRegistration<ContainerTypeDescription> ctdSR, ServiceRegistration<Namespace> nsSR, IAdapterFactory af) {
            this.ctdSR = ctdSR;
            this.nsSR = nsSR;
            this.af = af;
        }

        void unregister(ServiceRegistration<?> reg) {
            try {
                reg.unregister();
            }
            catch (Exception e) {
                Activator.this.log((IStatus)new Status(4, Activator.PLUGIN_ID, "Could not unregister serviceReg=" + this.ctdSR, (Throwable)e));
            }
        }

        synchronized void unregisterServices() {
            IAdapterManager am;
            if (this.ctdSR != null) {
                this.unregister(this.ctdSR);
                this.ctdSR = null;
            }
            if (this.nsSR != null) {
                this.unregister(this.nsSR);
                this.nsSR = null;
            }
            if (this.af != null && (am = Activator.this.getAdapterManager()) != null) {
                am.unregisterAdapters(this.af);
                this.af = null;
            }
        }
    }
}

