/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectHandlerPolicy;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.generic.SOContainerConfig;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainerGroup;
import org.eclipse.ecf.server.generic.app.Connector;
import org.eclipse.ecf.server.generic.app.NamedGroup;
import org.eclipse.ecf.server.generic.app.ServerConfigParser;

public abstract class AbstractGenericServerApplication {
    protected TCPServerSOContainerGroup[] serverGroups;
    protected String configURL;
    protected String serverName;

    protected void processArguments(String[] args) {
        this.configURL = null;
        this.serverName = TCPServerSOContainer.getDefaultServerURL();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-configURL")) {
                this.configURL = args[i + 1];
                ++i;
            } else if (args[i].equals("-serverName")) {
                this.serverName = args[i + 1];
                ++i;
            }
            ++i;
        }
    }

    protected void initialize() throws Exception {
        List connectors = null;
        if (this.configURL != null) {
            try (InputStream ins = null;){
                try {
                    ins = new URL(this.configURL).openStream();
                }
                catch (MalformedURLException e) {
                    ins = new FileInputStream(this.configURL);
                }
                connectors = new ServerConfigParser().load(ins);
            }
            this.initializeFromConnectors(connectors);
        } else {
            this.initializeSingleServer();
        }
    }

    protected void initializeSingleServer() throws IOException, URISyntaxException {
        String name;
        URI anURL = new URI(this.serverName);
        int port = anURL.getPort();
        if (port == -1) {
            port = TCPServerSOContainer.DEFAULT_PORT;
        }
        if ((name = anURL.getPath()) == null) {
            name = TCPServerSOContainer.DEFAULT_NAME;
        }
        this.serverGroups = new TCPServerSOContainerGroup[1];
        this.serverGroups[0] = new TCPServerSOContainerGroup(anURL.getPort());
        TCPServerSOContainer server = this.createServerContainer(this.serverName, this.serverGroups[0], name, TCPServerSOContainer.DEFAULT_KEEPALIVE);
        this.setupServerContainer(server);
        this.serverGroups[0].putOnTheAir();
    }

    protected void initializeFromConnectors(List connectors) throws IOException {
        if (connectors == null) {
            return;
        }
        this.serverGroups = new TCPServerSOContainerGroup[connectors.size()];
        int j = 0;
        for (Connector connector : connectors) {
            this.serverGroups[j] = new TCPServerSOContainerGroup(connector.getHostname(), connector.getPort());
            List groups = connector.getGroups();
            for (NamedGroup group : groups) {
                TCPServerSOContainer container = this.createServerContainer(group.getIDForGroup(), this.serverGroups[j], group.getName(), connector.getTimeout());
                this.setupServerContainer(container);
            }
            this.serverGroups[j].putOnTheAir();
            ++j;
        }
    }

    protected TCPServerSOContainer createServerContainer(String id, TCPServerSOContainerGroup group, String path, int keepAlive) throws IDCreateException {
        return new TCPServerSOContainer((ISharedObjectContainerConfig)new SOContainerConfig(IDFactory.getDefault().createStringID(id)), group, path, keepAlive);
    }

    protected void setupServerContainer(TCPServerSOContainer container) {
        container.setConnectPolicy((IConnectHandlerPolicy)new SysOutConnectHandlerPolicy());
        container.addListener((IContainerListener)new ContainerListener());
    }

    protected void shutdown() {
        if (this.serverGroups != null) {
            int i = 0;
            while (i < this.serverGroups.length) {
                this.serverGroups[i].takeOffTheAir();
                Iterator iter = this.serverGroups[i].elements();
                while (iter.hasNext()) {
                    ((TCPServerSOContainer)iter.next()).dispose();
                }
                ++i;
            }
            this.serverGroups = null;
        }
    }

    static class ContainerListener
    implements IContainerListener {
        ContainerListener() {
        }

        public void handleEvent(IContainerEvent event) {
            if (event instanceof IContainerDisconnectedEvent) {
                System.out.println("Client id=" + ((IContainerDisconnectedEvent)event).getTargetID() + " disconnected.");
            } else if (event instanceof IContainerEjectedEvent) {
                System.out.println("Client id=" + ((IContainerEjectedEvent)event).getTargetID() + " ejected.");
            }
        }
    }

    static class SysOutConnectHandlerPolicy
    implements IConnectHandlerPolicy {
        SysOutConnectHandlerPolicy() {
        }

        public PermissionCollection checkConnect(Object addr, ID fromID, ID targetID, String targetGroup, Object joinData) throws Exception {
            System.out.println("Client Connect Addr=" + addr + ";ID=" + fromID + ";Group=" + targetGroup);
            return null;
        }

        public void refresh() {
        }
    }
}

