/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeoutCompletableFuture<T>
extends CompletableFuture<T> {
    @Generated
    private static final Logger log;
    private static final Method orTimeoutMethod;

    TimeoutCompletableFuture() {
    }

    public CompletableFuture<T> compatTimeout(long timeout, TimeUnit unit) {
        return TimeoutCompletableFuture.compatTimeout(this, timeout, unit);
    }

    public static <T> CompletableFuture<T> compatTimeout(CompletableFuture<T> f, long timeout, TimeUnit unit) {
        if (orTimeoutMethod == null) {
            return TimeoutCompletableFuture.orTimeout(f, timeout, unit);
        }
        try {
            return (CompletableFuture)orTimeoutMethod.invoke(f, new Object[]{timeout, unit});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return TimeoutCompletableFuture.orTimeout(f, timeout, unit);
        }
    }

    private static <T> CompletableFuture<T> orTimeout(CompletableFuture<T> f, long timeout, TimeUnit unit) {
        ScheduledFuture<?> sf = TimeoutScheduler.executor.schedule(() -> {
            if (!f.isDone()) {
                f.completeExceptionally(new TimeoutException());
            }
        }, timeout, unit);
        f.whenComplete((T result, U ex) -> {
            if (ex == null && !sf.isDone()) {
                sf.cancel(false);
            }
        });
        return f;
    }

    static {
        Method localOrTimeoutMethod;
        log = LoggerFactory.getLogger(TimeoutCompletableFuture.class);
        if (!System.getProperty("java.version").startsWith("1.")) {
            try {
                localOrTimeoutMethod = CompletableFuture.class.getMethod("orTimeout", Long.TYPE, TimeUnit.class);
            }
            catch (NoSuchMethodException e) {
                localOrTimeoutMethod = null;
                log.warn("CompletableFuture.orTimeout method not found in Java 9+, using custom implementation", (Throwable)e);
            }
        } else {
            localOrTimeoutMethod = null;
        }
        orTimeoutMethod = localOrTimeoutMethod;
    }

    private static final class TimeoutScheduler {
        private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("dnsjava AsyncSemaphoreTimeoutScheduler");
            return t;
        });

        private TimeoutScheduler() {
        }

        static {
            executor.setRemoveOnCancelPolicy(true);
        }
    }
}

