/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.model.resource;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.ui.model.IHost;
import org.eclipse.ecf.discovery.ui.model.INetwork;
import org.eclipse.ecf.discovery.ui.model.IServiceID;
import org.eclipse.ecf.discovery.ui.model.IServiceTypeID;
import org.eclipse.ecf.discovery.ui.model.ModelFactory;
import org.eclipse.ecf.discovery.ui.model.ModelPlugin;
import org.eclipse.ecf.discovery.ui.model.resource.Messages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public class ServiceResource
extends ResourceImpl
implements Resource {
    public ServiceResource(URI uri) {
        super(uri);
    }

    public synchronized void load(Map options) throws IOException {
        if (!this.isLoaded) {
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                INetwork network = ModelFactory.eINSTANCE.createINetwork();
                this.getContents().add((Object)network);
                this.setModified(true);
                Job job = new Job("ServiceDiscoveryListener"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ServiceDiscoveryListener sdl = new ServiceDiscoveryListener();
                        sdl.connect();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            finally {
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
            }
        }
    }

    private class ServiceDiscoveryListener
    implements IServiceListener {
        private volatile ILock lock;
        public static final String DISCOVERY_CONTAINER = "ecf.singleton.discovery";
        private IContainer container;
        private IDiscoveryLocator discovery;
        private Comparator aComparator = new ECFServiceInfoComparator();

        private ServiceDiscoveryListener() {
            IJobManager jobManager = Job.getJobManager();
            this.lock = jobManager.newLock();
        }

        public void connect() {
            try {
                try {
                    this.lock.acquire();
                    this.container = ContainerFactory.getDefault().createContainer(DISCOVERY_CONTAINER, new Object[]{"ecf.discovery.composite.locator"});
                    this.discovery = (IDiscoveryLocator)this.container.getAdapter(IDiscoveryLocator.class);
                    if (this.discovery != null) {
                        this.discovery.addServiceListener((IServiceListener)this);
                        this.container.connect(null, null);
                        IServiceInfo[] services = this.discovery.getServices();
                        int i = 0;
                        while (i < services.length) {
                            this.serviceDiscovered(services[i]);
                            Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"connect", (String)("serviceResolved: " + services[i].toString()));
                            ++i;
                        }
                    } else {
                        ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.model", Messages.ServiceResource_NO_DISCOVERY_CONTAINER_AVAILABLE));
                    }
                }
                catch (ContainerCreateException e1) {
                    this.container = null;
                    this.discovery = null;
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.model", Messages.ServiceResource_NO_DISCOVERY_CONTAINER_AVAILABLE, (Throwable)e1));
                    this.lock.release();
                    return;
                }
                catch (ContainerConnectException e) {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.discovery.model", e.getMessage(), (Throwable)e));
                    this.lock.release();
                }
            }
            finally {
                this.lock.release();
            }
        }

        private void createEMFIServiceInfo(IServiceInfo ecfServiceInfo, org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo) {
            emfIServiceInfo.setEcfServiceInfo(ecfServiceInfo);
            emfIServiceInfo.setEcfName(ecfServiceInfo.getServiceID().getName());
            emfIServiceInfo.setEcfLocation(ecfServiceInfo.getLocation());
            emfIServiceInfo.setEcfPriority(ecfServiceInfo.getPriority());
            emfIServiceInfo.setEcfWeight(ecfServiceInfo.getWeight());
            org.eclipse.ecf.discovery.identity.IServiceID ecfServiceID = ecfServiceInfo.getServiceID();
            IServiceID emfIServiceID = ModelFactory.eINSTANCE.createIServiceID();
            emfIServiceID.setEcfServiceID(ecfServiceID);
            emfIServiceID.setEcfServiceName(ecfServiceID.getServiceName());
            emfIServiceInfo.setServiceID(emfIServiceID);
            org.eclipse.ecf.discovery.identity.IServiceTypeID ecfServiceTypeID = ecfServiceID.getServiceTypeID();
            IServiceTypeID emfIServiceTypeID = ModelFactory.eINSTANCE.createIServiceTypeID();
            emfIServiceTypeID.setEcfNamingAuthority(ecfServiceTypeID.getNamingAuthority());
            emfIServiceTypeID.setEcfServiceName(ecfServiceTypeID.getName());
            emfIServiceTypeID.setEcfServiceTypeID(ecfServiceTypeID);
            emfIServiceTypeID.getEcfScopes().addAll(Arrays.asList(ecfServiceTypeID.getScopes()));
            emfIServiceTypeID.getEcfServices().addAll(Arrays.asList(ecfServiceTypeID.getServices()));
            emfIServiceTypeID.getEcfProtocols().addAll(Arrays.asList(ecfServiceTypeID.getProtocols()));
            emfIServiceID.setServiceTypeID(emfIServiceTypeID);
        }

        private IHost getIHost(InetAddress anAddress) {
            IHost host = ModelFactory.eINSTANCE.createIHost();
            host.setAddress(anAddress);
            host.setName(anAddress.getCanonicalHostName());
            return host;
        }

        private org.eclipse.ecf.discovery.ui.model.IServiceInfo getIServiceInfo(IServiceInfo ecfServiceInfo) {
            Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", ServiceResource.class, (String)"getIServiceInfo", (Object)ecfServiceInfo);
            URI anUri = null;
            try {
                anUri = this.convertToURI(ecfServiceInfo);
                org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = (org.eclipse.ecf.discovery.ui.model.IServiceInfo)ServiceResource.this.resourceSet.getEObject(anUri, true);
                this.createEMFIServiceInfo(ecfServiceInfo, emfIServiceInfo);
                return emfIServiceInfo;
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MalformedURLException) {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.discovery.model", NLS.bind((String)Messages.ServiceResource_NoEMFServiceModel, (Object)anUri)));
                } else {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.discovery.model", e.getMessage()));
                }
                org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = ModelFactory.eINSTANCE.createIServiceInfo();
                this.createEMFIServiceInfo(ecfServiceInfo, emfIServiceInfo);
                return emfIServiceInfo;
            }
        }

        private URI convertToURI(IServiceInfo anIServiceInfo) {
            String name = anIServiceInfo.getServiceID().getServiceTypeID().getName().substring(1);
            name = StringUtils.replaceAll((String)name, (String)"._", (String)"/");
            name = StringUtils.replaceFirst((String)name, (String)".", (String)"/");
            name = "ecf://" + name;
            URIConverterImpl uriConverter = new URIConverterImpl();
            URI uri = uriConverter.normalize(URI.createURI((String)name));
            java.net.URI location = anIServiceInfo.getLocation();
            String authority = location.getAuthority();
            uri = URI.createHierarchicalURI((String)uri.scheme(), (String)authority, (String)uri.device(), (String[])uri.segments(), (String)location.getQuery(), (String)location.getFragment());
            return uri;
        }

        public void disconnect() {
            this.container.dispose();
        }

        private IHost findIHost(InetAddress anAddress) {
            INetwork network = (INetwork)ServiceResource.this.getContents().get(0);
            for (IHost host : network.getHosts()) {
                if (!host.getAddress().equals(anAddress)) continue;
                return host;
            }
            return null;
        }

        private org.eclipse.ecf.discovery.ui.model.IServiceInfo findIServiceInfo(IServiceInfo ecfServiceInfo) {
            IHost host = this.findIHost(this.getInetAddress(ecfServiceInfo.getLocation()));
            if (host != null) {
                for (org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo : host.getServices()) {
                    if (this.aComparator.compare(ecfServiceInfo, emfIServiceInfo.getEcfServiceInfo()) != 0) continue;
                    return emfIServiceInfo;
                }
            }
            return null;
        }

        public void serviceUndiscovered(IServiceEvent ecfEvent) {
            try {
                try {
                    this.lock.acquire();
                    Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", ServiceResource.class, (String)"serviceUndiscovered", (Object)ecfEvent);
                    IServiceInfo ecfServiceInfo = ecfEvent.getServiceInfo();
                    org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = this.findIServiceInfo(ecfServiceInfo);
                    Assert.isNotNull((Object)emfIServiceInfo);
                    EcoreUtil.remove((EObject)emfIServiceInfo);
                    HashSet<Resource> resources = new HashSet<Resource>();
                    TreeIterator iter = EcoreUtil.getAllContents((EObject)emfIServiceInfo, (boolean)false);
                    while (iter.hasNext()) {
                        resources.add(((EObject)iter.next()).eResource());
                    }
                    ServiceResource.this.getResourceSet().getResources().removeAll(resources);
                    Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"serviceUndiscovered", (String)("Removed service " + emfIServiceInfo));
                    IHost host = this.findIHost(this.getInetAddress(ecfServiceInfo.getLocation()));
                    if (host != null && host.getServices().size() < 1) {
                        EcoreUtil.remove((EObject)host);
                        Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"serviceUndiscovered", (String)("Removed host " + host));
                    }
                    Trace.exiting((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/exiting", ServiceResource.class, (String)"serviceUndiscovered", (Object)ecfEvent);
                }
                catch (AssertionFailedException e) {
                    Trace.catching((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"serviceUndiscovered", (Throwable)e);
                    this.lock.release();
                }
            }
            finally {
                this.lock.release();
            }
        }

        public void serviceDiscovered(IServiceEvent ecfEvent) {
            try {
                this.lock.acquire();
                this.serviceDiscovered(ecfEvent.getServiceInfo());
            }
            finally {
                this.lock.release();
            }
        }

        private void serviceDiscovered(IServiceInfo ecfServiceInfo) {
            Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", ServiceResource.class, (String)"serviceResolved", (Object)ecfServiceInfo);
            String hostname = ecfServiceInfo.getLocation().getHost();
            if (hostname != null && this.findIServiceInfo(ecfServiceInfo) == null) {
                org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = this.getIServiceInfo(ecfServiceInfo);
                Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"serviceResolved", (String)("Service created " + emfIServiceInfo));
                InetAddress inetAddress = this.getInetAddress(ecfServiceInfo.getLocation());
                if (inetAddress == null) {
                    return;
                }
                IHost host = this.findIHost(inetAddress);
                if (host == null) {
                    host = this.getIHost(inetAddress);
                    INetwork network = (INetwork)ServiceResource.this.getContents().get(0);
                    network.getHosts().add((Object)host);
                    Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", ServiceResource.class, (String)"serviceResolved", (String)("Host created " + emfIServiceInfo));
                }
                host.getServices().add((Object)emfIServiceInfo);
            }
            Trace.exiting((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/exiting", ServiceResource.class, (String)"serviceResolved", (Object)ecfServiceInfo);
        }

        private InetAddress getInetAddress(java.net.URI anURI) {
            String host = anURI.getHost();
            if (host != null) {
                try {
                    return InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    Trace.catching((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/catching", ServiceResource.class, (String)"getInetAddress", (Throwable)e);
                }
            }
            return null;
        }

        public boolean triggerDiscovery() {
            return false;
        }

        private class ECFServiceInfoComparator
        implements Comparator {
            private ECFServiceInfoComparator() {
            }

            public int compare(Object anObj1, Object anObj2) {
                org.eclipse.ecf.discovery.identity.IServiceID sId2;
                if (anObj1 == anObj2) {
                    return 0;
                }
                IServiceInfo si1 = (IServiceInfo)anObj1;
                IServiceInfo si2 = (IServiceInfo)anObj2;
                org.eclipse.ecf.discovery.identity.IServiceID sId1 = si1.getServiceID();
                if (sId1.equals((Object)(sId2 = si2.getServiceID()))) {
                    return 0;
                }
                return -1;
            }
        }
    }
}

