/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.retrieve;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.InvalidFileRangeSpecificationException;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.retrieve.HttpHelper;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;
import org.eclipse.osgi.util.NLS;

public class UrlConnectionRetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    private static final String USERNAME_PREFIX = Messages.UrlConnectionRetrieveFileTransfer_USERNAME_PROMPT;
    private static final int HTTP_RANGE_RESPONSE = 206;
    private static final int OK_RESPONSE_CODE = 200;
    private static final String JRE_CONNECT_TIMEOUT_PROPERTY = "sun.net.client.defaultConnectTimeout";
    private static final String DEFAULT_CONNECT_TIMEOUT = System.getProperty("org.eclipse.ecf.provider.filetransfer.retrieve.connectTimeout", "15000");
    private static final String JRE_READ_TIMEOUT_PROPERTY = "sun.net.client.defaultReadTimeout";
    protected URLConnection urlConnection;
    protected int httpVersion = 1;
    protected int responseCode = -1;
    private String remoteFileName;
    protected String responseMessage = null;
    private JREProxyHelper proxyHelper = new JREProxyHelper();
    protected String username = null;
    protected String password = null;
    private static final String ACCEPT_ENCODING = "Accept-encoding";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_ENCODING_ACCEPTED = "gzip";

    @Override
    public String getRemoteFileName() {
        return this.remoteFileName;
    }

    protected void connect() throws IOException {
        IURLConnectionModifier connectionModifier;
        this.setupTimeouts();
        this.urlConnection = this.getRemoteFileURL().openConnection();
        if (this.getRemoteFileURL().getProtocol().equalsIgnoreCase("jar")) {
            this.urlConnection.setUseCaches(false);
        }
        if ((connectionModifier = Activator.getDefault().getURLConnectionModifier()) != null) {
            connectionModifier.setSocketFactoryForConnection(this.urlConnection);
        }
    }

    protected boolean isConnected() {
        return this.urlConnection != null;
    }

    protected void setResumeRequestHeaderValues() throws IOException {
        if (this.bytesReceived <= 0L || this.fileLength <= this.bytesReceived) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_START_ERROR);
        }
        this.setRangeHeader("bytes=" + this.bytesReceived + "-");
        int maxAge = Integer.getInteger("org.eclipse.ecf.http.cache.max-age", 0);
        if (maxAge == 0) {
            this.urlConnection.setRequestProperty("Cache-Control", "max-age=0");
        } else if (maxAge > 0) {
            this.urlConnection.setRequestProperty("Cache-Control", "max-age=" + maxAge);
        }
        this.setRequestHeaderValuesFromOptions();
    }

    private void setRequestHeaderValuesFromOptions() {
        Object o;
        Map localOptions = this.getOptions();
        if (localOptions != null && (o = localOptions.get(IRetrieveFileTransferOptions.REQUEST_HEADERS)) != null && o instanceof Map) {
            Map requestHeaders = (Map)o;
            for (Object n : requestHeaders.keySet()) {
                Object v = requestHeaders.get(n);
                if (n == null || !(n instanceof String) || v == null || !(v instanceof String)) continue;
                this.urlConnection.addRequestProperty((String)n, (String)v);
            }
        }
    }

    protected void setRequestHeaderValues() throws InvalidFileRangeSpecificationException {
        IFileRangeSpecification rangeSpec = this.getFileRangeSpecification();
        if (rangeSpec != null && this.isHTTP()) {
            long startPosition = rangeSpec.getStartPosition();
            long endPosition = rangeSpec.getEndPosition();
            if (startPosition < 0L) {
                throw new InvalidFileRangeSpecificationException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_START_POSITION_LESS_THAN_ZERO, rangeSpec);
            }
            if (endPosition != -1L && endPosition <= startPosition) {
                throw new InvalidFileRangeSpecificationException(Messages.UrlConnectionRetrieveFileTransfer_RESUME_ERROR_END_POSITION_LESS_THAN_START, rangeSpec);
            }
            this.setRangeHeader("bytes=" + startPosition + "-" + (endPosition == -1L ? "" : "" + endPosition));
        }
        this.urlConnection.setRequestProperty("Connection", "close");
        int maxAge = Integer.getInteger("org.eclipse.ecf.http.cache.max-age", 0);
        if (maxAge == 0) {
            this.urlConnection.setRequestProperty("Cache-Control", "max-age=0");
        } else if (maxAge > 0) {
            this.urlConnection.setRequestProperty("Cache-Control", "max-age=" + maxAge);
        }
        this.setRequestHeaderValuesFromOptions();
    }

    private void setRangeHeader(String value) {
        this.urlConnection.setRequestProperty("Range", value);
    }

    public int getResponseCode() {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        if (this.isHTTP()) {
            int last;
            String response = this.urlConnection.getHeaderField(0);
            if (response == null) {
                this.responseCode = -1;
                this.httpVersion = 1;
                return this.responseCode;
            }
            if (!response.startsWith("HTTP/")) {
                return -1;
            }
            int mark = (response = response.trim()).indexOf(" ") + 1;
            if (mark == 0) {
                return -1;
            }
            if (response.charAt(mark - 2) != '1') {
                this.httpVersion = 0;
            }
            if ((last = mark + 3) > response.length()) {
                last = response.length();
            }
            this.responseCode = Integer.parseInt(response.substring(mark, last));
            if (last + 1 <= response.length()) {
                this.responseMessage = response.substring(last + 1);
            }
        } else {
            this.responseCode = 200;
            this.responseMessage = "OK";
        }
        return this.responseCode;
    }

    private boolean isHTTP() {
        String protocol = this.getRemoteFileURL().getProtocol();
        return protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https");
    }

    private boolean isHTTP11() {
        return this.isHTTP() && this.httpVersion >= 1;
    }

    protected void getResponseHeaderValues() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectException(Messages.UrlConnectionRetrieveFileTransfer_CONNECT_EXCEPTION_NOT_CONNECTED);
        }
        if (this.getResponseCode() == -1) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_INVALID_SERVER_RESPONSE);
        }
        this.setLastModifiedTime(this.urlConnection.getLastModified());
        this.setFileLength(this.urlConnection.getContentLength());
        String contentDispositionValue = this.urlConnection.getHeaderField("Content-Disposition");
        if (contentDispositionValue != null) {
            this.remoteFileName = HttpHelper.getRemoteFileNameFromContentDispositionHeader(contentDispositionValue);
        }
        if (this.remoteFileName == null) {
            IPath path;
            String pathStr = this.urlConnection.getURL().getPath();
            if (pathStr != null && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 0) {
                this.remoteFileName = path.lastSegment();
            }
            if (this.remoteFileName == null) {
                this.remoteFileName = super.getRemoteFileName();
            }
        }
    }

    protected void getResumeResponseHeaderValues() throws IOException {
        if (!this.isConnected()) {
            throw new ConnectException(Messages.UrlConnectionRetrieveFileTransfer_CONNECT_EXCEPTION_NOT_CONNECTED);
        }
        if (this.getResponseCode() != 206) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_INVALID_SERVER_RESPONSE_TO_PARTIAL_RANGE_REQUEST);
        }
        if (this.lastModifiedTime != this.urlConnection.getLastModified()) {
            throw new IOException(Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_FILE_MODIFIED_SINCE_LAST_ACCESS);
        }
    }

    @Override
    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    protected void setupAuthentication() throws IOException, UnsupportedCallbackException {
        if (this.connectContext == null) {
            return;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        Object o = passwordCallback.getObject();
        if (!(o instanceof String)) {
            throw new UnsupportedCallbackException((Callback)passwordCallback, Messages.UrlConnectionRetrieveFileTransfer_UnsupportedCallbackException);
        }
        this.password = (String)passwordCallback.getObject();
        Authenticator.setDefault(new UrlConnectionAuthenticator());
    }

    @Override
    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        super.setConnectContextForAuthentication(connectContext);
        this.username = null;
        this.password = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void openStreams() throws IncomingFileTransferException {
        int code = -1;
        try {
            this.setupAuthentication();
            this.connect();
            this.setRequestHeaderValues();
            this.setCompressionRequestHeader();
            this.setInputStream(this.getDecompressedStream());
            code = this.getResponseCode();
            this.responseHeaders = this.getResponseHeaders();
            if (!this.isHTTP()) {
                this.fireReceiveStartEvent();
                return;
            }
            if (code == 206 || code == 200) {
                this.fireReceiveStartEvent();
                return;
            }
            if (code == 404) {
                throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)this.getRemoteFileURL().toString()), code, this.responseHeaders);
            }
            if (code == 401) {
                throw new IncomingFileTransferException("Unauthorized", code, this.responseHeaders);
            }
            if (code == 403) {
                throw new IncomingFileTransferException("Forbidden", code, this.responseHeaders);
            }
            if (code != 407) throw new IncomingFileTransferException(NLS.bind((String)"General connection error with response code={0}", (Object)code), code, this.responseHeaders);
            throw new IncomingFileTransferException("Proxy authentication required", code, this.responseHeaders);
        }
        catch (FileNotFoundException e) {
            throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)this.getRemoteFileURL().toString()), 404);
        }
        catch (Exception e) {
            IncomingFileTransferException except = e instanceof IncomingFileTransferException ? (IncomingFileTransferException)e : new IncomingFileTransferException(NLS.bind((String)Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)this.getRemoteFileURL().toString()), (Throwable)e, code, this.responseHeaders);
            this.hardClose();
            throw except;
        }
    }

    private Map getResponseHeaders() {
        if (this.responseHeaders != null) {
            return this.responseHeaders;
        }
        if (this.urlConnection == null) {
            return null;
        }
        Map<String, List<String>> headerFields = this.urlConnection.getHeaderFields();
        if (headerFields == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String name : headerFields.keySet()) {
            List<String> listValue = headerFields.get(name);
            String val = null;
            if (listValue != null && listValue.size() > 0) {
                String string = val = listValue.size() > 1 ? listValue.get(listValue.size() - 1) : listValue.get(0);
            }
            if (name == null || val == null) continue;
            result.put(name, val);
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    protected void hardClose() {
        super.hardClose();
        this.urlConnection = null;
        this.responseCode = -1;
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    @Override
    protected boolean doPause() {
        if (this.isPaused() || !this.isConnected() || this.isDone()) {
            return false;
        }
        this.paused = true;
        return this.paused;
    }

    @Override
    protected boolean doResume() {
        if (!this.isPaused() || this.isConnected()) {
            return false;
        }
        return this.openStreamsForResume();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.equals(IFileTransferPausable.class) && this.isHTTP11()) {
            return adapter.cast(this);
        }
        return super.getAdapter(adapter);
    }

    protected String getConnectTimeout() {
        String result = DEFAULT_CONNECT_TIMEOUT;
        Map localOptions = this.getOptions();
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.CONNECT_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = ((Integer)o).toString();
                } else if (o instanceof String) {
                    result = (String)o;
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient.retrieve.connectTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = ((Integer)o).toString();
                } else if (o instanceof String) {
                    result = (String)o;
                }
            }
        }
        return result;
    }

    private void setupTimeouts() {
        String existingTimeout = System.getProperty(JRE_CONNECT_TIMEOUT_PROPERTY);
        if (existingTimeout == null) {
            System.setProperty(JRE_CONNECT_TIMEOUT_PROPERTY, this.getConnectTimeout());
        }
        if ((existingTimeout = System.getProperty(JRE_READ_TIMEOUT_PROPERTY)) == null) {
            System.setProperty(JRE_READ_TIMEOUT_PROPERTY, "" + this.getSocketReadTimeout());
        }
    }

    private boolean openStreamsForResume() {
        int code;
        block7: {
            URL theURL = this.getRemoteFileURL();
            code = -1;
            try {
                this.remoteFileURL = new URL(theURL.toString());
                this.setupAuthentication();
                this.connect();
                this.setResumeRequestHeaderValues();
                this.setInputStream(this.urlConnection.getInputStream());
                code = this.getResponseCode();
                this.responseHeaders = this.getResponseHeaders();
                if (code != 206 && code != 200) break block7;
                this.getResumeResponseHeaderValues();
                this.paused = false;
                this.fireReceiveResumedEvent();
                return true;
            }
            catch (Exception e) {
                this.exception = e instanceof IncomingFileTransferException ? e : new IncomingFileTransferException(NLS.bind((String)Messages.UrlConnectionRetrieveFileTransfer_EXCEPTION_COULD_NOT_CONNECT, (Object)this.getRemoteFileURL().toString()), (Throwable)e, code, this.responseHeaders);
                this.done = true;
                this.hardClose();
                this.fireTransferReceiveDoneEvent();
                return false;
            }
        }
        if (code == 404) {
            throw new IncomingFileTransferException(NLS.bind((String)"File not found: {0}", (Object)this.getRemoteFileURL().toString()), code, this.responseHeaders);
        }
        if (code == 401) {
            throw new IncomingFileTransferException("Unauthorized", code, this.responseHeaders);
        }
        if (code == 403) {
            throw new IncomingFileTransferException("Forbidden", code, this.responseHeaders);
        }
        if (code == 407) {
            throw new IncomingFileTransferException("Proxy authentication required", code, this.responseHeaders);
        }
        throw new IncomingFileTransferException(NLS.bind((String)"General connection error with response code={0}", (Object)code), code, this.responseHeaders);
    }

    private void setCompressionRequestHeader() {
        if (this.getFileRangeSpecification() == null && !this.targetHasGzSuffix(super.getRemoteFileName())) {
            this.urlConnection.setRequestProperty(ACCEPT_ENCODING, "gzip");
        }
    }

    private Compression getCompressionResponseHeader() {
        String encoding = this.urlConnection.getContentEncoding();
        if (encoding == null) {
            return Compression.NONE;
        }
        if (encoding.equalsIgnoreCase("gzip") && !this.targetHasGzSuffix(this.remoteFileName)) {
            return Compression.GZIP;
        }
        return Compression.NONE;
    }

    private InputStream getDecompressedStream() throws IOException {
        InputStream input = this.urlConnection.getInputStream();
        this.getResponseHeaderValues();
        Compression type = this.getCompressionResponseHeader();
        if (Compression.GZIP == type) {
            return new GZIPInputStream(input);
        }
        return input;
    }

    private static class Compression {
        private String type;
        static Compression NONE = new Compression("none");
        static Compression GZIP = new Compression("gzip");

        private Compression(String i) {
            this.type = i;
        }

        public String toString() {
            return this.type;
        }
    }

    class UrlConnectionAuthenticator
    extends Authenticator {
        UrlConnectionAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(UrlConnectionRetrieveFileTransfer.this.username, UrlConnectionRetrieveFileTransfer.this.password.toCharArray());
        }
    }
}

