/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.roster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.RosterItem;

public class RosterGroup
extends RosterItem
implements IRosterGroup {
    protected List entries = Collections.synchronizedList(new ArrayList());

    public RosterGroup(IRosterItem parent, String name, Collection existingEntries) {
        super(parent, name);
        if (existingEntries != null) {
            this.addAll(existingEntries);
        }
    }

    public RosterGroup(IRosterItem parent, String name) {
        this(parent, name, null);
    }

    public boolean add(IRosterItem item) {
        if (item == null) {
            return false;
        }
        return this.entries.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAll(Collection existingEntries) {
        if (existingEntries == null) {
            return;
        }
        List list = this.entries;
        synchronized (list) {
            Iterator i = existingEntries.iterator();
            while (i.hasNext()) {
                this.add((IRosterEntry)i.next());
            }
        }
    }

    public Collection getEntries() {
        return this.entries;
    }

    public boolean remove(IRosterItem item) {
        return this.entries.remove(item);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RosterGroup[");
        sb.append("name=").append(this.name).append(";");
        sb.append("entries=").append(this.entries).append(";");
        sb.append("]");
        return sb.toString();
    }
}

