/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.bittorrent.internal.torrent;

import java.util.Vector;
import org.eclipse.ecf.protocol.bittorrent.internal.torrent.Block;

public class PieceState {
    private final Vector blocks;
    private final int number;

    public static PieceState[] createStates(int pieces) {
        PieceState[] statuses = new PieceState[pieces];
        int i = 0;
        while (i < statuses.length) {
            statuses[i] = new PieceState(i);
            ++i;
        }
        return statuses;
    }

    private PieceState(int number) {
        this.number = number;
        this.blocks = new Vector();
    }

    private void updateState() {
        int i = 0;
        while (i < this.blocks.size()) {
            Block block1 = (Block)this.blocks.get(i);
            int j = i + 1;
            while (j < this.blocks.size()) {
                Block block2 = (Block)this.blocks.get(j);
                if (block1.isConnectedToStart(block2)) {
                    block1.prepend(block2);
                    this.blocks.remove(block2);
                    --i;
                    break;
                }
                if (block1.isConnectedToEnd(block2)) {
                    block1.append(block2);
                    this.blocks.remove(block2);
                    --i;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    synchronized void addDownloadedBlock(int index, int blockLength) {
        int i = 0;
        while (i < this.blocks.size()) {
            Block b = (Block)this.blocks.get(i);
            if (b.isConnectedToStart(index, blockLength)) {
                b.prepend(blockLength);
                this.updateState();
                return;
            }
            if (b.isConnectedToEnd(index)) {
                b.append(blockLength);
                this.updateState();
                return;
            }
            ++i;
        }
        this.blocks.add(new Block(index, blockLength));
    }

    Vector getBlocks() {
        return this.blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAsComplete(int pieceLength) {
        Vector vector = this.blocks;
        synchronized (vector) {
            this.blocks.clear();
            this.blocks.add(new Block(0, pieceLength));
        }
    }

    void reset() {
        this.blocks.clear();
    }

    public void parse(String information) {
        String[] split = information.split(":", 2);
        if (split.length != 1) {
            split = split[1].split(":");
            int i = 0;
            while (i < split.length) {
                String[] blockInfo = split[i].split("-");
                int index = Integer.parseInt(blockInfo[0]);
                int blockLength = Integer.parseInt(blockInfo[1]) - index;
                this.addDownloadedBlock(index, blockLength);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buffer;
        StringBuffer stringBuffer = buffer = new StringBuffer(Integer.toString(this.number));
        synchronized (stringBuffer) {
            buffer.append(":");
            int i = 0;
            while (i < this.blocks.size()) {
                buffer.append(this.blocks.get(i));
                buffer.append(":");
                ++i;
            }
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

