/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.provider.generic.TCPServerSOContainer;

public abstract class AbstractGenericClientApplication {
    protected String connectTarget;
    protected ISharedObjectContainer clientContainer;
    protected int waitTime = 40000;
    protected String clientId = null;
    protected String password = null;

    protected abstract ISharedObjectContainer createContainer() throws ContainerCreateException;

    protected void processArguments(String[] args) {
        this.connectTarget = TCPServerSOContainer.getDefaultServerURL();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-connectTarget")) {
                this.connectTarget = args[i + 1];
                ++i;
            }
            if (args[i].equals("-waitTime")) {
                this.waitTime = Integer.parseInt(args[i + 1]);
                ++i;
            }
            if (args[i].equals("-clientId")) {
                this.clientId = args[i + 1];
            }
            if (args[i].equals("-connectPassword")) {
                this.password = args[i + 1];
            }
            ++i;
        }
    }

    protected void initialize() throws ContainerCreateException {
        this.clientContainer = this.createContainer();
    }

    protected void connect() throws ContainerConnectException {
        this.clientContainer.connect(IDFactory.getDefault().createStringID(this.connectTarget), null);
    }

    protected void dispose() {
        if (this.clientContainer != null) {
            this.clientContainer.dispose();
            this.clientContainer = null;
        }
    }
}

