/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import java.util.ArrayList;
import java.util.Collection;

public final class StringUtils {
    private StringUtils() {
    }

    public static String[] stringToArray(String data, String delim) {
        int nextDelimiter;
        if (data == null) {
            return new String[0];
        }
        ArrayList<String> tokens = new ArrayList<String>(data.length() / 10);
        int pointer = 0;
        int quotePointer = 0;
        int tokenStart = 0;
        while ((nextDelimiter = data.indexOf(delim, pointer)) > -1) {
            int closingQuote;
            int openingQuote = data.indexOf("\"", quotePointer);
            if (openingQuote > (closingQuote = data.indexOf("\"", openingQuote + 1))) {
                throw new IllegalArgumentException("Missing closing quotation mark.");
            }
            if (openingQuote > -1 && openingQuote < nextDelimiter && closingQuote < nextDelimiter) {
                quotePointer = ++closingQuote;
                continue;
            }
            if (openingQuote < nextDelimiter && nextDelimiter < closingQuote) {
                pointer = ++closingQuote;
                continue;
            }
            tokens.add(data.substring(tokenStart, nextDelimiter).trim());
            quotePointer = pointer = ++nextDelimiter;
            tokenStart = pointer;
        }
        tokens.add(data.substring(tokenStart).trim());
        return tokens.toArray(new String[tokens.size()]);
    }

    public static Collection rightDifference(Collection left, Collection right) {
        ArrayList result = new ArrayList(right);
        for (String f1 : right) {
            for (String f2 : left) {
                if (f2.endsWith("*")) {
                    if (!f1.startsWith(f2 = f2.substring(0, f2.length() - 1))) continue;
                    result.remove(f1);
                    continue;
                }
                if (!f1.equals(f2)) continue;
                result.remove(f1);
            }
        }
        return result;
    }
}

