/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.hyperlink;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.ui.IConnectWizard;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractURLHyperlink
implements IHyperlink {
    private URI uri;
    private IRegion region;
    private String typeLabel;
    private String hyperlinkText;

    protected URI getURI() {
        return this.uri;
    }

    protected void setURI(URI uri) {
        this.uri = uri;
    }

    protected IRegion getRegion() {
        return this.region;
    }

    protected void setRegion(IRegion region) {
        this.region = region;
    }

    protected void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    public AbstractURLHyperlink(IRegion region, URI uri) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)region);
        this.region = region;
        this.uri = uri;
    }

    protected abstract IContainer createContainer() throws ContainerCreateException;

    protected abstract IConnectWizard createConnectWizard();

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public String getURLString() {
        return this.uri.toString();
    }

    protected void setHyperlinkText(String hyperlinkText) {
        this.hyperlinkText = hyperlinkText;
    }

    public void open() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IContainer container = this.createContainer();
            Assert.isNotNull((Object)container);
            IConnectWizard icw = this.createConnectWizard();
            Assert.isNotNull((Object)icw);
            icw.init(workbench, container);
            WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)icw);
            dialog.open();
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.ecf.ui", 4, Messages.AbstractURIHyperlink_EXCEPTION_HYPERLINK, (Throwable)ex);
            ErrorDialog.openError(null, null, null, (IStatus)status);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }
}

