/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.pubsub.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadItem<E extends PacketExtension>
extends Item {
    private E payload;

    public PayloadItem(E payloadExt) {
        if (payloadExt == null) {
            throw new IllegalArgumentException("payload cannot be 'null'");
        }
        this.payload = payloadExt;
    }

    public PayloadItem(String itemId, E payloadExt) {
        super(itemId);
        if (payloadExt == null) {
            throw new IllegalArgumentException("payload cannot be 'null'");
        }
        this.payload = payloadExt;
    }

    public PayloadItem(String itemId, String nodeId, E payloadExt) {
        super(itemId, nodeId);
        if (payloadExt == null) {
            throw new IllegalArgumentException("payload cannot be 'null'");
        }
        this.payload = payloadExt;
    }

    public E getPayload() {
        return this.payload;
    }

    @Override
    public String toXML() {
        StringBuilder builder = new StringBuilder("<item");
        if (this.getId() != null) {
            builder.append(" id='");
            builder.append(this.getId());
            builder.append("'");
        }
        if (this.getNode() != null) {
            builder.append(" node='");
            builder.append(this.getNode());
            builder.append("'");
        }
        builder.append(">");
        builder.append(this.payload.toXML());
        builder.append("</item>");
        return builder.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " | Content [" + this.toXML() + "]";
    }
}

