/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.RemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.osgi.framework.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRSAClientService
extends AbstractClientService {
    @Override
    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        return null;
    }

    public AbstractRSAClientService(AbstractClientContainer container, RemoteServiceClientRegistration registration) {
        super(container, registration);
    }

    protected Object invokeAsync(RSARemoteCall remoteCall) throws ECFException {
        return this.callFuture(remoteCall, remoteCall.getReflectMethod().getReturnType());
    }

    protected Object invokeSync(RSARemoteCall remoteCall) throws ECFException {
        if (remoteCall.getClass().isAssignableFrom(RSARemoteCall.class)) {
            Callable<Object> c = this.getSyncCallable(remoteCall);
            if (c == null) {
                throw new ECFException("invokeSync failed on method=" + remoteCall.getMethod(), (Throwable)new NullPointerException("createSyncCallable() must not return null.  It's necessary for distribution provider to override createSyncCallable."));
            }
            try {
                return this.callSync(remoteCall, c);
            }
            catch (InterruptedException e) {
                throw new ECFException("invokeSync interrupted on method=" + remoteCall.getMethod(), (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new ECFException("invokeSync exception on method=" + remoteCall.getMethod(), e.getCause());
            }
            catch (TimeoutException e) {
                throw new ECFException("invokeSync timeout on method=" + remoteCall.getMethod(), (Throwable)e);
            }
        }
        return super.invokeSync(remoteCall);
    }

    protected RSARemoteCall createRemoteCall(Object proxy, Method method, String methodName, Object[] parameters, long timeout) {
        return new RSARemoteCall(proxy, method, methodName, parameters, timeout);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        resultObject = this.invokeObject(proxy, method, args);
        if (resultObject != null) {
            return resultObject;
        }
        try {
            if (this.isReturnAsync(proxy, method, args)) {
                if (this.isInterfaceAsync(method.getDeclaringClass()) && this.isMethodAsync(method.getName())) {
                    return this.invokeAsync(this.createRemoteCall(proxy, method, this.getAsyncInvokeMethodName(method), args, this.getDefaultTimeout()));
                }
                if (this.isOSGIAsync()) {
                    return this.invokeAsync(this.createRemoteCall(proxy, method, method.getName(), args, this.getDefaultTimeout()));
                }
            }
            ** GOTO lbl15
        }
        catch (Throwable t) {
            try {
                this.handleProxyException("Exception invoking async method on remote service proxy=" + this.getRemoteServiceID(), t);
lbl15:
                // 2 sources

                callMethod = this.getCallMethodNameForProxyInvoke(method, args);
                callParameters = this.getCallParametersForProxyInvoke(callMethod, method, args);
                callTimeout = this.getCallTimeoutForProxyInvoke(callMethod, method, args);
                return this.invokeSync(this.createRemoteCall(proxy, method, callMethod, callParameters, callTimeout));
            }
            catch (Throwable t) {
                if (t instanceof ServiceException) {
                    throw t;
                }
                throw new ServiceException("Service exception on remote service proxy rsid=" + this.getRemoteServiceID(), 5, t);
            }
        }
    }

    @Override
    protected ExecutorService getFutureExecutorService(IRemoteCall call) {
        return super.getFutureExecutorService(call);
    }

    @Override
    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        if (call instanceof RSARemoteCall) {
            this.callAsyncWithTimeout(call, this.getAsyncCallable((RSARemoteCall)call), listener);
        } else {
            super.callAsync(call, listener);
        }
    }

    @Override
    public Object callSync(IRemoteCall call) throws ECFException {
        if (call instanceof RSARemoteCall) {
            try {
                return this.getSyncCallable((RSARemoteCall)call).call();
            }
            catch (Exception e) {
                throw new ECFException("Exception calling callable for method=" + call.getMethod(), (Throwable)e);
            }
        }
        return super.callSync(call);
    }

    protected ExecutorService getExecutorService() {
        return this.getFutureExecutorService(null);
    }

    protected Callable<IRemoteCallCompleteEvent> getAsyncCallable(RSARemoteCall call) {
        throw new UnsupportedOperationException("distribution provider must override createAsyncCallable for service method=" + call.getMethod() + " class=" + call.getReflectMethod().getDeclaringClass());
    }

    protected Callable<Object> getSyncCallable(RSARemoteCall call) {
        throw new UnsupportedOperationException("distribution provider must override createAsyncCallable for service method=" + call.getMethod() + " class=" + call.getReflectMethod().getDeclaringClass());
    }

    public static class RSARemoteCall
    extends RemoteCall {
        private final Object proxy;
        private final Method reflectMethod;

        public RSARemoteCall(Object proxy, Method method, String methodName, Object[] parameters, long timeout) {
            super(methodName, parameters, timeout);
            this.reflectMethod = method;
            this.proxy = proxy;
        }

        public Method getReflectMethod() {
            return this.reflectMethod;
        }

        public Object getProxy() {
            return this.proxy;
        }
    }
}

