/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.telephony.call.ui.actions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.IExceptionHandler;
import org.eclipse.ecf.internal.telephony.call.ui.Activator;
import org.eclipse.ecf.internal.telephony.call.ui.Messages;
import org.eclipse.ecf.telephony.call.CallException;
import org.eclipse.ecf.telephony.call.CallSessionState;
import org.eclipse.ecf.telephony.call.ICallSession;
import org.eclipse.ecf.telephony.call.ICallSessionContainerAdapter;
import org.eclipse.ecf.telephony.call.ICallSessionListener;
import org.eclipse.ecf.telephony.call.events.ICallSessionEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCallAction
extends Action {
    protected ID callReceiver = null;
    protected IExceptionHandler exceptionHandler = null;
    static /* synthetic */ Class class$0;

    public AbstractCallAction() {
    }

    public AbstractCallAction(String text) {
        super(text);
    }

    public AbstractCallAction(String text, ImageDescriptor image) {
        super(text, image);
    }

    public AbstractCallAction(String text, int style) {
        super(text, style);
    }

    public void setCallExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public IExceptionHandler getCallExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setCallReceiver(ID callReceiver) {
        this.callReceiver = callReceiver;
    }

    public ID getCallReceiver() {
        return this.callReceiver;
    }

    protected ICallSessionContainerAdapter getCallContainerAdapter() {
        IContainer c = this.getContainer();
        if (c == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.telephony.call.ICallSessionContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICallSessionContainerAdapter)c.getAdapter((Class)clazz);
    }

    protected abstract IContainer getContainer();

    protected ICallSessionListener createCallSessionListener() {
        return new ICallSessionListener(){

            public void handleCallSessionEvent(ICallSessionEvent event) {
                ICallSession callSession = event.getCallSession();
                if (callSession.getState().equals((Object)CallSessionState.FAILED)) {
                    Display.getDefault().asyncExec(new Runnable(this, callSession){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ ICallSession val$callSession;
                        {
                            this.this$1 = var1_1;
                            this.val$callSession = iCallSession;
                        }

                        public void run() {
                            MessageDialog.openInformation(null, (String)Messages.CallAction_Title_Call_Failed, (String)NLS.bind((String)Messages.CallAction_Message_Call_Failed, (Object)this.val$callSession.getReceiver().getName(), (Object)this.val$callSession.getFailureReason().getReason()));
                        }
                    });
                }
            }
        };
    }

    protected ID getReceiverFromInputDialog(ICallSessionContainerAdapter adapter) throws IDCreateException {
        InputDialog id = new InputDialog(Display.getDefault().getActiveShell(), Messages.CallAction_Initiate_Call_Title, Messages.CallAction_Initiate_Call_Message, "", null);
        id.setBlockOnOpen(true);
        int res = id.open();
        String receiver = null;
        if (res == 0) {
            receiver = id.getValue();
        }
        if (receiver == null || receiver.equals("")) {
            return null;
        }
        return IDFactory.getDefault().createID(adapter.getReceiverNamespace(), receiver);
    }

    protected Map createOptions() {
        return null;
    }

    protected void makeCall() throws CallException, IDCreateException {
        ICallSessionContainerAdapter adapter = this.getCallContainerAdapter();
        if (adapter == null) {
            throw new CallException(Messages.CallAction_Exception_Container_Not_Call_API);
        }
        if (this.callReceiver == null) {
            this.callReceiver = this.getReceiverFromInputDialog(adapter);
        }
        if (this.callReceiver != null) {
            adapter.sendCallRequest(this.callReceiver, this.createCallSessionListener(), this.createOptions());
        }
    }

    public void run() {
        try {
            this.makeCall();
        }
        catch (Exception e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handleException((Throwable)e);
            }
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.telephony.call.ui", 4, Messages.CallAction_Exception_CallAction_Run, (Throwable)e));
        }
    }
}

