/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.im;

import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.presence.IIMMessage;

public interface IChatMessage
extends IIMMessage {
    public ID getThreadID();

    public String getSubject();

    public String getBody();

    public Type getType();

    public Map getProperties();

    public static class Type {
        private static final String CHAT_NAME = "chat";
        private static final String SYSTEM_NAME = "system";
        private static final String ERROR_NAME = "error";
        private final transient String name;
        public static final Type CHAT = new Type("chat");
        public static final Type SYSTEM = new Type("system");
        public static final Type ERROR = new Type("error");

        protected Type(String name) {
            this.name = name;
        }

        public static Type fromString(String itemType) {
            if (itemType == null) {
                return null;
            }
            if (itemType.equals(CHAT_NAME)) {
                return CHAT;
            }
            if (itemType.equals(SYSTEM_NAME)) {
                return SYSTEM;
            }
            if (itemType.equals(ERROR_NAME)) {
                return ERROR;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public final boolean equals(Object that) {
            return super.equals(that);
        }

        public final int hashCode() {
            return super.hashCode();
        }
    }
}

