/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare.nio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.datashare.nio.ChannelData;

final class Util {
    static final String PLUGIN_ID = "org.eclipse.ecf.provider.datashare.nio";

    Util() {
    }

    static void closeChannel(Channel channel) {
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static byte[] serialize(ID id) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(id);
        oos.flush();
        return baos.toByteArray();
    }

    static ChannelData read(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int read = channel.read(buffer);
        if (read == -1) {
            return new ChannelData(null, false);
        }
        if (read == 0) {
            return new ChannelData(null, true);
        }
        byte[] message = new byte[read];
        buffer.flip();
        buffer.get(message, 0, read);
        buffer.clear();
        read = channel.read(buffer);
        while (read > 0) {
            byte[] temp = new byte[read + message.length];
            System.arraycopy(message, 0, temp, 0, message.length);
            buffer.flip();
            buffer.get(temp, message.length, read);
            buffer.clear();
            message = temp;
            read = channel.read(buffer);
        }
        return new ChannelData(message, read == 0);
    }

    static void write(WritableByteChannel channel, ByteBuffer buffer, byte[] data) throws IOException {
        buffer.clear();
        int remaining = data.length;
        int limit = buffer.limit();
        if (remaining < limit) {
            buffer.put(data);
            buffer.flip();
            channel.write(buffer);
            buffer.clear();
            return;
        }
        int offset = 0;
        while (remaining > limit) {
            buffer.put(data, offset, limit);
            buffer.flip();
            channel.write(buffer);
            buffer.clear();
            offset += limit;
            remaining -= limit;
        }
        buffer.put(data, offset, remaining);
        buffer.flip();
        channel.write(buffer);
        buffer.clear();
    }
}

