/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.irc.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.irc.Messages;
import org.eclipse.ecf.internal.provider.irc.identity.IRCID;
import org.eclipse.osgi.util.NLS;

public class IRCNamespace
extends Namespace {
    private static final long serialVersionUID = 1005111581522377553L;
    public static final String IRC_PROTOCOL = "irc";
    public static final String IRC_SCHEME = "ecf.irc.irclib";
    public static final String IRCNAMESPACE_NAME = "ecf.irc.irclib";
    static /* synthetic */ Class class$0;

    private String getProtocolPrefix() {
        return "irc://";
    }

    private String getInitFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + ":")) {
            int index = arg.indexOf(":");
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public ID createInstance(Object[] args) throws IDCreateException {
        try {
            URI newURI;
            String uriScheme;
            String s;
            String init = this.getInitFromExternalForm(args);
            String string = s = init == null ? (String)args[0] : init;
            if (!s.startsWith(this.getProtocolPrefix())) {
                s = String.valueOf(this.getProtocolPrefix()) + s;
            }
            if ((uriScheme = (newURI = this.createURI(s)).getScheme()) == null || !uriScheme.equalsIgnoreCase(IRC_PROTOCOL)) {
                throw new IDCreateException(NLS.bind((String)Messages.IRCNamespace_EXCEPTION_INVALID_PROTOCOL, (Object)newURI, (Object)IRC_PROTOCOL));
            }
            return new IRCID(this, newURI);
        }
        catch (Exception e) {
            throw new IDCreateException(NLS.bind((String)"{0} createInstance()", (Object)this.getName()), (Throwable)e);
        }
    }

    private URI createURI(String s) throws IDCreateException, URISyntaxException {
        URI ret = null;
        String uname = s.substring(this.getProtocolPrefix().length(), s.indexOf("@"));
        int hostend = s.lastIndexOf("/");
        int hoststart = s.indexOf("@");
        if (hoststart > hostend || hostend == -1) {
            hostend = s.length();
        }
        String host = s.substring(hoststart + 1, hostend);
        int port = -1;
        int portidx = host.indexOf(":");
        if (portidx >= 0) {
            port = Integer.parseInt(host.substring(portidx + 1, host.length()));
            host = host.substring(0, portidx);
        }
        String path = s.substring(hostend, s.length());
        ret = new URI(IRC_PROTOCOL, uname, host, port, path, null, null);
        return ret;
    }

    public String getScheme() {
        return "ecf.irc.irclib";
    }

    public Class[][] getSupportedParameterTypes() {
        Class[][] classArray = new Class[1][];
        Class[] classArray2 = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz;
        classArray[0] = classArray2;
        return classArray;
    }
}

