/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rmf.reqif10.search.criteria.Criteria;
import org.eclipse.rmf.reqif10.search.edit.util.ReqIFEditSearcher;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchPage;
import org.eclipse.rmf.reqif10.search.ui.UsageSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class ReqIFSearchQuery
implements ISearchQuery {
    private String searchedText;
    private UsageSearchResult usageSearchResult;
    private Collection<Resource> resources;
    private Collection<Criteria> criterias;
    private final ReqIFSearchPage page;

    public ReqIFSearchQuery(ReqIFSearchPage page, Collection<Criteria> criterias) {
        this.page = page;
        this.criterias = criterias;
    }

    protected void initializeUsageSearchEntries() {
        if (this.usageSearchResult == null) {
            this.usageSearchResult = new UsageSearchResult(this);
        } else {
            this.usageSearchResult.getSearchEntries().clear();
        }
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.initializeUsageSearchEntries();
        this.doRun(monitor);
        return Status.OK_STATUS;
    }

    private void doRun(IProgressMonitor monitor) {
        monitor.beginTask("Searching...", -1);
        StringBuilder searchedTextBuilder = new StringBuilder();
        for (Criteria criteria : this.criterias) {
            searchedTextBuilder.append(criteria.getSerachedText()).append(" - ");
        }
        this.searchedText = searchedTextBuilder.toString();
        this.resources = this.page.getEMFResources(this.page.getEditorsURIMap());
        Map result = ReqIFEditSearcher.find((IProgressMonitor)monitor, this.resources, this.criterias, (boolean)false);
        this.usageSearchResult.getSearchEntries().clear();
        this.usageSearchResult.getSearchEntries().putAll(result);
        monitor.done();
    }

    public String getLabel() {
        return this.searchedText;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return false;
    }

    public ISearchResult getSearchResult() {
        return this.usageSearchResult;
    }
}

