/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.provider;

import java.net.URISyntaxException;
import java.util.GregorianCalendar;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.pror.testframework.AbstractItemProviderTest;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class AttributeValueTest
extends AbstractItemProviderTest {
    protected AttributeValue fixture = null;

    protected AttributeValue getFixture() {
        return this.fixture;
    }

    protected void setFixture(AttributeValue fixture) {
        this.fixture = fixture;
    }

    @Test
    public void testEnclosingSpecObjectIsNotified() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecObject specObject = (SpecObject)reqif.getCoreContent().getSpecObjects().get(0);
        specObject.getValues().add((Object)this.getFixture());
        ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)specObject).addListener(this.listener);
        ProrUtil.setTheValue((AttributeValue)this.getFixture(), (Object)this.getValueObject(), (EditingDomain)this.editingDomain);
        Assert.assertEquals((long)2L, (long)this.notifications.size());
        Assert.assertEquals((Object)specObject, (Object)((Notification)this.notifications.get(0)).getNotifier());
    }

    @Test
    public void testSetLasChangedEnclosingSpecObject() throws URISyntaxException {
        ReqIF reqif = this.getTestReqif("simple.reqif");
        SpecObject specObject = (SpecObject)reqif.getCoreContent().getSpecObjects().get(0);
        specObject.getValues().add((Object)this.getFixture());
        GregorianCalendar lastChangeBefore = specObject.getLastChange();
        ProrUtil.setTheValue((AttributeValue)this.getFixture(), (Object)this.getValueObject(), (EditingDomain)this.editingDomain);
        GregorianCalendar lastChangeAfter = specObject.getLastChange();
        Assert.assertTrue((lastChangeAfter != lastChangeBefore ? 1 : 0) != 0);
    }

    public abstract Object getValueObject();
}

