/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICellRenderer;
import org.agilemore.agilegrid.ICellRendererProvider;
import org.agilemore.agilegrid.renderers.ButtonCellRenderer;
import org.agilemore.agilegrid.renderers.HeaderCellRenderer;
import org.agilemore.agilegrid.renderers.TextCellRenderer;

public class DefaultCellRendererProvider
implements ICellRendererProvider {
    private ButtonCellRenderer headerCellRenderer;
    private TextCellRenderer textCellRenderer;
    protected AgileGrid agileGrid;

    public DefaultCellRendererProvider(AgileGrid agileGrid) {
        this.agileGrid = agileGrid;
        this.headerCellRenderer = new HeaderCellRenderer(agileGrid, 36);
        this.textCellRenderer = new TextCellRenderer(agileGrid, 144);
    }

    @Override
    public ICellRenderer getCellRenderer(int row, int col) {
        return this.textCellRenderer;
    }

    @Override
    public ICellRenderer getLeftHeadRenderer(int row) {
        return this.headerCellRenderer;
    }

    @Override
    public ICellRenderer getTopHeadRenderer(int col) {
        return this.headerCellRenderer;
    }
}

