/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.ICompositorStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;

public abstract class AbstractLayoutAdvisor
implements ILayoutAdvisor {
    protected AgileGrid agileGrid;
    ICompositorStrategy compositorStrategy;
    protected PropertyChangeSupport propertyChangeSupport;

    public AbstractLayoutAdvisor(AgileGrid agileGrid) {
        this.agileGrid = agileGrid;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    @Override
    public abstract int getColumnWidth(int var1);

    public abstract int getInitialColumnWidth(int var1);

    @Override
    public abstract int getRowHeight(int var1);

    public abstract int getInitialRowHeight(int var1);

    @Override
    public void setColumnWidth(int col, int width) {
        int oldWidth = this.getColumnWidth(col);
        if (width == oldWidth) {
            return;
        }
        this.doSetColumnWidth(col, width);
        this.firePropertyChange("columnWidth", col, oldWidth, width);
    }

    protected abstract void doSetColumnWidth(int var1, int var2);

    @Override
    public void setRowHeight(int row, int height) {
        int oldHeight = this.getRowHeight(row);
        if (height == oldHeight) {
            return;
        }
        this.doSetRowHeight(row, height);
        this.firePropertyChange("rowHeight", row, oldHeight, height);
    }

    protected abstract void doSetRowHeight(int var1, int var2);

    @Override
    public boolean isFixedCell(int row, int col) {
        return col < this.getFixedColumnCount() || row < this.getFixedRowCount();
    }

    @Override
    public Cell mergeInto(int row, int col) {
        return new Cell(this.agileGrid, row, col);
    }

    @Override
    public ICompositorStrategy getCompositorStrategy() {
        return this.compositorStrategy;
    }

    @Override
    public void setCompositorStrategy(ICompositorStrategy compositorStrategy) {
        this.compositorStrategy = compositorStrategy;
    }

    @Override
    public void setColumnCount(int columnCount) {
        int oldColumnCount = this.getColumnCount();
        if (columnCount == oldColumnCount) {
            return;
        }
        this.doSetColumnCount(columnCount);
        this.firePropertyChange("columnCount", oldColumnCount, columnCount);
    }

    protected abstract void doSetColumnCount(int var1);

    @Override
    public void setFixedColumnCount(int fixedColumnCount) {
        int oldFixedColumnCount = this.getFixedColumnCount();
        if (fixedColumnCount == oldFixedColumnCount) {
            return;
        }
        this.doSetFixedColumnCount(fixedColumnCount);
        this.firePropertyChange("fixedColumnCount", oldFixedColumnCount, fixedColumnCount);
    }

    protected abstract void doSetFixedColumnCount(int var1);

    @Override
    public void setFixedRowCount(int fixedRowCount) {
        int oldFixedRowCount = this.getFixedRowCount();
        if (fixedRowCount == oldFixedRowCount) {
            return;
        }
        this.doSetFixedRowCount(fixedRowCount);
        this.firePropertyChange("fixedRowCount", oldFixedRowCount, fixedRowCount);
    }

    protected abstract void doSetFixedRowCount(int var1);

    @Override
    public void setLeftHeaderLabel(int row, String label) {
        String oldLabel = this.getLeftHeaderLabel(row);
        if (oldLabel != label || oldLabel != null && !oldLabel.equals(label)) {
            this.doSetLeftHeaderLabel(row, label);
            this.firePropertyChange("leftHeaderLabel", row, oldLabel, label);
        }
    }

    protected abstract void doSetLeftHeaderLabel(int var1, String var2);

    @Override
    public void setLeftHeaderVisible(boolean visible) {
        boolean oldVisible = this.isLeftHeaderVisible();
        if (visible == oldVisible) {
            return;
        }
        this.doSetLeftHeaderVisible(visible);
        this.firePropertyChange("leftHeaderVisible", oldVisible, visible);
    }

    protected abstract void doSetLeftHeaderVisible(boolean var1);

    @Override
    public void setLeftHeaderWidth(int width) {
        int oldWidth = this.getLeftHeaderWidth();
        if (width == oldWidth) {
            return;
        }
        this.doSetLeftHeaderWidth(width);
        this.firePropertyChange("leftHeaderWidth", oldWidth, width);
    }

    protected abstract void doSetLeftHeaderWidth(int var1);

    @Override
    public void setRowCount(int rowCount) {
        int oldRowCount = this.getRowCount();
        if (rowCount == oldRowCount) {
            return;
        }
        this.doSetRowCount(rowCount);
        this.firePropertyChange("rowCount", oldRowCount, rowCount);
    }

    protected abstract void doSetRowCount(int var1);

    @Override
    public void setRowHeightMinimum(int minimumHeight) {
        int oldMinimumHeight = this.getRowHeightMinimum();
        if (minimumHeight == oldMinimumHeight) {
            return;
        }
        this.doSetRowHeightMinimum(minimumHeight);
        this.firePropertyChange("rowHeightMinimum", oldMinimumHeight, minimumHeight);
    }

    protected abstract void doSetRowHeightMinimum(int var1);

    @Override
    public void setRowResizable(int row, boolean resizable) {
        boolean oldResizable = this.isRowResizable(row);
        if (resizable == oldResizable) {
            return;
        }
        this.doSetRowResizable(row, resizable);
        this.firePropertyChange("rowResizable", row, oldResizable, resizable);
    }

    protected abstract void doSetRowResizable(int var1, boolean var2);

    @Override
    public void setTooltip(int row, int col, String tooltip) {
        String oldTooltip = this.getTooltip(row, col);
        if (tooltip != oldTooltip || oldTooltip != null && !oldTooltip.equals(tooltip)) {
            this.doSetTooltipAt(row, col, tooltip);
            this.firePropertyChange("tooltip", row, col, oldTooltip, tooltip);
        }
    }

    protected abstract void doSetTooltipAt(int var1, int var2, String var3);

    @Override
    public void setTopHeaderHeight(int height) {
        int oldHeight = this.getTopHeaderHeight();
        if (height == oldHeight) {
            return;
        }
        this.doSetTopHeaderHeight(height);
        this.firePropertyChange("topHeaderHeight", oldHeight, height);
    }

    protected abstract void doSetTopHeaderHeight(int var1);

    @Override
    public void setTopHeaderLabel(int col, String label) {
        String oldLabel = this.getTopHeaderLabel(col);
        if (oldLabel != label || oldLabel != null && !oldLabel.equals(label)) {
            this.doSetTopHeaderLabel(col, label);
            this.firePropertyChange("topHeaderLabel", col, oldLabel, label);
        }
    }

    protected abstract void doSetTopHeaderLabel(int var1, String var2);

    @Override
    public void setTopHeaderVisible(boolean visible) {
        boolean oldVisible = this.isTopHeaderVisible();
        if (oldVisible == visible) {
            return;
        }
        this.doSetTopHeaderVisible(visible);
        this.firePropertyChange("topHeaderVisible", oldVisible, visible);
    }

    protected abstract void doSetTopHeaderVisible(boolean var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.propertyChangeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, index, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, int rowIndex, int colIndex, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, rowIndex, colIndex, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        Integer indexObject = new Integer(index);
        HashMap<Integer, Object> oldMap = new HashMap<Integer, Object>();
        oldMap.put(indexObject, oldValue);
        HashMap<Integer, Object> newMap = new HashMap<Integer, Object>();
        newMap.put(indexObject, newValue);
        this.propertyChangeSupport.firePropertyChange(propertyName, oldMap, newMap);
    }

    public void firePropertyChange(String propertyName, int rowIndex, int colIndex, Object oldValue, Object newValue) {
        Cell cell = new Cell(this.agileGrid, rowIndex, colIndex);
        HashMap<Cell, Object> oldMap = new HashMap<Cell, Object>();
        oldMap.put(cell, oldValue);
        HashMap<Cell, Object> newMap = new HashMap<Cell, Object>();
        newMap.put(cell, newValue);
        this.propertyChangeSupport.firePropertyChange(propertyName, oldMap, newMap);
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    @Override
    public boolean hasListeners(String propertyName) {
        return this.propertyChangeSupport.hasListeners(propertyName);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

