/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.ArrayList;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.EditorActivationStrategy;
import org.agilemore.agilegrid.EditorDeactivationEvent;
import org.agilemore.agilegrid.ICellEditorListener;
import org.agilemore.agilegrid.ICellEditorProvider;
import org.agilemore.agilegrid.IEditorActivationListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class AgileGridEditor {
    private CellEditor cellEditor;
    private Cell cell;
    private EditorActivationEvent activationEvent;
    private ICellEditorProvider cellEditorProvider;
    private ICellEditorListener cellEditorListener;
    private FocusListener focusListener;
    private MouseListener mouseListener;
    private AgileGrid agileGrid;
    private TraverseListener traverseListener;
    private ArrayList<IEditorActivationListener> editorActivationListeners;
    private EditorActivationStrategy editorActivationStrategy;
    public static final int DEFAULT = 1;
    public static final int TABBING_MOVE_TO_ROW_NEIGHBOR = 2;
    public static final int TABBING_CYCLE_IN_ROW = 4;
    public static final int TABBING_VERTICAL = 8;
    public static final int TABBING_HORIZONTAL = 16;
    public static final int KEYBOARD_ACTIVATION = 32;
    private int feature;

    public AgileGridEditor(AgileGrid agileGrid, int feature) {
        this.agileGrid = agileGrid;
        this.feature = feature;
        this.editorActivationStrategy = new EditorActivationStrategy(agileGrid);
        this.cellEditorListener = new ICellEditorListener(){

            @Override
            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            @Override
            public void cancelEditor() {
                AgileGridEditor.this.cancelEditing();
            }

            @Override
            public void applyEditorValue() {
                AgileGridEditor.this.applyEditorValue();
            }
        };
        this.hookListener(this.agileGrid);
    }

    private void hookListener(AgileGrid agileGrid) {
        agileGrid.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AgileGridEditor.this.onMouseEvent(e, 3);
            }

            public void mouseDown(MouseEvent e) {
                AgileGridEditor.this.onMouseEvent(e, 2);
            }
        });
    }

    protected void onMouseEvent(MouseEvent event, int eventType) {
        if (event.button == 1) {
            Cell cell = this.agileGrid.getCell(event.x, event.y);
            if (cell == Cell.NULLCELL) {
                return;
            }
            cell = this.agileGrid.getValidCell(cell.row, cell.column);
            this.handleEditorActivationEvent(new EditorActivationEvent(cell, null, event, eventType), null);
        }
    }

    synchronized void activateCellEditor(Object hint) {
        if (this.cell == Cell.NULLCELL) {
            return;
        }
        if (this.canEdit(this.cell.row, this.cell.column)) {
            this.agileGrid.scrollToFocus(false);
            this.cellEditor = hint == null ? this.cellEditorProvider.getCellEditor(this.cell.row, this.cell.column) : this.cellEditorProvider.getCellEditor(this.cell.row, this.cell.column, hint);
            if (this.cellEditor != null) {
                this.activationEvent.cellEditor = this.cellEditor;
                if (this.editorActivationListeners != null && !this.editorActivationListeners.isEmpty()) {
                    int i = 0;
                    while (i < this.editorActivationListeners.size()) {
                        if (this.activationEvent.cancel) {
                            this.cell = null;
                            return;
                        }
                        this.editorActivationListeners.get(i).beforeEditorActivated(this.activationEvent);
                        ++i;
                    }
                }
                this.cellEditor.addCellEditorListener(this.cellEditorListener);
                this.cellEditorProvider.initializeCellEditorValue(this.cellEditor, this.cell);
                Control control = this.cellEditor.getControl();
                this.cellEditor.activate(this.activationEvent);
                if (control == null || this.cellEditor == null) {
                    return;
                }
                if (this.cellEditor.dependsOnExternalFocusListener()) {
                    if (this.focusListener == null) {
                        this.focusListener = new FocusAdapter(){

                            public void focusLost(FocusEvent e) {
                                AgileGridEditor.this.applyEditorValue();
                            }
                        };
                    }
                    control.addFocusListener(this.focusListener);
                }
                if (this.traverseListener == null) {
                    this.traverseListener = new TraverseListener(){

                        public void keyTraversed(TraverseEvent e) {
                            if ((AgileGridEditor.this.feature & 1) != 1) {
                                AgileGridEditor.this.processTraverseEvent(AgileGridEditor.this.cell, e);
                            }
                        }
                    };
                }
                control.addTraverseListener(this.traverseListener);
                if (this.editorActivationListeners != null && !this.editorActivationListeners.isEmpty()) {
                    int i = 0;
                    while (i < this.editorActivationListeners.size()) {
                        this.editorActivationListeners.get(i).afterEditorActivated(this.activationEvent);
                        ++i;
                    }
                }
            }
        } else {
            this.cell = null;
        }
    }

    synchronized void applyEditorValue() {
        if (this.cellEditor == null || this.cell == Cell.NULLCELL) {
            return;
        }
        CellEditor cellEditorTmp = this.cellEditor;
        this.cellEditor = null;
        EditorDeactivationEvent tmp = new EditorDeactivationEvent(this.cell, cellEditorTmp, true);
        if (this.editorActivationListeners != null) {
            int i = 0;
            while (i < this.editorActivationListeners.size()) {
                this.editorActivationListeners.get(i).beforeEditorDeactivated(tmp);
                ++i;
            }
        }
        this.activationEvent = null;
        this.saveEditorValue(cellEditorTmp);
        cellEditorTmp.removeListener(this.cellEditorListener);
        Control control = cellEditorTmp.getControl();
        if (control != null) {
            if (this.mouseListener != null) {
                control.removeMouseListener(this.mouseListener);
                this.mouseListener = null;
            }
            if (this.focusListener != null) {
                control.removeFocusListener(this.focusListener);
            }
            if (this.traverseListener != null) {
                control.removeTraverseListener(this.traverseListener);
            }
        }
        cellEditorTmp.deactivate();
        if (this.editorActivationListeners != null) {
            int i = 0;
            while (i < this.editorActivationListeners.size()) {
                this.editorActivationListeners.get(i).afterEditorDeactivated(tmp);
                ++i;
            }
        }
        cellEditorTmp.dispose();
        this.cell = null;
    }

    synchronized void cancelEditing() {
        if (this.cellEditor == null) {
            return;
        }
        CellEditor cellEditorTmp = this.cellEditor;
        this.cellEditor = null;
        EditorDeactivationEvent tmp = new EditorDeactivationEvent(this.cell, cellEditorTmp, false);
        if (this.editorActivationListeners != null) {
            int i = 0;
            while (i < this.editorActivationListeners.size()) {
                this.editorActivationListeners.get(i).beforeEditorDeactivated(tmp);
                ++i;
            }
        }
        cellEditorTmp.removeListener(this.cellEditorListener);
        Control control = cellEditorTmp.getControl();
        if (control != null) {
            if (this.mouseListener != null) {
                control.removeMouseListener(this.mouseListener);
                this.mouseListener = null;
            }
            if (this.focusListener != null) {
                control.removeFocusListener(this.focusListener);
            }
            if (this.traverseListener != null) {
                control.removeTraverseListener(this.traverseListener);
            }
        }
        cellEditorTmp.deactivate();
        if (this.editorActivationListeners != null) {
            int i = 0;
            while (i < this.editorActivationListeners.size()) {
                this.editorActivationListeners.get(i).afterEditorDeactivated(tmp);
                ++i;
            }
        }
        cellEditorTmp.dispose();
        this.activationEvent = null;
        this.cell = null;
    }

    void handleEditorActivationEvent(EditorActivationEvent event, Object hint) {
        if (this.editorActivationStrategy.isEditorActivationEvent(event)) {
            if (this.cellEditor != null) {
                this.applyEditorValue();
            }
            this.cell = (Cell)event.getSource();
            if (this.cell.row == -1 || this.cell.column == -1) {
                return;
            }
            this.cell = this.agileGrid.getValidCell(this.cell.row, this.cell.column);
            this.agileGrid.focusCell(this.cell);
            this.activationEvent = event;
            this.activateCellEditor(hint);
        }
    }

    void saveEditorValue(CellEditor cellEditor) {
        if (this.cellEditorProvider != null) {
            this.cellEditorProvider.saveCellEditorValue(cellEditor, this.cell);
        }
    }

    boolean isCellEditorActive() {
        return this.cellEditor != null;
    }

    void addEditorActivationListener(IEditorActivationListener listener) {
        if (this.editorActivationListeners == null) {
            this.editorActivationListeners = new ArrayList();
        }
        this.editorActivationListeners.add(listener);
    }

    void removeEditorActivationListener(IEditorActivationListener listener) {
        if (this.editorActivationListeners != null) {
            this.editorActivationListeners.remove(listener);
        }
    }

    protected void processTraverseEvent(Cell cell, TraverseEvent event) {
        Cell cell2edit = null;
        if (event.detail == 8) {
            event.doit = false;
            if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                cell2edit = this.searchCell(cell, 1);
            } else if ((this.feature & 0x10) == 16) {
                cell2edit = this.searchCell(cell, 4);
            }
        } else if (event.detail == 16) {
            event.doit = false;
            if ((event.stateMask & 0x40000) == 262144 && (this.feature & 8) == 8) {
                cell2edit = this.searchCell(cell, 2);
            } else if ((this.feature & 0x10) == 16) {
                cell2edit = this.searchCell(cell, 8);
            }
        }
        if (cell2edit != null) {
            this.agileGrid.setRedraw(false);
            this.agileGrid.focusCell(cell2edit);
            this.agileGrid.scrollToFocus(false);
            EditorActivationEvent acEvent = new EditorActivationEvent(cell2edit, null, event);
            this.agileGrid.triggerEditorActivationEvent(acEvent, null);
            this.agileGrid.setRedraw(true);
        }
    }

    private Cell searchCell(Cell cell, int direction) {
        Cell searchedCell = null;
        Cell newCell = this.agileGrid.getNeighbor(cell, direction, true);
        if (newCell != null) {
            searchedCell = this.cellEditorProvider.canEdit(newCell.row, newCell.column) ? newCell : this.searchCell(newCell, direction);
        } else {
            if ((this.feature & 4) == 4) {
                if (direction == 8) {
                    newCell = new Cell(this.agileGrid, cell.row, 0);
                } else if (direction == 4) {
                    newCell = new Cell(this.agileGrid, cell.row, this.agileGrid.getLayoutAdvisor().getColumnCount() - 1);
                }
            } else if ((this.feature & 2) == 2) {
                if (direction == 1) {
                    newCell = new Cell(this.agileGrid, 0, cell.column);
                } else if (direction == 2) {
                    newCell = new Cell(this.agileGrid, this.agileGrid.getLayoutAdvisor().getRowCount() - 1, cell.column);
                }
            }
            searchedCell = newCell != null && !this.cellEditorProvider.canEdit(newCell.row, newCell.column) ? this.searchCell(newCell, direction) : newCell;
        }
        return searchedCell;
    }

    protected AgileGrid getAgileGrid() {
        return this.agileGrid;
    }

    void updateCellEditorBounds() {
        if (this.isCellEditorActive()) {
            if (!this.agileGrid.isCellVisible(this.cell.row, this.cell.column)) {
                Rectangle hide = new Rectangle(-101, -101, 100, 100);
                this.cellEditor.setBounds(hide);
            } else {
                this.cellEditor.updateBounds(this.cell);
            }
        }
    }

    boolean isActiveCell(int row, int col) {
        return this.isCellEditorActive() && col == this.cell.column && row == this.cell.row;
    }

    void setCellEditorProvider(ICellEditorProvider cellEditorProvider) {
        this.cellEditorProvider = cellEditorProvider;
    }

    ICellEditorProvider getCellEditorProvider() {
        return this.cellEditorProvider;
    }

    boolean canEdit(int row, int col) {
        return !this.isCellEditorActive() && this.cellEditorProvider != null && this.cellEditorProvider.canEdit(row, col);
    }

    EditorActivationStrategy getEditorActivationStrategy() {
        return this.editorActivationStrategy;
    }

    void setEditorActivationStrategy(EditorActivationStrategy editorActivationStrategy) {
        if (this.editorActivationStrategy != null) {
            this.editorActivationStrategy.setEnableEditorActivationWithKeyboard(false);
        }
        this.editorActivationStrategy = editorActivationStrategy;
    }

    int getFeature() {
        return this.feature;
    }

    void setFeature(int feature) {
        this.feature = feature;
    }
}

