/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.IContentProvider;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.ISelectionChangedListener;
import org.agilemore.agilegrid.SelectionChangedEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;

public class AgileGridActionHandler {
    static final char TAB = '\t';
    static final String PlatformLineDelimiter = System.getProperty("line.separator");
    public CopyAction copyAction;
    public CopyAllAction copyAllAction;
    public CutAction cutAction;
    public PasteAction pasteAction;
    public SelectAllAction selectAllAction;
    protected AgileGrid agileGrid;
    protected MenuManager contextMenuManager;

    public AgileGridActionHandler(AgileGrid agileGrid) {
        this.agileGrid = agileGrid;
        this.createActions();
        this.registerActionUpdater();
        this.contextMenuManager = new MenuManager("#PopupMenu");
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AgileGridActionHandler.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.contextMenuManager.createContextMenu((Control)this.agileGrid);
        this.agileGrid.setMenu(menu);
    }

    public MenuManager getMenuManager() {
        return this.contextMenuManager;
    }

    protected void createActions() {
        this.copyAction = new CopyAction();
        this.copyAllAction = new CopyAllAction();
        this.pasteAction = new PasteAction();
        this.cutAction = new CutAction();
        this.selectAllAction = new SelectAllAction();
    }

    protected void fillContextMenu(IMenuManager menumanager) {
        menumanager.add((IAction)this.copyAction);
        menumanager.add((IAction)this.cutAction);
        menumanager.add((IAction)this.pasteAction);
        menumanager.add((IContributionItem)new Separator());
        menumanager.add((IAction)this.copyAllAction);
        menumanager.add((IAction)this.selectAllAction);
        menumanager.add((IContributionItem)new Separator());
        menumanager.add((IContributionItem)new Separator("additions"));
    }

    public void registerGlobalActions(IActionBars actionBar) {
        actionBar.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBar.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBar.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBar.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        actionBar.updateActionBars();
    }

    protected void setClipboardContent(Cell[] selection) throws SWTError {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        HTMLTransfer htmlTransfer = HTMLTransfer.getInstance();
        String plainText = this.getTextForSelection(selection);
        String htmlText = this.getHTMLForSelection(selection);
        Clipboard clipboard = new Clipboard(this.agileGrid.getDisplay());
        try {
            try {
                clipboard.setContents((Object[])new String[]{plainText, htmlText}, new Transfer[]{plainTextTransfer, htmlTransfer});
            }
            catch (SWTError error) {
                if (error.code != 2002) {
                    throw error;
                }
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    private Cell[] findAgileGridDimensions(Cell[] selection) {
        Cell topLeft = new Cell(this.agileGrid, -1, -1);
        Cell bottomRight = new Cell(this.agileGrid, -1, -1);
        int i = 0;
        while (i < selection.length) {
            Cell cell = selection[i];
            if (topLeft.column < 0) {
                topLeft.column = cell.column;
            } else if (topLeft.column > cell.column) {
                topLeft.column = cell.column;
            }
            if (bottomRight.column < 0) {
                bottomRight.column = cell.column;
            } else if (bottomRight.column < cell.column) {
                bottomRight.column = cell.column;
            }
            if (topLeft.row < 0) {
                topLeft.row = cell.row;
            } else if (topLeft.row > cell.row) {
                topLeft.row = cell.row;
            }
            if (bottomRight.row < 0) {
                bottomRight.row = cell.row;
            } else if (bottomRight.row < cell.row) {
                bottomRight.row = cell.row;
            }
            ++i;
        }
        return new Cell[]{topLeft, bottomRight};
    }

    private Cell findCellSpanning(int row, int col, ILayoutAdvisor layoutAdvisor) {
        Cell spanning = new Cell(this.agileGrid, 1, 1);
        Cell cell = new Cell(this.agileGrid, row, col);
        while (layoutAdvisor.mergeInto(col + spanning.column, row).equals(cell)) {
            ++spanning.column;
        }
        while (layoutAdvisor.mergeInto(col, row + spanning.row).equals(cell)) {
            ++spanning.row;
        }
        return spanning;
    }

    protected String getHTMLForSelection(Cell[] selection) {
        StringBuffer html = new StringBuffer();
        this.sortSelectedCells(selection);
        Cell[] dimensions = this.findAgileGridDimensions(selection);
        Cell topLeft = dimensions[0];
        Cell bottomRight = dimensions[1];
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        IContentProvider model = this.agileGrid.getContentProvider();
        if (layoutAdvisor == null) {
            return "";
        }
        html.append("Version:1.0\n");
        html.append("StartHTML:0000000000\n");
        html.append("EndHTML:0000000000\n");
        html.append("StartFragment:0000000000\n");
        html.append("EndFragment:0000000000\n");
        html.append("<html><body><table>");
        Cell nextValidCell = selection[0];
        int selCounter = 1;
        int row = topLeft.row;
        while (row <= bottomRight.row) {
            html.append("<tr>");
            int col = topLeft.column;
            while (col <= bottomRight.column) {
                if (layoutAdvisor.mergeInto(col, row).equals(new Point(col, row))) {
                    if (nextValidCell.column == col && nextValidCell.column == row) {
                        html.append("<td");
                        Cell spanning = this.findCellSpanning(row, col, layoutAdvisor);
                        if (spanning.row > 1) {
                            html.append(" rowspan=\"" + spanning.row + "\"");
                        }
                        if (spanning.column > 1) {
                            html.append(" colspan=\"" + spanning.column + "\"");
                        }
                        html.append(">");
                        Object content = model.getContentAt(col, row);
                        html.append(this.maskHtmlChars(content.toString()));
                        if (selCounter < selection.length) {
                            nextValidCell = selection[selCounter];
                            ++selCounter;
                        }
                    } else {
                        html.append("<td>");
                    }
                    html.append("</td>");
                }
                ++col;
            }
            html.append("</tr>");
            ++row;
        }
        html.append("</table></body></html>");
        return html.toString();
    }

    private String maskHtmlChars(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("\ufffd", "&auml;");
        text = text.replaceAll("\ufffd", "&Auml;");
        text = text.replaceAll("\ufffd", "&ouml;");
        text = text.replaceAll("\ufffd", "&Ouml;");
        text = text.replaceAll("\ufffd", "&uuml;");
        text = text.replaceAll("\ufffd", "&Uuml;");
        text = text.replaceAll("\ufffd", "&szlig;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("<", "&lt");
        text = text.replaceAll(">", "&gt");
        text = text.replaceAll("\ufffd", "&euro;");
        return text;
    }

    /*
     * Unable to fully structure code
     */
    protected String getTextForSelection(Cell[] selection) {
        text = new StringBuffer();
        topLeft = this.sortSelectedCells(selection);
        model = this.agileGrid.getContentProvider();
        if (model == null) {
            return "";
        }
        currentCol = topLeft.column;
        i = 0;
        ** GOTO lbl27
        {
            text.append('\t');
            ++currentCol;
            do {
                if (currentCol < selection[i].column) continue block0;
                content = model.getContentAt(selection[i].row, selection[i].column);
                text.append(content.toString());
                if (i + 1 < selection.length) {
                    row = selection[i].row;
                    while (row < selection[i + 1].row) {
                        text.append(AgileGridActionHandler.PlatformLineDelimiter);
                        ++row;
                    }
                    if (selection[i].row != selection[i + 1].row) {
                        currentCol = topLeft.column;
                    }
                }
                ++i;
lbl27:
                // 2 sources

            } while (i < selection.length);
        }
        return text.toString();
    }

    protected Cell sortSelectedCells(Cell[] selection) {
        Arrays.sort(selection, new Comparator<Cell>(){

            @Override
            public int compare(Cell c1, Cell c2) {
                if (c1.row < c2.row) {
                    return -1;
                }
                if (c1.row > c2.row) {
                    return 1;
                }
                if (c1.column < c2.column) {
                    return -1;
                }
                if (c1.column > c2.column) {
                    return 1;
                }
                return 0;
            }
        });
        int minCol = selection[0].column;
        int i = 1;
        while (i < selection.length) {
            if (selection[i].column < minCol) {
                minCol = selection[i].column;
            }
            ++i;
        }
        return new Cell(this.agileGrid, selection[0].row, minCol);
    }

    protected String getRTFForSelection(Cell[] selection) {
        return this.getTextForSelection(selection);
    }

    protected void registerActionUpdater() {
        this.agileGrid.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                AgileGridActionHandler.this.updateActions();
            }
        });
    }

    protected void updateActions() {
        this.copyAction.updateEnabledState();
        this.copyAllAction.updateEnabledState();
        this.cutAction.updateEnabledState();
        this.pasteAction.updateEnabledState();
        this.selectAllAction.updateEnabledState();
    }

    protected class CopyAction
    extends Action {
        protected CopyAction() {
            this.setId("AgileGridCopyActionHandler");
            this.setEnabled(false);
            this.setText("Copy");
        }

        public void run() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                AgileGridActionHandler.this.setClipboardContent(AgileGridActionHandler.this.agileGrid.getCellSelection());
            }
        }

        public void updateEnabledState() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                Cell[] selection = AgileGridActionHandler.this.agileGrid.getCellSelection();
                this.setEnabled(selection != null && selection.length > 0);
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class CopyAllAction
    extends Action {
        protected CopyAllAction() {
            this.setId("AgileGridCopyAllActionHandler");
            this.setEnabled(false);
            this.setText("Copy All");
        }

        public void run() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                AgileGridActionHandler.this.setClipboardContent(this.getAllAgileGridCells());
            }
        }

        public void updateEnabledState() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        private Cell[] getAllAgileGridCells() {
            ILayoutAdvisor layoutAdvisor = AgileGridActionHandler.this.agileGrid.getLayoutAdvisor();
            if (layoutAdvisor == null) {
                return new Cell[0];
            }
            Vector<Cell> cells = new Vector<Cell>(layoutAdvisor.getColumnCount() * layoutAdvisor.getRowCount());
            int row = 0;
            while (row < layoutAdvisor.getRowCount()) {
                int col = 0;
                while (col < layoutAdvisor.getColumnCount()) {
                    Cell valid = layoutAdvisor.mergeInto(col, row);
                    if (valid.row == row && valid.column == col) {
                        cells.add(valid);
                    }
                    ++col;
                }
                ++row;
            }
            return cells.toArray(new Cell[0]);
        }
    }

    protected class CutAction
    extends Action {
        protected CutAction() {
            this.setId("AgileGridCutActionHandler");
            this.setEnabled(false);
            this.setText("Cut");
        }

        public void run() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                Cell[] selection = AgileGridActionHandler.this.agileGrid.getCellSelection();
                AgileGridActionHandler.this.setClipboardContent(selection);
                this.removeContentAt(selection);
            }
        }

        public void updateEnabledState() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                Cell[] selection = AgileGridActionHandler.this.agileGrid.getCellSelection();
                this.setEnabled(selection != null && selection.length > 0);
            } else {
                this.setEnabled(false);
            }
        }

        protected void removeContentAt(Cell[] selection) {
            IContentProvider model = AgileGridActionHandler.this.agileGrid.getContentProvider();
            if (model == null) {
                return;
            }
            boolean updateSeperateCells = selection.length <= 4;
            try {
                if (!updateSeperateCells) {
                    AgileGridActionHandler.this.agileGrid.setRedraw(false);
                }
                int i = 0;
                while (i < selection.length) {
                    model.setContentAt(selection[i].row, selection[i].column, "");
                    ++i;
                }
                if (updateSeperateCells) {
                    AgileGridActionHandler.this.agileGrid.redrawCells(selection);
                }
            }
            finally {
                if (!updateSeperateCells) {
                    AgileGridActionHandler.this.agileGrid.setRedraw(true);
                }
            }
        }
    }

    protected class PasteAction
    extends Action {
        protected PasteAction() {
            this.setId("AgileGridPasteActionHandler");
            this.setEnabled(false);
            this.setText("Paste");
        }

        public void run() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                this.pasteToSelection(this.getTextFromClipboard(), AgileGridActionHandler.this.agileGrid.getCellSelection());
            }
        }

        protected String getTextFromClipboard() {
            Clipboard clipboard = new Clipboard(AgileGridActionHandler.this.agileGrid.getDisplay());
            try {
                String string = clipboard.getContents((Transfer)TextTransfer.getInstance()).toString();
                return string;
            }
            catch (Exception ex) {
                return "";
            }
            finally {
                clipboard.dispose();
            }
        }

        protected void pasteToSelection(String text, Cell[] selection) {
            if (selection == null || selection.length == 0) {
                return;
            }
            IContentProvider model = AgileGridActionHandler.this.agileGrid.getContentProvider();
            if (model == null) {
                return;
            }
            try {
                AgileGridActionHandler.this.agileGrid.setRedraw(false);
                AgileGridActionHandler.this.agileGrid.clearSelection();
                Vector<Cell> sel = new Vector<Cell>();
                String[][] cellTexts = this.parseCellTexts(text);
                int row = 0;
                while (row < cellTexts.length) {
                    int col = 0;
                    while (col < cellTexts[row].length) {
                        model.setContentAt(row + selection[0].row, col + selection[0].column, cellTexts[row][col]);
                        sel.add(new Cell(AgileGridActionHandler.this.agileGrid, row + selection[0].row, col + selection[0].column));
                        ++col;
                    }
                    ++row;
                }
                AgileGridActionHandler.this.agileGrid.selectCells(sel.toArray(new Cell[0]));
            }
            finally {
                AgileGridActionHandler.this.agileGrid.setRedraw(true);
            }
        }

        protected String[][] parseCellTexts(String text) {
            if (!AgileGridActionHandler.this.agileGrid.isMultiSelectMode()) {
                return new String[][]{{text}};
            }
            String[] lines = text.split(PlatformLineDelimiter);
            String[][] cellText = new String[lines.length][];
            int line = 0;
            while (line < lines.length) {
                cellText[line] = lines[line].split("\t");
                ++line;
            }
            return cellText;
        }

        public void updateEnabledState() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed()) {
                Cell[] selection = AgileGridActionHandler.this.agileGrid.getCellSelection();
                if (selection == null) {
                    this.setEnabled(false);
                } else if (selection.length > 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class SelectAllAction
    extends Action {
        protected SelectAllAction() {
            this.setId("AgileGridSelectAllActionHandler");
            this.setEnabled(false);
            this.setText("Select All");
        }

        public void run() {
            ILayoutAdvisor layoutAdvisor;
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed() && (layoutAdvisor = AgileGridActionHandler.this.agileGrid.getLayoutAdvisor()) != null) {
                this.selectAll(layoutAdvisor);
            }
        }

        public void updateEnabledState() {
            if (AgileGridActionHandler.this.agileGrid != null && !AgileGridActionHandler.this.agileGrid.isDisposed() && AgileGridActionHandler.this.agileGrid.isMultiSelectMode()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        protected void selectAll(ILayoutAdvisor layoutAdvisor) {
            Vector<Cell> sel = new Vector<Cell>();
            int row = 0;
            while (row < layoutAdvisor.getRowCount()) {
                int col = 0;
                while (col < layoutAdvisor.getColumnCount()) {
                    Cell cell = layoutAdvisor.mergeInto(col, row);
                    if (cell.column == col && cell.row == row) {
                        sel.add(cell);
                    }
                    ++col;
                }
                ++row;
            }
            try {
                AgileGridActionHandler.this.agileGrid.setRedraw(false);
                AgileGridActionHandler.this.agileGrid.clearSelection();
                AgileGridActionHandler.this.agileGrid.selectCells(sel.toArray(new Cell[0]));
            }
            finally {
                AgileGridActionHandler.this.agileGrid.setRedraw(true);
            }
        }
    }
}

