/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.renderers.AbstractCellRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TextCellRenderer
extends AbstractCellRenderer {
    public TextCellRenderer(AgileGrid agileGrid) {
        super(agileGrid);
    }

    public TextCellRenderer(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    @Override
    protected void initialColor(int row, int col) {
        if (this.agileGrid.isCellSelected(row, col)) {
            this.background = COLOR_BGSELECTION;
        }
    }

    @Override
    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        if (content == null) {
            return;
        }
        if ((this.style & 0x200) != 0) {
            this.drawVerticalTextImage(gc, rect, content.toString(), null, this.foreground, this.background);
        } else {
            int alignment = this.getAlignment();
            this.drawTextImage(gc, content.toString(), alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
        }
    }
}

