/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.renderers.AbstractCellRenderer;
import org.agilemore.agilegrid.renderers.IPercentage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class BarDiagramCellRenderer
extends AbstractCellRenderer {
    public BarDiagramCellRenderer(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    @Override
    public int getOptimalWidth(GC gc, int row, int col) {
        return 20;
    }

    @Override
    protected void initialColor(int row, int col) {
        if (this.agileGrid.isCellSelected(row, col)) {
            if ((this.style & 0x10) != 0) {
                this.background = COLOR_BGSELECTION;
            } else if ((this.style & 0x20) != 0) {
                this.background = COLOR_BGROWSELECTION;
            }
        }
    }

    @Override
    protected void clearCellContentRect(GC gc, Rectangle rect) {
    }

    @Override
    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        this.drawBar(gc, rect, content);
    }

    protected void drawBar(GC gc, Rectangle rect, Object content) {
        float fraction = content instanceof Float ? ((Float)content).floatValue() : (content instanceof Double ? ((Double)content).floatValue() : (content instanceof IPercentage ? ((IPercentage)content).getPercentage() : 1.0f));
        if (fraction > 1.0f) {
            fraction = 1.0f;
        }
        if (fraction < 0.0f) {
            fraction = 0.0f;
        }
        if ((this.style & 0x100) != 0) {
            this.drawGradientBar(gc, rect, fraction, this.background, this.foreground);
        } else {
            this.drawNormalBar(gc, rect, fraction, this.background, this.foreground);
        }
    }

    protected void drawGradientBar(GC gc, Rectangle rect, float fraction, Color background, Color foreground) {
        int barWidth = Math.round((float)rect.width * fraction);
        gc.setForeground(background);
        gc.setBackground(foreground);
        gc.fillGradientRectangle(rect.x, rect.y, barWidth, rect.height, false);
        gc.setBackground(COLOR_BACKGROUND);
        gc.fillRectangle(rect.x + barWidth, rect.y, rect.width - barWidth, rect.height);
    }

    protected void drawNormalBar(GC gc, Rectangle rect, float fraction, Color background, Color foreground) {
        int barWidth = Math.round((float)rect.width * fraction);
        gc.setBackground(foreground);
        gc.fillRectangle(rect.x, rect.y, barWidth, rect.height);
        gc.setBackground(background);
        gc.fillRectangle(rect.x + barWidth, rect.y, rect.width - barWidth, rect.height);
    }
}

