/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;

public class Cell {
    public AgileGrid agileGrid;
    public static final Cell NULLCELL = new Cell(null, Integer.MIN_VALUE, Integer.MIN_VALUE);
    public int row;
    public int column;

    public Cell(Cell cell) {
        this.agileGrid = cell.agileGrid;
        this.row = cell.row;
        this.column = cell.column;
    }

    public Cell(AgileGrid agileGrid, int row, int column) {
        this.agileGrid = agileGrid;
        this.row = row;
        this.column = column;
    }

    public Object getElement() {
        return this.agileGrid.getContentAt(this.row, this.column);
    }

    public void setElement(Object element) {
        this.agileGrid.setContentAt(this.row, this.column, element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cell c = (Cell)object;
        return c.row == this.row && c.column == this.column && this.agileGrid == c.agileGrid;
    }

    public int hashCode() {
        return this.row ^ this.column;
    }

    public AgileGrid getAgileGrid() {
        return this.agileGrid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(this.row);
        sb.append(',');
        sb.append(this.column);
        sb.append(']');
        return sb.toString();
    }
}

