/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class NumberFilter
extends AbstractAttributeFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.IS, (Enum[])new IFilter.Operator[]{IFilter.Operator.IS_NOT, IFilter.Operator.BETWEEN, IFilter.Operator.GREATER, IFilter.Operator.SMALLER, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});
    private AttributeDefinition attributeDefinition;
    private IFilter.Operator operator;
    private Comparable<Number> value1;
    private Comparable<Number> value2;

    public NumberFilter(IFilter.Operator operator, BigInteger value1, BigInteger value2, AttributeDefinitionInteger attributeDefinition) {
        this.init(operator, value1, value2, (AttributeDefinition)attributeDefinition);
    }

    public NumberFilter(IFilter.Operator operator, Double value1, Double value2, AttributeDefinitionReal attributeDefinition) {
        this.init(operator, value1, value2, (AttributeDefinition)attributeDefinition);
    }

    public NumberFilter(IFilter.Operator operator, Number value1, Number value2, AttributeDefinition attributeDefinition) {
        this.init(operator, (Comparable)((Object)value1), (Comparable)((Object)value2), attributeDefinition);
    }

    private void init(IFilter.Operator operator, Comparable<? extends Number> value1, Comparable<? extends Number> value2, AttributeDefinition attributeDefinition) {
        if (!SUPPORTED_OPERATORS.contains((Object)operator)) {
            throw new IllegalArgumentException("This filter does not support the " + operator.toString() + " operation");
        }
        if (value1 == null && operator != IFilter.Operator.IS_SET && operator != IFilter.Operator.IS_NOT_SET) {
            throw new IllegalArgumentException("value1 can not be null");
        }
        if (operator.equals((Object)IFilter.Operator.BETWEEN) && value2 == null) {
            throw new IllegalArgumentException("value2 can not be null");
        }
        this.attributeDefinition = attributeDefinition;
        this.operator = operator;
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        if (this.operator == IFilter.Operator.IS_SET || this.operator == IFilter.Operator.IS_NOT_SET) {
            return super.match(element);
        }
        Number theValue = this.getTheValue(element);
        if (theValue == null) {
            theValue = this.getDefaultValue(element);
        }
        if (theValue == null) {
            return this.operator.equals((Object)IFilter.Operator.IS_NOT);
        }
        switch (this.operator) {
            case IS: {
                return this.value1.compareTo(theValue) == 0;
            }
            case IS_NOT: {
                return this.value1.compareTo(theValue) != 0;
            }
            case BETWEEN: {
                return this.value1.compareTo(theValue) <= 0 && this.value2.compareTo(theValue) >= 0;
            }
            case GREATER: {
                return this.value1.compareTo(theValue) <= 0;
            }
            case SMALLER: {
                return this.value1.compareTo(theValue) >= 0;
            }
        }
        throw new IllegalArgumentException("This filter does not support the " + (Object)((Object)this.operator) + " operation");
    }

    private Number getDefaultValue(SpecElementWithAttributes element) {
        if (!AbstractAttributeFilter.isSetAttribute(element, this.attributeDefinition)) {
            return null;
        }
        if (this.attributeDefinition instanceof AttributeDefinitionInteger) {
            AttributeDefinitionInteger ad = (AttributeDefinitionInteger)this.attributeDefinition;
            if (!ad.isSetDefaultValue()) {
                return null;
            }
            if (!ad.getDefaultValue().isSetTheValue()) {
                return null;
            }
            return ad.getDefaultValue().getTheValue();
        }
        if (this.attributeDefinition instanceof AttributeDefinitionReal) {
            AttributeDefinitionReal ad = (AttributeDefinitionReal)this.attributeDefinition;
            if (!ad.isSetDefaultValue()) {
                return null;
            }
            if (!ad.getDefaultValue().isSetTheValue()) {
                return null;
            }
            return ad.getDefaultValue().getTheValue();
        }
        throw new IllegalStateException("Expected an AttributeDefinitionInteger or AttributeDefinitionReal as attribute but found " + this.attributeDefinition.getClass());
    }

    private Number getTheValue(SpecElementWithAttributes element) {
        if (this.attributeDefinition instanceof AttributeDefinitionInteger) {
            AttributeValueInteger attributeValue = (AttributeValueInteger)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
            if (attributeValue == null || !attributeValue.isSetTheValue()) {
                return null;
            }
            return attributeValue.getTheValue();
        }
        if (this.attributeDefinition instanceof AttributeDefinitionReal) {
            AttributeValueReal attributeValue = (AttributeValueReal)ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition);
            if (attributeValue == null || !attributeValue.isSetTheValue()) {
                return null;
            }
            return attributeValue.getTheValue();
        }
        throw new IllegalArgumentException("SpecElementType is not supported");
    }

    public AttributeDefinition getAttribute() {
        return this.attributeDefinition;
    }

    @Override
    public IFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public Number getFilterValue1() {
        return (Number)((Object)this.value1);
    }

    @Override
    public Number getFilterValue2() {
        return (Number)((Object)this.value2);
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }
}

