/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.editors;

import java.text.MessageFormat;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextCellEditor
extends CellEditor {
    protected Text text;
    private ModifyListener modifyListener;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;
    private static final int defaultStyle = 4;

    public TextCellEditor(AgileGrid agileGrid) {
        this(agileGrid, 4);
    }

    public TextCellEditor(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    private void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(AgileGrid agileGrid) {
        this.text = new Text((Composite)agileGrid, this.getStyle());
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TextCellEditor.this.checkSelection();
                TextCellEditor.this.checkDeleteable();
                TextCellEditor.this.checkSelectable();
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TextCellEditor.this.focusLost();
            }
        });
        this.text.setFont(agileGrid.getFont());
        this.text.setText("");
        this.text.addModifyListener(this.getModifyListener());
        return this.text;
    }

    protected Object doGetValue() {
        return this.text.getText();
    }

    protected void doSetFocus() {
        if (this.text != null) {
            this.text.selectAll();
            this.text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        this.text.removeModifyListener(this.getModifyListener());
        this.text.setText(value == null ? "" : value.toString());
        this.text.addModifyListener(this.getModifyListener());
    }

    protected void editOccured(ModifyEvent e) {
        String value = this.text.getText();
        if (value == null) {
            value = "";
        }
        String typedValue = value;
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(typedValue);
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextCellEditor.this.editOccured(e);
                }
            };
        }
        return this.modifyListener;
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getSelectionCount() > 0 || this.text.getCaretPosition() < this.text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.text != null && !this.text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.text == null || this.text.isDisposed()) {
            return false;
        }
        return this.text.getCharCount() > 0;
    }

    public void performCopy() {
        this.text.copy();
    }

    public void performCut() {
        this.text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.text.getSelectionCount() > 0) {
            this.text.insert("");
        } else {
            int pos = this.text.getCaretPosition();
            if (pos < this.text.getCharCount()) {
                this.text.setSelection(pos, pos + 1);
                this.text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    protected boolean dependsOnExternalFocusListener() {
        return this.getClass() != TextCellEditor.class;
    }

    public void activate(EditorActivationEvent activationEvent) {
        if (activationEvent.sourceEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)activationEvent.sourceEvent;
            if (keyEvent.keyCode == 127) {
                this.text.setText("");
                this.fireApplyEditorValue();
                return;
            }
        }
        super.activate(activationEvent);
        this.text.selectAll();
    }

    protected void onTraverse(TraverseEvent e) {
        if (e.keyCode == 0x1000003) {
            if (this.text.getCaretPosition() == 0 && this.text.getSelectionCount() == 0) {
                super.onTraverse(e);
            }
        } else if (e.keyCode == 0x1000004) {
            if (this.text.getCaretPosition() == this.text.getText().length() && this.text.getSelectionCount() == 0) {
                super.onTraverse(e);
            }
        } else if (e.detail == 2 || e.detail == 4) {
            e.doit = false;
        } else {
            super.onTraverse(e);
        }
    }

    protected void onKeyPressed(KeyEvent keyEvent) {
        Control ctrl = this.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
        super.onKeyPressed(keyEvent);
    }
}

